/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.problems;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.util.internal.TextUtil;

public class DefaultCatalogProblemBuilder {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    public static final String VERSION_CATALOG_PROBLEMS = "version_catalog_problems";

    public static void maybeThrowError(InternalProblems problemsService, String error, Collection<Problem> problems) {
        if (!problems.isEmpty()) {
            throw DefaultCatalogProblemBuilder.throwErrorWithNewProblemsApi(problemsService, error, problems);
        }
    }

    public static RuntimeException throwErrorWithNewProblemsApi(InternalProblems problemsService, String error, Collection<Problem> problems) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(error);
        formatter.startChildren();
        for (Problem problem : problems) {
            DefaultCatalogProblemBuilder.reportInto(formatter, problem);
            problemsService.getInternalReporter().report(problem);
        }
        formatter.endChildren();
        throw new InvalidUserDataException(formatter.toString());
    }

    private static void reportInto(TreeFormatter output, Problem problem) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(problem.getLabel());
        if (problem.getDetails() != null) {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot((String)problem.getDetails())));
        }
        TypeValidationProblemRenderer.renderSolutions((TreeFormatter)formatter, (List)problem.getSolutions());
        DocLink documentationLink = problem.getDocumentationLink();
        if (documentationLink != null) {
            formatter.blankLine();
            formatter.node(DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information", documentationLink));
        }
        output.node(formatter.toString());
    }

    @Nonnull
    public static String getProblemInVersionCatalog(VersionCatalogBuilder builder) {
        return DefaultCatalogProblemBuilder.getProblemInVersionCatalog(builder.getName());
    }

    @Nonnull
    public static String getProblemInVersionCatalog(String name) {
        return "Problem: " + DefaultCatalogProblemBuilder.getInVersionCatalog(name);
    }

    @Nonnull
    public static String getInVersionCatalog(String name) {
        return "In version catalog " + name;
    }
}

