/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentMetadata, LocalComponentMetadata>
implements LocalComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final boolean adHoc;
    private final ConcurrentMap<String, DefaultLocalConfigurationGraphResolveState> configurations = new ConcurrentHashMap<String, DefaultLocalConfigurationGraphResolveState>();
    private final Lazy<Optional<List<? extends VariantGraphResolveState>>> allVariantsForGraphResolution = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(variant -> this.getConfiguration(variant.getName()).asVariant()).collect(Collectors.toList())));
    private final Lazy<Optional<List<VariantArtifactResolveState>>> allVariantsForArtifactSelection = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(variant -> this.getConfiguration(variant.getName()).asVariant().prepareForArtifactResolution()).collect(Collectors.toList())));
    private final Lazy<List<ResolvedVariantResult>> selectableVariantResults;

    public DefaultLocalComponentGraphResolveState(long instanceId, LocalComponentMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, boolean adHoc) {
        super(instanceId, metadata, metadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.adHoc = adHoc;
        this.selectableVariantResults = Lazy.locking().of(() -> metadata.getVariantsForGraphTraversal().orElse(Collections.emptyList()).stream().map(LocalConfigurationGraphResolveMetadata.class::cast).flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList()));
    }

    @Override
    public void reevaluate() {
        this.configurations.clear();
        ((LocalComponentMetadata)this.getArtifactMetadata()).reevaluate();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public boolean isAdHoc() {
        return this.adHoc;
    }

    @Override
    public LocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        return ((LocalComponentMetadata)this.getMetadata()).copy(componentIdentifier, artifacts);
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new LocalComponentArtifactResolveMetadata((LocalComponentMetadata)this.getMetadata());
    }

    @Override
    public ModuleSources getSources() {
        return ((LocalComponentMetadata)this.getMetadata()).getSources();
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return (List)this.selectableVariantResults.get();
    }

    @Override
    protected Optional<List<? extends VariantGraphResolveState>> getVariantsForGraphTraversal() {
        return (Optional)this.allVariantsForGraphResolution.get();
    }

    @Override
    public Optional<List<VariantArtifactResolveState>> getVariantsForArtifactSelection() {
        return (Optional)this.allVariantsForArtifactSelection.get();
    }

    @Override
    @Nullable
    public ConfigurationGraphResolveState getConfiguration(String configurationName) {
        return this.configurations.computeIfAbsent(configurationName, n -> {
            LocalConfigurationMetadata configuration = ((LocalComponentMetadata)this.getMetadata()).getConfiguration(configurationName);
            if (configuration == null) {
                return null;
            }
            return new DefaultLocalConfigurationGraphResolveState(this.idGenerator.nextVariantId(), (LocalComponentMetadata)this.getMetadata(), configuration);
        });
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final LocalComponentMetadata metadata;

        public LocalComponentArtifactResolveMetadata(LocalComponentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class DefaultLocalConfigurationArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final LocalComponentMetadata component;
        private final LocalConfigurationGraphResolveMetadata graphSelectedConfiguration;
        private final Set<? extends VariantResolveMetadata> variants;

        public DefaultLocalConfigurationArtifactResolveState(LocalComponentMetadata component, LocalConfigurationGraphResolveMetadata graphSelectedConfiguration, Set<? extends VariantResolveMetadata> variants) {
            this.component = component;
            this.graphSelectedConfiguration = graphSelectedConfiguration;
            this.variants = variants;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedConfiguration.prepareToResolveArtifacts().getArtifacts();
        }

        @Override
        public ResolvedVariant resolveAdhocVariant(VariantArtifactResolver variantResolver, List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.graphSelectedConfiguration.prepareToResolveArtifacts().artifact(dependencyArtifact));
            }
            return variantResolver.resolveAdhocVariant(new LocalComponentArtifactResolveMetadata(this.component), (ImmutableList<? extends ComponentArtifactMetadata>)artifacts.build());
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.variants;
        }
    }

    private class DefaultLocalConfigurationGraphResolveState
    extends AbstractComponentGraphResolveState.AbstractVariantGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final LocalConfigurationMetadata configuration;
        private final Lazy<DefaultLocalConfigurationArtifactResolveState> artifactResolveState;

        public DefaultLocalConfigurationGraphResolveState(long instanceId, LocalComponentMetadata component, LocalConfigurationMetadata configuration) {
            super(DefaultLocalComponentGraphResolveState.this);
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = Lazy.atomic().of(() -> {
                Set<? extends VariantResolveMetadata> legacyVariants = configuration.prepareToResolveArtifacts().getVariants();
                return new DefaultLocalConfigurationArtifactResolveState(component, configuration, legacyVariants);
            });
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            return (VariantArtifactGraphResolveMetadata)this.artifactResolveState.get();
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

