/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.artifacts.verification.signatures.BuildTreeDefinedKeys;
import org.gradle.api.internal.artifacts.verification.signatures.CrossBuildCachingKeyService;
import org.gradle.api.internal.artifacts.verification.signatures.CrossBuildSignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationResultBuilder;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.scopes.BuildScopedCacheBuilderFactory;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.local.FileResourceListener;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.security.internal.EmptyPublicKeyService;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyDownloadService;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;
import org.gradle.util.internal.BuildCommencedTimeProvider;

@ServiceScope(value=Scopes.Build.class)
public class DefaultSignatureVerificationServiceFactory
implements SignatureVerificationServiceFactory {
    private static final HashCode NO_KEYRING_FILE_HASH = Hashing.signature(DefaultSignatureVerificationServiceFactory.class);
    private final RepositoryTransportFactory transportFactory;
    private final GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory;
    private final InMemoryCacheDecoratorFactory decoratorFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final FileHasher fileHasher;
    private final BuildScopedCacheBuilderFactory buildScopedCacheBuilderFactory;
    private final BuildCommencedTimeProvider timeProvider;
    private final boolean refreshKeys;
    private final FileResourceListener fileResourceListener;

    public DefaultSignatureVerificationServiceFactory(RepositoryTransportFactory transportFactory, GlobalScopedCacheBuilderFactory globalScopedCacheBuilderFactory, InMemoryCacheDecoratorFactory decoratorFactory, BuildOperationExecutor buildOperationExecutor, FileHasher fileHasher, BuildScopedCacheBuilderFactory buildScopedCacheBuilderFactory, BuildCommencedTimeProvider timeProvider, boolean refreshKeys, FileResourceListener fileResourceListener) {
        this.transportFactory = transportFactory;
        this.globalScopedCacheBuilderFactory = globalScopedCacheBuilderFactory;
        this.decoratorFactory = decoratorFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.fileHasher = fileHasher;
        this.buildScopedCacheBuilderFactory = buildScopedCacheBuilderFactory;
        this.timeProvider = timeProvider;
        this.refreshKeys = refreshKeys;
        this.fileResourceListener = fileResourceListener;
    }

    @Override
    public SignatureVerificationService create(BuildTreeDefinedKeys keyrings, List<URI> keyServers, boolean useKeyServers) {
        Object keyService;
        boolean refreshKeys = this.refreshKeys || !useKeyServers;
        ExternalResourceRepository repository = this.transportFactory.createTransport("https", "https", Collections.emptyList(), redirectLocations -> {}).getRepository();
        if (useKeyServers) {
            PublicKeyDownloadService keyDownloadService = new PublicKeyDownloadService((List)ImmutableList.copyOf(keyServers), repository);
            keyService = new CrossBuildCachingKeyService(this.globalScopedCacheBuilderFactory, this.decoratorFactory, this.buildOperationExecutor, (PublicKeyService)keyDownloadService, this.timeProvider, refreshKeys);
        } else {
            keyService = EmptyPublicKeyService.getInstance();
        }
        keyService = keyrings.applyTo((PublicKeyService)keyService);
        File effectiveKeyringsFile = keyrings.getEffectiveKeyringsFile();
        HashCode keyringFileHash = this.observed(effectiveKeyringsFile).exists() ? this.fileHasher.hash(effectiveKeyringsFile) : NO_KEYRING_FILE_HASH;
        DefaultSignatureVerificationService delegate = new DefaultSignatureVerificationService((PublicKeyService)keyService);
        return new CrossBuildSignatureVerificationService(delegate, this.fileHasher, this.buildScopedCacheBuilderFactory, this.decoratorFactory, this.timeProvider, refreshKeys, useKeyServers, keyringFileHash);
    }

    private File observed(File file) {
        this.fileResourceListener.fileObserved(file);
        return file;
    }

    private static class DefaultSignatureVerificationService
    implements SignatureVerificationService {
        private final PublicKeyService keyService;

        public DefaultSignatureVerificationService(PublicKeyService keyService) {
            this.keyService = keyService;
        }

        @Override
        public void verify(final File origin, File signature, final Set<String> trustedKeys, final Set<String> ignoredKeys, final SignatureVerificationResultBuilder result) {
            PGPSignatureList pgpSignatures = SecuritySupport.readSignatures((File)signature);
            for (final PGPSignature pgpSignature : pgpSignatures) {
                String longIdKey = SecuritySupport.toLongIdHexString((long)pgpSignature.getKeyID());
                if (ignoredKeys.contains(longIdKey)) {
                    result.ignored(longIdKey);
                    continue;
                }
                final AtomicBoolean missing = new AtomicBoolean(true);
                this.keyService.findByLongId(pgpSignature.getKeyID(), new PublicKeyResultBuilder(){

                    public void keyRing(PGPPublicKeyRing keyring) {
                    }

                    public void publicKey(PGPPublicKey pgpPublicKey) {
                        missing.set(false);
                        String fingerprint = Fingerprint.of((PGPPublicKey)pgpPublicKey).toString();
                        if (ignoredKeys.contains(fingerprint)) {
                            result.ignored(fingerprint);
                            return;
                        }
                        try {
                            boolean verified = SecuritySupport.verify((File)origin, (PGPSignature)pgpSignature, (PGPPublicKey)pgpPublicKey);
                            if (!verified) {
                                result.failed(pgpPublicKey);
                            } else {
                                boolean trusted = trustedKeys.contains(fingerprint) || trustedKeys.contains(SecuritySupport.toLongIdHexString((long)pgpPublicKey.getKeyID()));
                                result.verified(pgpPublicKey, trusted);
                            }
                        }
                        catch (PGPException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                });
                if (!missing.get()) continue;
                result.missingKey(longIdKey);
            }
        }

        @Override
        public PublicKeyService getPublicKeyService() {
            return this.keyService;
        }

        public void stop() {
            try {
                this.keyService.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

