/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.plugin.devel.tasks.internal.PropertyValidationAccess;
import org.gradle.plugin.devel.tasks.internal.ValidationProblemSerialization;
import org.gradle.util.internal.TextUtil;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class ValidateAction
implements WorkAction<Params> {
    private static final Logger LOGGER = Logging.getLogger(ValidateAction.class);

    public void execute() {
        ArrayList<Problem> taskValidationProblems = new ArrayList<Problem>();
        Params params = (Params)this.getParameters();
        params.getClasses().getAsFileTree().visit((FileVisitor)new ValidationProblemCollector(taskValidationProblems, params));
        ValidateAction.storeResults(taskValidationProblems, params.getOutputFile());
    }

    private static void storeResults(List<Problem> problemMessages, RegularFileProperty outputFile) {
        if (outputFile.isPresent()) {
            File output = ((RegularFile)outputFile.get()).getAsFile();
            try {
                output.createNewFile();
                Gson gson = ValidationProblemSerialization.createGsonBuilder().create();
                Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson.toJson(problemMessages));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static class ValidationProblemCollector
    extends EmptyFileVisitor {
        private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private final List<Problem> taskValidationProblems;
        private final Params params;

        public ValidationProblemCollector(List<Problem> taskValidationProblems, Params params) {
            this.taskValidationProblems = taskValidationProblems;
            this.params = params;
        }

        public void visitFile(FileVisitDetails fileDetails) {
            if (!fileDetails.getPath().endsWith(".class")) {
                return;
            }
            List<String> classNames = ValidationProblemCollector.getClassNames(fileDetails);
            for (String className : classNames) {
                Class<?> clazz;
                try {
                    clazz = this.classLoader.loadClass(className);
                }
                catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError | VerifyError e) {
                    LOGGER.debug("Could not load class: " + className, e);
                    continue;
                }
                ValidationProblemCollector.collectValidationProblems(clazz, this.taskValidationProblems, (Boolean)this.params.getEnableStricterValidation().get());
            }
        }

        private static void collectValidationProblems(Class<?> topLevelBean, List<Problem> problems, boolean enableStricterValidation) {
            DefaultTypeValidationContext validationContext = ValidationProblemCollector.createTypeValidationContext(topLevelBean, enableStricterValidation);
            PropertyValidationAccess.collectValidationProblems(topLevelBean, (TypeValidationContext)validationContext);
            problems.addAll((Collection<Problem>)validationContext.getProblems());
        }

        private static DefaultTypeValidationContext createTypeValidationContext(Class<?> topLevelBean, boolean enableStricterValidation) {
            if (Task.class.isAssignableFrom(topLevelBean)) {
                return ValidationProblemCollector.createValidationContextAndValidateCacheableAnnotations(topLevelBean, CacheableTask.class, enableStricterValidation);
            }
            if (TransformAction.class.isAssignableFrom(topLevelBean)) {
                return ValidationProblemCollector.createValidationContextAndValidateCacheableAnnotations(topLevelBean, CacheableTransform.class, enableStricterValidation);
            }
            return ValidationProblemCollector.createValidationContext(topLevelBean, enableStricterValidation);
        }

        private static DefaultTypeValidationContext createValidationContextAndValidateCacheableAnnotations(Class<?> topLevelBean, Class<? extends Annotation> cacheableAnnotationClass, boolean enableStricterValidation) {
            boolean cacheable = topLevelBean.isAnnotationPresent(cacheableAnnotationClass);
            DefaultTypeValidationContext validationContext = ValidationProblemCollector.createValidationContext(topLevelBean, cacheable || enableStricterValidation);
            if (enableStricterValidation) {
                ValidationProblemCollector.validateCacheabilityAnnotationPresent(topLevelBean, cacheable, cacheableAnnotationClass, validationContext);
            }
            return validationContext;
        }

        private static DefaultTypeValidationContext createValidationContext(Class<?> topLevelBean, boolean reportCacheabilityProblems) {
            return DefaultTypeValidationContext.withRootType(topLevelBean, (boolean)reportCacheabilityProblems);
        }

        private static void validateCacheabilityAnnotationPresent(Class<?> topLevelBean, boolean cacheable, Class<? extends Annotation> cacheableAnnotationClass, DefaultTypeValidationContext validationContext) {
            if (topLevelBean.isInterface()) {
                return;
            }
            if (!cacheable && topLevelBean.getAnnotation(DisableCachingByDefault.class) == null && topLevelBean.getAnnotation(UntrackedTask.class) == null) {
                boolean isTask = Task.class.isAssignableFrom(topLevelBean);
                String cacheableAnnotation = "@" + cacheableAnnotationClass.getSimpleName();
                String disableCachingAnnotation = "@" + DisableCachingByDefault.class.getSimpleName();
                String untrackedTaskAnnotation = "@" + UntrackedTask.class.getSimpleName();
                String workType = isTask ? "task" : "transform action";
                validationContext.visitTypeProblem(problem -> {
                    InternalProblemSpec builder = problem.withAnnotationType(topLevelBean).label("must be annotated either with " + cacheableAnnotation + " or with " + disableCachingAnnotation).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"disable_caching_by_default")).category("type-validation", new String[]{"type", TextUtil.screamingSnakeToKebabCase((String)"NOT_CACHEABLE_WITHOUT_REASON")}).severity(Severity.WARNING).details("The " + workType + " author should make clear why a " + workType + " is not cacheable").solution("Add " + disableCachingAnnotation + "(because = ...)").solution("Add " + cacheableAnnotation);
                    if (isTask) {
                        builder.solution("Add " + untrackedTaskAnnotation + "(because = ...)");
                    }
                });
            }
        }

        private static List<String> getClassNames(FileVisitDetails fileDetails) {
            ClassReader reader = ValidationProblemCollector.createClassReader(fileDetails);
            ArrayList<String> classNames = new ArrayList<String>();
            reader.accept((ClassVisitor)new TaskNameCollectorVisitor(classNames), 1);
            return classNames;
        }

        private static ClassReader createClassReader(FileVisitDetails fileDetails) {
            try {
                return new ClassReader(Files.asByteSource((File)fileDetails.getFile()).read());
            }
            catch (IOException e) {
                throw new org.gradle.api.UncheckedIOException((Throwable)e);
            }
        }
    }

    private static class TaskNameCollectorVisitor
    extends ClassVisitor {
        private final Collection<String> classNames;

        public TaskNameCollectorVisitor(Collection<String> classNames) {
            super(589824);
            this.classNames = classNames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 1) != 0) {
                this.classNames.add(name.replace('/', '.'));
            }
        }
    }

    public static interface Params
    extends WorkParameters {
        public ConfigurableFileCollection getClasses();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getEnableStricterValidation();
    }
}

