/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.transformers;

import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.locations.PluginIdLocation;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.internal.OperationListener;
import org.gradle.problems.internal.transformers.BaseLocationTransformer;

public class PluginIdLocationTransformer
extends BaseLocationTransformer {
    public PluginIdLocationTransformer(BuildOperationAncestryTracker buildOperationAncestryTracker, OperationListener operationListener) {
        super(buildOperationAncestryTracker, operationListener);
    }

    public Problem transform(Problem problem) {
        this.getExecuteTask(DefaultPluginManager.OperationDetails.class).ifPresent(id -> {
            try {
                DefaultPluginManager.OperationDetails operationDetails = this.operationListener.getOp((OperationIdentifier)id, DefaultPluginManager.OperationDetails.class);
                Objects.requireNonNull(operationDetails, "operationDetails should not be null");
                String pluginId = operationDetails.getPluginId();
                if (pluginId != null) {
                    problem.getLocations().add(new PluginIdLocation(pluginId));
                }
            }
            catch (Exception ex) {
                throw new GradleException("Problem meanwhile reporting problem", (Throwable)ex);
            }
        });
        return problem;
    }
}

