/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.transforms.BaseClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransformFactory;
import org.gradle.internal.classpath.transforms.MultiReleaseClasspathElementTransformForLegacy;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.file.FileException;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.JarUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value=Scopes.UserHome.class)
public class ClasspathElementTransformFactoryForLegacy
implements ClasspathElementTransformFactory {
    private final ClasspathBuilder classpathBuilder;
    private final ClasspathWalker classpathWalker;

    public ClasspathElementTransformFactoryForLegacy(ClasspathBuilder classpathBuilder, ClasspathWalker classpathWalker) {
        this.classpathBuilder = classpathBuilder;
        this.classpathWalker = classpathWalker;
    }

    @Override
    public void applyConfigurationTo(Hasher hasher) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClasspathElementTransform createTransformer(File source, ClassTransform classTransform, InstrumentingTypeRegistry typeRegistry) {
        Boolean isMultiReleaseJar = null;
        if (source.isFile()) {
            try (ZipInput entries2 = FileZipInput.create((File)source);){
                for (ZipEntry entry : entries2) {
                    String entryName = entry.getName();
                    if (this.isJarSignatureFile(entryName)) {
                        SkipClasspathElementTransform skipClasspathElementTransform = new SkipClasspathElementTransform(source);
                        return skipClasspathElementTransform;
                    }
                    if (isMultiReleaseJar != null || !JarUtil.isManifestName(entryName)) continue;
                    isMultiReleaseJar = JarUtil.isMultiReleaseJarManifest(JarUtil.readManifest(entry.getContent()));
                }
            }
            catch (FileException entries2) {
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (isMultiReleaseJar == null) return new BaseClasspathElementTransform(source, this.classpathBuilder, this.classpathWalker, typeRegistry, classTransform);
        if (isMultiReleaseJar == false) return new BaseClasspathElementTransform(source, this.classpathBuilder, this.classpathWalker, typeRegistry, classTransform);
        return new MultiReleaseClasspathElementTransformForLegacy(source, this.classpathBuilder, this.classpathWalker, typeRegistry, classTransform);
    }

    private boolean isJarSignatureFile(String entryName) {
        return entryName.startsWith("META-INF/") && entryName.endsWith(".SF");
    }

    public String toString() {
        return "TransformFactory(legacy)";
    }

    private static class SkipClasspathElementTransform
    implements ClasspathElementTransform {
        private static final Logger LOGGER = LoggerFactory.getLogger(SkipClasspathElementTransform.class);
        private final File source;

        public SkipClasspathElementTransform(File source) {
            this.source = source;
        }

        @Override
        public void transform(File destination) {
            LOGGER.debug("Archive '{}' rejected by policy. Skipping instrumentation.", (Object)this.source.getName());
            GFileUtils.copyFile((File)this.source, (File)destination);
        }
    }
}

