/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.plugin.devel.tasks.internal.ValidateAction;
import org.gradle.plugin.devel.tasks.internal.ValidationProblemSerialization;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ValidatePlugins
extends DefaultTask {
    public ValidatePlugins() {
        this.getEnableStricterValidation().convention((Object)false);
        this.getIgnoreFailures().convention((Object)false);
        this.getFailOnWarning().convention((Object)true);
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().findByType(JavaToolchainService.class);
        if (service != null) {
            this.getLauncher().convention(service.launcherFor(spec -> {}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public void validateTaskClasses() throws IOException {
        this.getWorkerExecutor().processIsolation(spec -> {
            if (this.getLauncher().isPresent()) {
                spec.getForkOptions().setExecutable((Object)((JavaLauncher)this.getLauncher().get()).getExecutablePath());
            } else {
                ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Using task ValidatePlugins without applying the Java Toolchain plugin.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "validate_plugins_without_java_toolchain")).nagUser();
                spec.getForkOptions().setExecutable((Object)Jvm.current().getJavaExecutable());
            }
            spec.getClasspath().setFrom(new Object[]{this.getClasses(), this.getClasspath()});
        }).submit(ValidateAction.class, params -> {
            params.getClasses().setFrom((Iterable)this.getClasses());
            params.getOutputFile().set((Provider)this.getOutputFile());
            params.getEnableStricterValidation().set(this.getEnableStricterValidation());
        });
        this.getWorkerExecutor().await();
        List<DefaultProblem> problemMessages = ValidationProblemSerialization.parseMessageList(new String(Files.readAllBytes(((RegularFile)this.getOutputFile().get()).getAsFile().toPath())));
        Problems problems = (Problems)this.getServices().get(Problems.class);
        Stream<String> messages = ValidationProblemSerialization.toPlainMessage(problemMessages).sorted();
        if (problemMessages.isEmpty()) {
            this.getLogger().info("Plugin validation finished without warnings.");
            return;
        }
        if (!((Boolean)this.getFailOnWarning().get()).booleanValue() && !problemMessages.stream().anyMatch(problem -> problem.getSeverity() == Severity.ERROR)) {
            this.getLogger().warn("Plugin validation finished with warnings:{}", (Object)messages.collect(Collectors.joining()));
            return;
        }
        if (((Boolean)this.getIgnoreFailures().get()).booleanValue()) {
            this.getLogger().warn("Plugin validation finished with errors. {} {}", (Object)this.annotateTaskPropertiesDoc(), (Object)messages.collect(Collectors.joining()));
            return;
        }
        Iterator iterator = problemMessages.stream().map(Problem.class::cast).collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            Problem problem2 = (Problem)iterator.next();
            ((InternalProblems)problems).reportAsProgressEvent(problem2);
        }
        throw WorkValidationException.forProblems((Collection)((Collection)messages.collect(ImmutableList.toImmutableList()))).withSummaryForPlugin().getWithExplanation(this.annotateTaskPropertiesDoc());
    }

    private String annotateTaskPropertiesDoc() {
        return this.getDocumentationRegistry().getDocumentationRecommendationFor("on how to annotate task properties", "incremental_build", "sec:task_input_output_annotations");
    }

    private static CharSequence toMessageList(List<DefaultProblem> problems) {
        return ValidationProblemSerialization.toPlainMessage(problems).collect(Collectors.joining());
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Nested
    @Optional
    @Incubating
    public abstract Property<JavaLauncher> getLauncher();

    @Input
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    public abstract Property<Boolean> getFailOnWarning();

    @Input
    public abstract Property<Boolean> getEnableStricterValidation();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();
}

