/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.instrumentation.api.declarations.InterceptorDeclaration;

@NonNullApi
public interface GroovyCallInterceptorsProvider {
    public static final GroovyCallInterceptorsProvider DEFAULT = () -> Stream.concat(Stream.of(Instrumented.class.getName()), InterceptorDeclaration.GROOVY_INTERCEPTORS_GENERATED_CLASS_NAMES.stream()).collect(Collectors.toList());

    public List<String> getInterceptorProviderClassNames();

    default public GroovyCallInterceptorsProvider plus(GroovyCallInterceptorsProvider other) {
        return () -> Stream.concat(this.getInterceptorProviderClassNames().stream(), other.getInterceptorProviderClassNames().stream()).collect(Collectors.toList());
    }

    public static GroovyCallInterceptorsProvider fromClass(Class<?> theClass) {
        return () -> Collections.singletonList(theClass.getName());
    }

    public static GroovyCallInterceptorsProvider fromClassName(String className) {
        return () -> Collections.singletonList(className);
    }
}

