/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class NestedBeanAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    private static final ImmutableSet<Class<?>> SUPPORTED_KEY_TYPES = ImmutableSet.of(Enum.class, Integer.class, String.class);

    public NestedBeanAnnotationHandler(Collection<Class<? extends Annotation>> allowedModifiers) {
        super(Nested.class, PropertyAnnotationHandler.Kind.OTHER, (ImmutableSet<Class<? extends Annotation>>)ImmutableSet.copyOf(allowedModifiers));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        if (Map.class.isAssignableFrom(propertyMetadata.getDeclaredType().getRawType())) {
            Class keyType = JavaReflectionUtil.extractNestedType(propertyMetadata.getDeclaredType(), Map.class, (int)0).getRawType();
            NestedBeanAnnotationHandler.validateKeyType(propertyMetadata, validationContext, keyType);
        }
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
    }

    private static String getSupportedKeyTypes() {
        return SUPPORTED_KEY_TYPES.stream().map(cls -> "'" + cls.getSimpleName() + "'").collect(Collectors.joining(", "));
    }

    private static void validateKeyType(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> keyType) {
        if (!SUPPORTED_KEY_TYPES.contains(keyType)) {
            validationContext.visitPropertyProblem((Action<? super PropertyProblemBuilder>)((Action)problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.NESTED_MAP_UNSUPPORTED_KEY_TYPE)).reportAs(Severity.WARNING)).forProperty(propertyMetadata.getPropertyName()).withDescription(() -> "where key of nested map is of type '" + keyType.getName() + "'")).happensBecause("Key of nested map must be one of the following types: " + NestedBeanAnnotationHandler.getSupportedKeyTypes())).addPossibleSolution("Change type of key to one of the following types: " + NestedBeanAnnotationHandler.getSupportedKeyTypes())).documentedAt("validation_problems", "unsupported_key_type_of_nested_map")));
        }
    }
}

