/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.capabilities.CapabilitiesMetadataInternal;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public class ImmutableCapabilities
implements CapabilitiesMetadataInternal {
    public static final ImmutableCapabilities EMPTY = new ImmutableCapabilities((Collection<? extends Capability>)ImmutableList.of());
    private final ImmutableList<ImmutableCapability> capabilities;

    public static ImmutableCapabilities of(CapabilitiesMetadata capabilities) {
        if (capabilities instanceof ImmutableCapabilities) {
            return (ImmutableCapabilities)capabilities;
        }
        return ImmutableCapabilities.of(capabilities.getCapabilities());
    }

    public static ImmutableCapabilities of(@Nullable Capability capability) {
        if (capability == null) {
            return EMPTY;
        }
        return new ImmutableCapabilities(Collections.singleton(capability));
    }

    public static ImmutableCapabilities of(@Nullable Collection<? extends Capability> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return EMPTY;
        }
        if (capabilities.size() == 1) {
            Capability single = capabilities.iterator().next();
            return ImmutableCapabilities.of(single);
        }
        return new ImmutableCapabilities(capabilities);
    }

    private ImmutableCapabilities(Collection<? extends Capability> capabilities) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Capability capability : capabilities) {
            if (capability instanceof ImmutableCapability) {
                builder.add((Object)((ImmutableCapability)capability));
                continue;
            }
            builder.add((Object)new DefaultImmutableCapability(capability.getGroup(), capability.getName(), capability.getVersion()));
        }
        this.capabilities = builder.build();
    }

    public List<ImmutableCapability> getCapabilities() {
        return this.capabilities;
    }
}

