/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"klass.declaredAnnotations");
        for (Annotation annotation : annotationArray) {
            Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
            this.processAnnotation(visitor2, annotation);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"klass.declaredMethods");
        for (Method method : methodArray) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(method.name)");
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"method.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"method.parameterAnnotations");
            Annotation[] annotationArray3 = annotationArray2;
            int n = ((Object[])annotationArray3).length;
            for (int i = 0; i < n; ++i) {
                int parameterIndex = i;
                Annotation annotations2 = annotationArray3[i];
                Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                for (Annotation annotation : annotations2) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation)) == null) continue;
                    boolean bl = false;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"klass.declaredConstructors");
        for (Constructor<?> constructor : constructorArray) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Annotation[] annotationArray;
            Intrinsics.checkNotNullExpressionValue(constructor, (String)"constructor");
            if (memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor)) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)constructor.getDeclaredAnnotations(), (String)"constructor.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)parameterAnnotations, (String)"parameterAnnotations");
            if (!(((Object[])parameterAnnotations).length == 0)) {
                int shift = constructor.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray2 = parameterAnnotations;
                int n = ((Object[])annotationArray2).length;
                for (int i = 0; i < n; ++i) {
                    int parameterIndex = i;
                    Annotation[] annotations2 = annotationArray2[i];
                    Intrinsics.checkNotNullExpressionValue((Object)annotations2, (String)"annotations");
                    for (Annotation annotation : annotations2) {
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        boolean bl = false;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"klass.declaredFields");
        for (Field field : fieldArray) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Annotation[] annotationArray;
            Name name = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(field.name)");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)field.getDeclaredAnnotations(), (String)"field.declaredAnnotations");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.processAnnotation(visitor2, annotation);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        block0: {
            Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
            if (annotationArgumentVisitor == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
            boolean bl = false;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            try {
                Intrinsics.checkNotNull((Object)method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                continue;
            }
            Object value = object;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, name, value);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            ++dimensions;
            Intrinsics.checkNotNullExpressionValue(currentClass.getComponentType(), (String)"currentClass.componentType");
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                ClassId classId = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue(classId, dimensions);
            }
            PrimitiveType primitiveType = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"get(currentClass.name).primitiveType");
            PrimitiveType primitiveType2 = primitiveType;
            if (dimensions > 0) {
                ClassId classId = ClassId.topLevel(primitiveType2.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue(classId, dimensions - 1);
            }
            ClassId classId = ClassId.topLevel(primitiveType2.getTypeFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue(classId, dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        FqName fqName2 = javaClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        if (classId == null) {
            classId = javaClassId;
        }
        ClassId kotlinClassId = classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            visitor2.visitClassLiteral(name, this.classLiteralValue((Class)value));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"if (clazz.isEnum) clazz else clazz.enclosingClass");
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
            Name name2 = Name.identifier(((Enum)value).name());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, name2);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"clazz.interfaces");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass, (String)"annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Annotation");
            this.processAnnotationArguments(v, (Annotation)value, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNullExpressionValue(componentType, (String)"componentType");
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
                    Name name3 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier((element as Enum<*>).name)");
                    v.visitEnum(enumClassId, name3);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                    v.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv;
                    Intrinsics.checkNotNullExpressionValue(componentType, (String)"componentType");
                    if (v.visitAnnotation(ReflectClassUtilKt.getClassId(componentType)) == null) continue;
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Annotation");
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value) {
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }
}

