/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAssignmentToThis", "checkInvisibleSetter", "checkValReassignmentOfNonLocalProperty", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "isInsideInitializationOfClass", "", "classType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReassignmentAndInvisibleSetterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 5 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,166:1\n24#2:167\n109#3,5:168\n108#3,3:175\n113#3:179\n63#4:173\n60#4:174\n108#5:178\n*S KotlinDebug\n*F\n+ 1 FirReassignmentAndInvisibleSetterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker\n*L\n89#1:167\n104#1:168,5\n60#1:175,3\n60#1:179\n55#1:173\n55#1:174\n60#1:178\n*E\n"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkInvisibleSetter(expression2, context, reporter);
        this.checkValReassignmentViaBackingField(expression2, context, reporter);
        this.checkValReassignmentOnValueParameter(expression2, context, reporter);
        this.checkAssignmentToThis(expression2, context, reporter);
        this.checkValReassignmentOfNonLocalProperty(expression2, context, reporter);
    }

    private final void checkInvisibleSetter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            Object object;
            KtDiagnosticFactory3<FirPropertySymbol, Visibility, CallableId> ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement;
            FirCallableSymbol callableSymbol;
            block7: {
                block6: {
                    FirRegularClassSymbol symbol2;
                    callableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
                    if (!(callableSymbol instanceof FirPropertySymbol) || !FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)callableSymbol)) break block5;
                    FirExpression explicitReceiver = expression2.getExplicitReceiver();
                    if (explicitReceiver instanceof FirSmartCastExpression && (symbol2 = FirHelpersKt.toRegularClassSymbol(((FirSmartCastExpression)explicitReceiver).getOriginalExpression().getTypeRef(), context.getSession())) != null) {
                        for (FirBasedSymbol<?> declarationSymbol : symbol2.getDeclarationSymbols()) {
                            if (!(declarationSymbol instanceof FirPropertySymbol) || !Intrinsics.areEqual((Object)((FirPropertySymbol)declarationSymbol).getName(), (Object)callableSymbol.getName()) || FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)declarationSymbol)) continue;
                            return;
                        }
                    }
                    abstractKtSourceElement = expression2.getSource();
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getINVISIBLE_SETTER();
                    object = ((FirPropertySymbol)callableSymbol).getSetterSymbol();
                    if (object == null) break block6;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getResolvedStatus().getVisibility();
                    if (object != null) break block7;
                }
                object = Visibilities.Private.INSTANCE;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)callableSymbol, object, (Object)callableSymbol.getCallableId(), (DiagnosticContext)context, null, 64, null);
        }
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        Object object;
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = expression2.getLValue();
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol = backingFieldReference.getResolvedSymbol();
            if (propertySymbol.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirPropertyAccessor it = (FirPropertyAccessor)firElement2;
                boolean bl = false;
                firElement = it.isGetter() ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((object = (FirPropertyAccessor)firElement) == null || (object = ((FirPropertyAccessor)object).getSymbol()) == null) {
            return;
        }
        Object closestGetter = object;
        if (!Intrinsics.areEqual((Object)propertySymbol.getGetterSymbol(), (Object)closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(expression2.getLValue(), false, 1, null);
        if (firValueParameterSymbol == null) {
            return;
        }
        FirValueParameterSymbol valueParameter2 = firValueParameterSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)valueParameter2, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkAssignmentToThis(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        if (expression2.getLValue() instanceof FirThisReference) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVARIABLE_EXPECTED(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkValReassignmentOfNonLocalProperty(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter) {
        boolean assignIsIllegal;
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(expression2.getLValue(), false, 1, null);
        if (firPropertySymbol == null) {
            return;
        }
        FirPropertySymbol property2 = firPropertySymbol;
        if (property2.isLocal() || property2.isVar()) {
            return;
        }
        ConeSimpleKotlinType dispatchReceiverType = property2.getDispatchReceiverType();
        boolean bl = dispatchReceiverType == null ? true : (property2 instanceof FirSyntheticPropertySymbol ? true : (property2.getHasDelegate() || !DeclarationAttributesKt.getHasBackingField(property2) ? true : (property2.getHasInitializer() ? true : (assignIsIllegal = !this.isInsideInitializationOfClass(dispatchReceiverType, context)))));
        if (assignIsIllegal) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)property2, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isInsideInitializationOfClass(ConeSimpleKotlinType classType, CheckerContext context) {
        FirSession session2 = context.getSession();
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(classType, session2);
        if (firClassifierSymbol == null) {
            return false;
        }
        FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
        for (FirDeclaration containingDeclaration : context.getContainingDeclarations()) {
            FirClassifierSymbol containingClassSymbol;
            FirClassifierSymbol firClassifierSymbol2;
            FirDeclaration firDeclaration = containingDeclaration;
            if (firDeclaration instanceof FirProperty) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)containingDeclaration);
                firClassifierSymbol2 = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2) : null;
            } else if (firDeclaration instanceof FirAnonymousInitializer) {
                ConeSimpleKotlinType coneSimpleKotlinType = ((FirAnonymousInitializer)containingDeclaration).getDispatchReceiverType();
                firClassifierSymbol2 = coneSimpleKotlinType != null ? TypeUtilsKt.toSymbol(coneSimpleKotlinType, session2) : null;
            } else if (firDeclaration instanceof FirConstructor) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)containingDeclaration);
                firClassifierSymbol2 = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2) : null;
            } else {
                firClassifierSymbol2 = null;
            }
            if (firClassifierSymbol2 == null || !Intrinsics.areEqual(containingClassSymbol = firClassifierSymbol2, classSymbol)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkInvisibleSetter$shouldInvisibleSetterBeReported(CheckerContext $context, FirVariableAssignment $expression, FirPropertySymbol symbol2) {
        Object setterFir;
        Object object = symbol2.getSetterSymbol();
        if (object == null || (object = (FirPropertyAccessor)((FirBasedSymbol)object).getFir()) == null) {
            FirCallableSymbol $this$originalForSubstitutionOverride$iv = symbol2;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
            boolean $i$f$getOriginalForSubstitutionOverride2 = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            FirCallableSymbol firCallableSymbol = (FirPropertySymbol)((FirCallableSymbol)((FirPropertySymbol)(firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null)));
            object = firCallableSymbol != null && (firCallableSymbol = ((FirPropertySymbol)firCallableSymbol).getSetterSymbol()) != null ? (FirPropertyAccessor)firCallableSymbol.getFir() : null;
        }
        if ((setterFir = object) != null) {
            FirElement firElement;
            FirElement firElement2;
            FirVisibilityChecker firVisibilityChecker;
            FirMemberDeclaration firMemberDeclaration;
            FirSession firSession;
            block5: {
                void $this$findClosest_u24default$iv;
                CheckerContext checkerContext = $context;
                firSession = $context.getSession();
                firMemberDeclaration = (FirMemberDeclaration)setterFir;
                firVisibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker($context.getSession());
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement firElement3;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirFile)) {
                        firDeclaration = null;
                    }
                    if ((firElement2 = (FirElement)((FirFile)firDeclaration)) == null) continue;
                    FirElement $i$f$getOriginalForSubstitutionOverride2 = firElement3 = firElement2;
                    boolean bl = false;
                    FirElement it = $i$f$getOriginalForSubstitutionOverride2;
                    firElement2 = true ? firElement3 : null;
                    if (firElement2 == null) {
                        continue;
                    }
                    break block5;
                }
                firElement2 = null;
            }
            FirElement firElement4 = firElement = firElement2;
            Intrinsics.checkNotNull(firElement4);
            return !FirVisibilityChecker.isVisible$default(firVisibilityChecker, firMemberDeclaration, firSession, (FirFile)firElement4, $context.getContainingDeclarations(), new ExpressionReceiverValue($expression.getDispatchReceiver()), false, null, false, null, 480, null);
        }
        return false;
    }
}

