/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.model.annotations.ModifierAnnotationCategory;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public class ServiceReferencePropertyAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    public ServiceReferencePropertyAnnotationHandler() {
        super(ServiceReference.class, PropertyAnnotationHandler.Kind.OTHER, ModifierAnnotationCategory.annotationsOf(ModifierAnnotationCategory.OPTIONAL));
    }

    public boolean isPropertyRelevant() {
        return true;
    }

    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
        propertyMetadata.getAnnotation(ServiceReference.class).ifPresent(annotation -> {
            String serviceName = annotation.value();
            TypeToken declaredType = propertyMetadata.getDeclaredType();
            Class serviceType = (Class)Cast.uncheckedCast((Object)((ParameterizedType)declaredType.getType()).getActualTypeArguments()[0]);
            visitor.visitServiceReference(propertyName, propertyMetadata.isAnnotationPresent(Optional.class), value, serviceName, (Class)Cast.uncheckedCast((Object)serviceType));
        });
    }

    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        ModelType propertyType = ModelType.of((Type)propertyMetadata.getDeclaredType().getType());
        List typeVariables = (List)Cast.uncheckedNonnullCast((Object)propertyType.getTypeVariables());
        if (typeVariables.size() != 1 || !BuildService.class.isAssignableFrom(((ModelType)typeVariables.get(0)).getRawClass())) {
            validationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.SERVICE_REFERENCE_MUST_BE_A_BUILD_SERVICE)).forProperty(propertyMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("has @ServiceReference annotation used on property of type '%s' which is not a build service implementation", ((ModelType)typeVariables.get(0)).getName()))).happensBecause(() -> String.format("A property annotated with @ServiceReference must be of a type that implements '%s'", BuildService.class.getName()))).addPossibleSolution(String.format("Make '%s' implement '%s'", ((ModelType)typeVariables.get(0)).getName(), BuildService.class.getName()))).addPossibleSolution(String.format("Replace the @ServiceReference annotation on '%s' with @Internal and assign a value of type '%s' explicitly", propertyMetadata.getPropertyName(), ((ModelType)typeVariables.get(0)).getName()))).documentedAt("validation_problems", "service_reference_must_be_a_build_service"));
        }
    }
}

