/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.Closeable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;

public class BuildScopeServiceRegistryFactory
implements ServiceRegistryFactory,
Closeable {
    private final ServiceRegistry services;
    private final CompositeStoppable registries = new CompositeStoppable();

    public BuildScopeServiceRegistryFactory(ServiceRegistry services) {
        this.services = services;
    }

    @Override
    public ServiceRegistry createFor(Object domainObject) {
        if (domainObject instanceof GradleInternal) {
            GradleScopeServices gradleServices = new GradleScopeServices(this.services);
            this.registries.add((Object)gradleServices);
            return gradleServices;
        }
        throw new IllegalArgumentException(String.format("Cannot create services for unknown domain object of type %s.", domainObject.getClass().getSimpleName()));
    }

    @Override
    public void close() {
        this.registries.stop();
    }
}

