/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Cast;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultPhasedBuildAction;
import org.gradle.tooling.internal.consumer.DefaultPhasedBuildActionExecuter;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.PhasedBuildAction;
import org.gradle.tooling.internal.consumer.ResultHandlerAdapter;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.util.internal.CollectionUtils;

class DefaultBuildActionExecuter<T>
extends AbstractLongRunningOperation<DefaultBuildActionExecuter<T>>
implements BuildActionExecuter<T> {
    private final BuildAction<T> buildAction;
    private final AsyncConsumerActionExecutor connection;

    public DefaultBuildActionExecuter(BuildAction<T> buildAction, AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.operationParamsBuilder.setEntryPoint("BuildActionExecuter API");
        this.buildAction = buildAction;
        this.connection = connection;
    }

    @Override
    protected DefaultBuildActionExecuter<T> getThis() {
        return this;
    }

    @Override
    public BuildActionExecuter<T> forTasks(String ... tasks) {
        this.operationParamsBuilder.setTasks(tasks != null ? Arrays.asList(tasks) : null);
        return this.getThis();
    }

    @Override
    public BuildActionExecuter<T> forTasks(Iterable<String> tasks) {
        this.operationParamsBuilder.setTasks(tasks != null ? CollectionUtils.toList(tasks) : null);
        return this.getThis();
    }

    @Override
    public T run() throws GradleConnectionException {
        BlockingResultHandler<Object> handler = new BlockingResultHandler<Object>(Object.class);
        this.run(handler);
        return (T)Cast.uncheckedNonnullCast((Object)handler.getResult());
    }

    @Override
    public void run(ResultHandler<? super T> handler) throws IllegalStateException {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<T>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public T run(ConsumerConnection connection) {
                Object result = connection.run(DefaultBuildActionExecuter.this.buildAction, operationParameters);
                return result;
            }
        }, new ResultHandlerAdapter<T>(handler, new ExceptionTransformer(new Transformer<String, Throwable>(){

            public String transform(Throwable throwable) {
                return String.format("Could not run build action using %s.", DefaultBuildActionExecuter.this.connection.getDisplayName());
            }
        })));
    }

    static class Builder
    implements BuildActionExecuter.Builder {
        @Nullable
        private PhasedBuildAction.BuildActionWrapper<?> projectsLoadedAction = null;
        @Nullable
        private PhasedBuildAction.BuildActionWrapper<?> buildFinishedAction = null;
        private final AsyncConsumerActionExecutor connection;
        private final ConnectionParameters parameters;

        Builder(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
            this.connection = connection;
            this.parameters = parameters;
        }

        @Override
        public <T> Builder projectsLoaded(BuildAction<T> action, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            if (this.projectsLoadedAction != null) {
                throw Builder.getException("ProjectsLoadedAction");
            }
            this.projectsLoadedAction = new DefaultPhasedBuildAction.DefaultBuildActionWrapper(action, handler);
            return this;
        }

        @Override
        public <T> Builder buildFinished(BuildAction<T> action, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            if (this.buildFinishedAction != null) {
                throw Builder.getException("BuildFinishedAction");
            }
            this.buildFinishedAction = new DefaultPhasedBuildAction.DefaultBuildActionWrapper(action, handler);
            return this;
        }

        @Override
        public BuildActionExecuter<Void> build() {
            return new DefaultPhasedBuildActionExecuter(new DefaultPhasedBuildAction(this.projectsLoadedAction, this.buildFinishedAction), this.connection, this.parameters);
        }

        private static IllegalArgumentException getException(String phase) {
            return new IllegalArgumentException(String.format("%s has already been added. Only one action per phase is allowed.", phase));
        }
    }
}

