/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyArtifactInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyDescriptorFileGenerator;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;

@UntrackedTask(because="Gradle doesn't understand the data structures")
public abstract class GenerateIvyDescriptor
extends DefaultTask {
    private Transient.Var<IvyModuleDescriptorSpec> descriptor = Transient.varOf();
    private final Cached<IvyDescriptorFileGenerator.DescriptorFileSpec> ivyDescriptorSpec = Cached.of(this::computeIvyDescriptorFileSpec);
    private Object destination;

    @Inject
    protected PathToFileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public IvyModuleDescriptorSpec getDescriptor() {
        return (IvyModuleDescriptorSpec)this.descriptor.get();
    }

    public void setDescriptor(IvyModuleDescriptorSpec descriptor) {
        this.descriptor.set((Object)descriptor);
    }

    @OutputFile
    public File getDestination() {
        return this.destination == null ? null : this.getFileResolver().resolve(this.destination);
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setDestination(Object destination) {
        this.destination = destination;
    }

    @TaskAction
    public void doGenerate() {
        ((IvyDescriptorFileGenerator.DescriptorFileSpec)this.ivyDescriptorSpec.get()).writeTo(this.getDestination());
    }

    IvyDescriptorFileGenerator.DescriptorFileSpec computeIvyDescriptorFileSpec() {
        IvyModuleDescriptorSpecInternal descriptorInternal = GenerateIvyDescriptor.toIvyModuleDescriptorInternal(this.getDescriptor());
        IvyDescriptorFileGenerator ivyGenerator = new IvyDescriptorFileGenerator(descriptorInternal.getProjectIdentity(), descriptorInternal.writeGradleMetadataMarker(), descriptorInternal.getVersionMappingStrategy());
        ivyGenerator.setStatus(descriptorInternal.getStatus());
        ivyGenerator.setBranch(descriptorInternal.getBranch());
        ivyGenerator.setExtraInfo(descriptorInternal.getExtraInfo().asMap());
        for (IvyModuleDescriptorAuthor ivyAuthor : descriptorInternal.getAuthors()) {
            ivyGenerator.addAuthor(ivyAuthor);
        }
        for (IvyModuleDescriptorLicense ivyLicense : descriptorInternal.getLicenses()) {
            ivyGenerator.addLicense(ivyLicense);
        }
        ivyGenerator.setDescription(descriptorInternal.getDescription());
        for (IvyConfiguration ivyConfiguration : descriptorInternal.getConfigurations()) {
            ivyGenerator.addConfiguration(ivyConfiguration);
        }
        for (IvyArtifact ivyArtifact : descriptorInternal.getArtifacts()) {
            ivyGenerator.addArtifact(((IvyArtifactInternal)ivyArtifact).asNormalisedArtifact());
        }
        for (IvyDependencyInternal ivyDependency : descriptorInternal.getDependencies()) {
            ivyGenerator.addDependency(ivyDependency);
        }
        for (IvyExcludeRule excludeRule : descriptorInternal.getGlobalExcludes()) {
            ivyGenerator.addGlobalExclude(excludeRule);
        }
        ivyGenerator.withXml(descriptorInternal.getXmlAction());
        return ivyGenerator.toSpec();
    }

    private static IvyModuleDescriptorSpecInternal toIvyModuleDescriptorInternal(IvyModuleDescriptorSpec ivyModuleDescriptorSpec) {
        if (ivyModuleDescriptorSpec == null) {
            return null;
        }
        if (ivyModuleDescriptorSpec instanceof IvyModuleDescriptorSpecInternal) {
            return (IvyModuleDescriptorSpecInternal)ivyModuleDescriptorSpec;
        }
        throw new InvalidUserDataException(String.format("ivyModuleDescriptor implementations must implement the '%s' interface, implementation '%s' does not", IvyModuleDescriptorSpecInternal.class.getName(), ivyModuleDescriptorSpec.getClass().getName()));
    }
}

