/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DetachedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentResultSerializer
implements Serializer<ResolvedGraphComponent> {
    private final ModuleVersionIdentifierSerializer idSerializer;
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentIdentifierSerializer componentIdSerializer;
    private final ResolvedVariantResultSerializer resolvedVariantResultSerializer;
    private final boolean returnAllVariants;

    public ComponentResultSerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedVariantResultSerializer resolvedVariantResultSerializer, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ComponentIdentifierSerializer componentIdentifierSerializer, boolean returnAllVariants) {
        this.idSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        this.resolvedVariantResultSerializer = resolvedVariantResultSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.componentIdSerializer = componentIdentifierSerializer;
        this.returnAllVariants = returnAllVariants;
    }

    void reset() {
        this.resolvedVariantResultSerializer.reset();
    }

    public ResolvedGraphComponent read(Decoder decoder) throws IOException {
        long resultId = decoder.readSmallLong();
        ModuleVersionIdentifier id = this.idSerializer.read(decoder);
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        ComponentIdentifier componentId = this.componentIdSerializer.read(decoder);
        int allVariantsSize = decoder.readSmallInt();
        ImmutableList.Builder allVariants = ImmutableList.builderWithExpectedSize((int)allVariantsSize);
        int resolvedVariantsSize = decoder.readSmallInt();
        ImmutableList.Builder resolvedVariants = ImmutableList.builderWithExpectedSize((int)resolvedVariantsSize);
        this.readVariants(decoder, allVariantsSize, resolvedVariantsSize, (ImmutableList.Builder<ResolvedVariantResult>)allVariants, (ImmutableList.Builder<ResolvedVariantResult>)resolvedVariants);
        String repositoryName = decoder.readNullableString();
        return new DetachedComponentResult(resultId, id, reason, componentId, (List<ResolvedVariantResult>)resolvedVariants.build(), (List<ResolvedVariantResult>)allVariants.build(), repositoryName);
    }

    private void readVariants(Decoder decoder, int allVariantsSize, int resolvedVariantsSize, ImmutableList.Builder<ResolvedVariantResult> allVariants, ImmutableList.Builder<ResolvedVariantResult> resolvedVariants) throws IOException {
        boolean returnAllVariants = allVariantsSize != resolvedVariantsSize;
        for (int i = 0; i < allVariantsSize; ++i) {
            ResolvedVariantResult variant = this.resolvedVariantResultSerializer.read(decoder);
            boolean isResolved = returnAllVariants ? decoder.readBoolean() : true;
            if (isResolved) {
                resolvedVariants.add((Object)variant);
            }
            allVariants.add((Object)variant);
        }
    }

    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        List<ResolvedVariantResult> resolvedVariants;
        List<ResolvedVariantResult> allVariants;
        encoder.writeSmallLong(value.getResultId().longValue());
        this.idSerializer.write(encoder, value.getModuleVersion());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        this.componentIdSerializer.write(encoder, value.getComponentId());
        if (this.returnAllVariants) {
            allVariants = value.getAllVariants();
            resolvedVariants = value.getResolvedVariants();
        } else {
            resolvedVariants = allVariants = value.getResolvedVariants();
        }
        this.writeSelectedVariantDetails(encoder, resolvedVariants, allVariants);
        encoder.writeNullableString((CharSequence)value.getRepositoryId());
    }

    private void writeSelectedVariantDetails(Encoder encoder, Collection<ResolvedVariantResult> resolvedVariants, Collection<ResolvedVariantResult> variants) throws IOException {
        encoder.writeSmallInt(variants.size());
        encoder.writeSmallInt(resolvedVariants.size());
        boolean returnAllVariants = variants.size() != resolvedVariants.size();
        for (ResolvedVariantResult variant : variants) {
            this.resolvedVariantResultSerializer.write(encoder, variant);
            if (!returnAllVariants) continue;
            encoder.writeBoolean(resolvedVariants.contains(variant));
        }
    }
}

