/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search.searches;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.search.searches.ExtensibleQueryFactory;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.QueryExecutor;
import org.jetbrains.kotlin.com.intellij.util.QueryParameters;
import org.jetbrains.kotlin.com.intellij.util.UniqueResultsQuery;
import org.jetbrains.kotlin.com.intellij.util.containers.HashingStrategy;

public final class SuperMethodsSearch
extends ExtensibleQueryFactory<MethodSignatureBackedByPsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.superMethodsSearch");
    private static final SuperMethodsSearch SUPER_METHODS_SEARCH_INSTANCE = new SuperMethodsSearch();
    private static final HashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new HashingStrategy<MethodSignatureBackedByPsiMethod>(){

        @Override
        public int hashCode(@Nullable MethodSignatureBackedByPsiMethod signature) {
            return signature == null ? 0 : signature.getMethod().hashCode();
        }

        @Override
        public boolean equals(@Nullable MethodSignatureBackedByPsiMethod s1, @Nullable MethodSignatureBackedByPsiMethod s2) {
            return s1 == s2 || s1 != null && s2 != null && s1.getMethod().equals(s2.getMethod());
        }
    };

    private SuperMethodsSearch() {
    }

    @NotNull
    public static Query<MethodSignatureBackedByPsiMethod> search(@NotNull PsiMethod derivedMethod, @Nullable PsiClass psiClass, boolean checkBases, boolean allowStaticMethod) {
        if (derivedMethod == null) {
            SuperMethodsSearch.$$$reportNull$$$0(0);
        }
        return SuperMethodsSearch.search(new SearchParameters(derivedMethod, psiClass, checkBases, allowStaticMethod));
    }

    @NotNull
    public static Query<MethodSignatureBackedByPsiMethod> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            SuperMethodsSearch.$$$reportNull$$$0(1);
        }
        return new UniqueResultsQuery(SUPER_METHODS_SEARCH_INSTANCE.createQuery(parameters), METHOD_BASED_HASHING_STRATEGY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "derivedMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/search/searches/SuperMethodsSearch";
        objectArray[2] = "search";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchParameters
    implements QueryParameters {
        private final PsiMethod myMethod;
        @Nullable
        private final PsiClass myClass;
        private final boolean myCheckBases;
        private final boolean myAllowStaticMethod;
        private final boolean myJlsOnly;

        public SearchParameters(@NotNull PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod) {
            if (method == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            this(method, aClass, checkBases, allowStaticMethod, false);
        }

        public SearchParameters(@NotNull PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod, boolean jlsOnly) {
            if (method == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myCheckBases = checkBases;
            this.myClass = aClass;
            this.myMethod = method;
            this.myAllowStaticMethod = allowStaticMethod;
            this.myJlsOnly = jlsOnly;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myMethod.getProject();
        }

        @Override
        public boolean isQueryValid() {
            return this.myMethod.isValid() && (this.myClass == null || this.myClass.isValid());
        }

        public final boolean isCheckBases() {
            return this.myCheckBases;
        }

        @NotNull
        public final PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        @Nullable
        public final PsiClass getPsiClass() {
            return this.myClass;
        }

        public final boolean isAllowStaticMethod() {
            return this.myAllowStaticMethod;
        }

        public boolean isJlsOnly() {
            return this.myJlsOnly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/searches/SuperMethodsSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/searches/SuperMethodsSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

