/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.evaluator.EvaluationFailureMessageGenerator;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailure;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailureReason;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.gradle.internal.declarativedsl.language.ParsingError;
import org.gradle.internal.declarativedsl.language.SingleFailureResult;
import org.gradle.internal.declarativedsl.language.SourceData;
import org.gradle.internal.declarativedsl.language.UnsupportedConstruct;
import org.gradle.internal.declarativedsl.objectGraph.AssignmentTraceElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0014J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010(\u001a\u00020)H\u0002\u00a8\u0006*"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator;", "", "()V", "describeDocumentCheckFailure", "", "failure", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailure;", "describeDocumentCheckFailureReason", "reason", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailureReason;", "describeResolutionErrorReason", "errorReason", "Lorg/gradle/internal/declarativedsl/analysis/ErrorReason;", "describedUnassignedValueUsage", "unassigned", "Lorg/gradle/internal/declarativedsl/objectGraph/AssignmentTraceElement$FailedToRecordAssignment;", "elementLocationString", "languageTreeElement", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "formatFailuresInLanguageTree", "", "failures", "Lorg/gradle/internal/declarativedsl/language/SingleFailureResult;", "formatParsingError", "parsingError", "Lorg/gradle/internal/declarativedsl/language/ParsingError;", "formatResolutionError", "resolutionError", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionError;", "formatUnsupportedConstruct", "unsupportedConstruct", "Lorg/gradle/internal/declarativedsl/language/UnsupportedConstruct;", "generateFailureMessage", "scriptSourceIdentifier", "stageFailures", "Lorg/gradle/internal/declarativedsl/evaluator/runner/EvaluationResult$NotEvaluated$StageFailure;", "locationPrefixString", "ast", "Lorg/gradle/internal/declarativedsl/language/SourceData;", "indent", "level", "", "declarative-dsl-evaluator"})
@SourceDebugExtension(value={"SMAP\nEvaluationFailureMessageGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationFailureMessageGenerator.kt\norg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1863#2:162\n1863#2,2:163\n1863#2,2:165\n1863#2,2:167\n1863#2,2:169\n1864#2:171\n1863#2,2:172\n*S KotlinDebug\n*F\n+ 1 EvaluationFailureMessageGenerator.kt\norg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator\n*L\n38#1:162\n43#1:163,2\n51#1:165,2\n60#1:167,2\n67#1:169,2\n38#1:171\n77#1:172,2\n*E\n"})
public final class EvaluationFailureMessageGenerator {
    @NotNull
    public static final EvaluationFailureMessageGenerator INSTANCE = new EvaluationFailureMessageGenerator();

    private EvaluationFailureMessageGenerator() {
    }

    @NotNull
    public final String generateFailureMessage(@NotNull String scriptSourceIdentifier, @NotNull List<? extends EvaluationResult.NotEvaluated.StageFailure> stageFailures) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)scriptSourceIdentifier, (String)"scriptSourceIdentifier");
        Intrinsics.checkNotNullParameter(stageFailures, (String)"stageFailures");
        StringBuilder $this$generateFailureMessage_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$generateFailureMessage_u24lambda_u245.append("Failed to interpret the declarative DSL file '" + scriptSourceIdentifier + "':");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = stageFailures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv2;
            EvaluationResult.NotEvaluated.StageFailure stageFailure = (EvaluationResult.NotEvaluated.StageFailure)element$iv;
            boolean bl2 = false;
            EvaluationResult.NotEvaluated.StageFailure stageFailure2 = stageFailure;
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree) {
                StringBuilder stringBuilder3 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent("Failures in building the language tree:", 1));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                if (!(!((Collection)((EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree)stageFailure).getFailures()).isEmpty())) continue;
                $this$forEach$iv2 = INSTANCE.formatFailuresInLanguageTree(((EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree)stageFailure).getFailures());
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (String)element$iv2;
                    boolean bl3 = false;
                    StringBuilder stringBuilder4 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent((String)it, 2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                }
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution) {
                StringBuilder stringBuilder5 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent("Failures in resolution:", 1));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution)stageFailure).getErrors();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (ResolutionError)element$iv2;
                    boolean bl4 = false;
                    StringBuilder stringBuilder6 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent(INSTANCE.formatResolutionError((ResolutionError)it), 2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)stageFailure2, (Object)EvaluationResult.NotEvaluated.StageFailure.NoParseResult.INSTANCE)) {
                StringBuilder stringBuilder7 = $this$generateFailureMessage_u24lambda_u245.append("Failed to parse due to syntax errors");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.NoSchemaAvailable) {
                StringBuilder stringBuilder8 = $this$generateFailureMessage_u24lambda_u245.append("No associated schema for " + ((EvaluationResult.NotEvaluated.StageFailure.NoSchemaAvailable)stageFailure).getScriptContext());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.AssignmentErrors) {
                StringBuilder stringBuilder9 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent("Failures in assignments:", 1));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
                $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.AssignmentErrors)stageFailure).getUsages();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AssignmentTraceElement.FailedToRecordAssignment unassigned = (AssignmentTraceElement.FailedToRecordAssignment)element$iv2;
                    boolean bl5 = false;
                    StringBuilder stringBuilder10 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent(INSTANCE.describedUnassignedValueUsage(unassigned), 2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
                }
                continue;
            }
            if (!(stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.DocumentCheckFailures)) continue;
            StringBuilder stringBuilder11 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent("Failures in document checks:", 1));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
            $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.DocumentCheckFailures)stageFailure).getFailures();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DocumentCheckFailure failure = (DocumentCheckFailure)element$iv2;
                boolean bl6 = false;
                StringBuilder stringBuilder12 = $this$generateFailureMessage_u24lambda_u245.append(INSTANCE.indent(INSTANCE.describeDocumentCheckFailure(failure), 2));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final List<String> formatFailuresInLanguageTree(List<? extends SingleFailureResult> failures) {
        List list;
        List $this$formatFailuresInLanguageTree_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = failures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleFailureResult failure = (SingleFailureResult)element$iv;
            boolean bl2 = false;
            SingleFailureResult singleFailureResult = failure;
            if (singleFailureResult instanceof UnsupportedConstruct) {
                $this$formatFailuresInLanguageTree_u24lambda_u247.add(INSTANCE.formatUnsupportedConstruct((UnsupportedConstruct)failure));
                continue;
            }
            if (!(singleFailureResult instanceof ParsingError)) continue;
            $this$formatFailuresInLanguageTree_u24lambda_u247.add(INSTANCE.formatParsingError((ParsingError)failure));
        }
        return CollectionsKt.build((List)list);
    }

    private final String formatUnsupportedConstruct(UnsupportedConstruct unsupportedConstruct) {
        return this.locationPrefixString(unsupportedConstruct.getErroneousSource()) + ": unsupported language feature: " + unsupportedConstruct.getLanguageFeature();
    }

    private final String formatParsingError(ParsingError parsingError) {
        return this.locationPrefixString(parsingError.getErroneousSource()) + ": parsing error: " + parsingError.getMessage();
    }

    private final String formatResolutionError(ResolutionError resolutionError) {
        return this.elementLocationString(resolutionError.getElement()) + ": " + this.describeResolutionErrorReason(resolutionError.getErrorReason());
    }

    private final String describeResolutionErrorReason(ErrorReason errorReason) {
        String string;
        ErrorReason errorReason2 = errorReason;
        if (errorReason2 instanceof ErrorReason.AmbiguousFunctions) {
            string = "ambiguous functions: " + CollectionsKt.joinToString$default((Iterable)((ErrorReason.AmbiguousFunctions)errorReason).getFunctions(), (CharSequence)",", null, null, (int)0, null, (Function1)describeResolutionErrorReason.1.INSTANCE, (int)30, null);
        } else if (errorReason2 instanceof ErrorReason.AmbiguousImport) {
            string = "ambiguous import '" + ((ErrorReason.AmbiguousImport)errorReason).getFqName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.AssignmentTypeMismatch) {
            string = "assignment type mismatch, expected '" + ((ErrorReason.AssignmentTypeMismatch)errorReason).getExpected() + "', got '" + ((ErrorReason.AssignmentTypeMismatch)errorReason).getActual() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.DanglingPureExpression.INSTANCE)) {
            string = "dangling pure expression";
        } else if (errorReason2 instanceof ErrorReason.DuplicateLocalValue) {
            string = "duplicate local 'val " + ((ErrorReason.DuplicateLocalValue)errorReason).getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.ExternalReassignment) {
            string = "assignment to external property";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.MissingConfigureLambda.INSTANCE)) {
            string = "a configuring block expected but not found";
        } else if (errorReason2 instanceof ErrorReason.ReadOnlyPropertyAssignment) {
            string = "assignment to read-only property '" + ((ErrorReason.ReadOnlyPropertyAssignment)errorReason).getProperty().getName();
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnitAssignment.INSTANCE)) {
            string = "assignment of a Unit value";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnresolvedAssignmentLhs.INSTANCE)) {
            string = "unresolved assignment target";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnresolvedAssignmentRhs.INSTANCE)) {
            string = "unresolved assigned value";
        } else if (errorReason2 instanceof ErrorReason.UnresolvedReference) {
            string = "unresolved reference '" + ((ErrorReason.UnresolvedReference)errorReason).getReference().getSourceData().text() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnusedConfigureLambda.INSTANCE)) {
            string = "a configuring block is not expected";
        } else if (errorReason2 instanceof ErrorReason.ValReassignment) {
            string = "assignment to a local 'val " + ((ErrorReason.ValReassignment)errorReason).getLocalVal().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallArguments) {
            string = "unresolved function call arguments for '" + ((ErrorReason.UnresolvedFunctionCallArguments)errorReason).getFunctionCall().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallReceiver) {
            string = "unresolved function call receiver for '" + ((ErrorReason.UnresolvedFunctionCallReceiver)errorReason).getFunctionCall().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallSignature) {
            string = "unresolved function call signature for '" + ((ErrorReason.UnresolvedFunctionCallSignature)errorReason).getFunctionCall().getName() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.AccessOnCurrentReceiverOnlyViolation.INSTANCE)) {
            string = "this member can only be accessed on a current receiver";
        } else if (errorReason2 instanceof ErrorReason.NonReadableProperty) {
            string = "property cannot be used as a value: '" + ((ErrorReason.NonReadableProperty)errorReason).getProperty().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.OpaqueArgumentForIdentityParameter) {
            string = "opaque identity argument: " + ((ErrorReason.OpaqueArgumentForIdentityParameter)errorReason).getParameter().getName() + " = " + ((ErrorReason.OpaqueArgumentForIdentityParameter)errorReason).getArgument().getOriginElement().getSourceData().text();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String describedUnassignedValueUsage(AssignmentTraceElement.FailedToRecordAssignment unassigned) {
        String string;
        AssignmentTraceElement.FailedToRecordAssignment failedToRecordAssignment = unassigned;
        if (failedToRecordAssignment instanceof AssignmentTraceElement.Reassignment) {
            string = "Value reassigned";
        } else if (failedToRecordAssignment instanceof AssignmentTraceElement.UnassignedValueUsed) {
            string = "Unassigned value used";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String errorMessage = string;
        return this.elementLocationString(unassigned.getLhs().getReceiverObject().getOriginElement()) + ": " + errorMessage + " in " + unassigned.getLhs() + " := " + unassigned.getRhs();
    }

    private final String elementLocationString(LanguageTreeElement languageTreeElement) {
        return this.locationPrefixString(languageTreeElement.getSourceData());
    }

    private final String describeDocumentCheckFailure(DocumentCheckFailure failure) {
        return this.locationPrefixString(failure.getLocation().getSourceData()) + ": " + this.describeDocumentCheckFailureReason(failure.getReason());
    }

    private final String describeDocumentCheckFailureReason(DocumentCheckFailureReason reason) {
        String string;
        DocumentCheckFailureReason documentCheckFailureReason = reason;
        if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.PluginManagementBlockOrderViolated.INSTANCE)) {
            string = "illegal content before 'pluginManagement', which can only appear as the first element in the file";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.PluginsBlockOrderViolated.INSTANCE)) {
            string = "illegal content before 'plugins', which can only be preceded by 'pluginManagement'";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.DuplicatePluginManagementBlock.INSTANCE)) {
            string = "duplicate 'pluginManagement'";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.DuplicatePluginsBlock.INSTANCE)) {
            string = "duplicate 'plugins'";
        } else if (documentCheckFailureReason instanceof DocumentCheckFailureReason.UnsupportedSyntaxInDocument) {
            string = "unsupported syntax (" + ((DocumentCheckFailureReason.UnsupportedSyntaxInDocument)reason).getCause() + ')';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String locationPrefixString(SourceData ast) {
        return ast.getLineRange().getFirst() != -1 ? "" + ast.getLineRange().getFirst() + ':' + ast.getStartColumn() : "";
    }

    private final String indent(String $this$indent, int level) {
        return StringsKt.repeat((CharSequence)" ", (int)(level * 2)) + $this$indent;
    }

    static /* synthetic */ String indent$default(EvaluationFailureMessageGenerator evaluationFailureMessageGenerator, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return evaluationFailureMessageGenerator.indent(string, n);
    }
}

