/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.function.Consumer;
import org.gradle.internal.execution.FileCollectionFingerprinter;
import org.gradle.internal.execution.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.execution.FileNormalizationSpec;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class DefaultInputFingerprinter
implements InputFingerprinter {
    private final FileCollectionSnapshotter snapshotter;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final ValueSnapshotter valueSnapshotter;

    public DefaultInputFingerprinter(FileCollectionSnapshotter snapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter) {
        this.snapshotter = snapshotter;
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.valueSnapshotter = valueSnapshotter;
    }

    @Override
    public InputFingerprinter.Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints, ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints, Consumer<UnitOfWork.InputVisitor> inputs) {
        InputCollectingVisitor visitor = new InputCollectingVisitor(previousValueSnapshots, previousFingerprints, this.snapshotter, this.fingerprinterRegistry, this.valueSnapshotter, knownCurrentValueSnapshots, knownCurrentFingerprints);
        inputs.accept(visitor);
        return visitor.complete();
    }

    private static class InputCollectingVisitor
    implements UnitOfWork.InputVisitor {
        private final ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots;
        private final ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints;
        private final FileCollectionSnapshotter snapshotter;
        private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
        private final ValueSnapshotter valueSnapshotter;
        private final ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints;
        private final ImmutableSortedMap.Builder<String, ValueSnapshot> valueSnapshotsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> fingerprintsBuilder = ImmutableSortedMap.naturalOrder();
        private final ImmutableSet.Builder<String> propertiesRequiringIsEmptyCheck = ImmutableSet.builder();

        public InputCollectingVisitor(ImmutableSortedMap<String, ValueSnapshot> previousValueSnapshots, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> previousFingerprints, FileCollectionSnapshotter snapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter, ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints) {
            this.previousValueSnapshots = previousValueSnapshots;
            this.previousFingerprints = previousFingerprints;
            this.snapshotter = snapshotter;
            this.fingerprinterRegistry = fingerprinterRegistry;
            this.valueSnapshotter = valueSnapshotter;
            this.knownCurrentValueSnapshots = knownCurrentValueSnapshots;
            this.knownCurrentFingerprints = knownCurrentFingerprints;
        }

        @Override
        public void visitInputProperty(String propertyName, UnitOfWork.ValueSupplier value) {
            if (this.knownCurrentValueSnapshots.containsKey((Object)propertyName)) {
                return;
            }
            Object actualValue = value.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)this.previousValueSnapshots.get((Object)propertyName);
                if (previousSnapshot == null) {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue));
                } else {
                    this.valueSnapshotsBuilder.put((Object)propertyName, (Object)this.valueSnapshotter.snapshot(actualValue, previousSnapshot));
                }
            }
            catch (Exception e) {
                throw new InputFingerprinter.InputFingerprintingException(propertyName, String.format("value '%s' cannot be serialized", value.getValue()), e);
            }
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
            if (this.knownCurrentFingerprints.containsKey((Object)propertyName)) {
                return;
            }
            FileCollectionFingerprint previousFingerprint = (FileCollectionFingerprint)this.previousFingerprints.get((Object)propertyName);
            FileNormalizationSpec normalizationSpec = DefaultFileNormalizationSpec.from(value.getNormalizer(), value.getDirectorySensitivity(), value.getLineEndingNormalization());
            FileCollectionFingerprinter fingerprinter = this.fingerprinterRegistry.getFingerprinter(normalizationSpec);
            try {
                FileCollectionSnapshotter.Result result = this.snapshotter.snapshot(value.getFiles());
                CurrentFileCollectionFingerprint fingerprint = fingerprinter.fingerprint(result.getSnapshot(), previousFingerprint);
                this.fingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
                if (result.containsArchiveTrees()) {
                    this.propertiesRequiringIsEmptyCheck.add((Object)propertyName);
                }
            }
            catch (Exception e) {
                throw new InputFingerprinter.InputFileFingerprintingException(propertyName, e);
            }
        }

        public InputFingerprinter.Result complete() {
            return new InputFingerprints(this.knownCurrentValueSnapshots, (ImmutableSortedMap<String, ValueSnapshot>)this.valueSnapshotsBuilder.build(), this.knownCurrentFingerprints, (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.fingerprintsBuilder.build(), (ImmutableSet<String>)this.propertiesRequiringIsEmptyCheck.build());
        }
    }

    @VisibleForTesting
    public static class InputFingerprints
    implements InputFingerprinter.Result {
        private final ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots;
        private final ImmutableSortedMap<String, ValueSnapshot> valueSnapshots;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints;
        private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints;
        private final ImmutableSet<String> propertiesRequiringIsEmptyCheck;

        public InputFingerprints(ImmutableSortedMap<String, ValueSnapshot> knownCurrentValueSnapshots, ImmutableSortedMap<String, ValueSnapshot> valueSnapshots, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownCurrentFingerprints, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fileFingerprints, ImmutableSet<String> propertiesRequiringIsEmptyCheck) {
            this.knownCurrentValueSnapshots = knownCurrentValueSnapshots;
            this.valueSnapshots = valueSnapshots;
            this.knownCurrentFingerprints = knownCurrentFingerprints;
            this.fileFingerprints = fileFingerprints;
            this.propertiesRequiringIsEmptyCheck = propertiesRequiringIsEmptyCheck;
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots() {
            return this.valueSnapshots;
        }

        @Override
        public ImmutableSortedMap<String, ValueSnapshot> getAllValueSnapshots() {
            return InputFingerprints.union(this.knownCurrentValueSnapshots, this.valueSnapshots);
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints() {
            return this.fileFingerprints;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getAllFileFingerprints() {
            return InputFingerprints.union(this.knownCurrentFingerprints, this.fileFingerprints);
        }

        @Override
        public ImmutableSet<String> getPropertiesRequiringIsEmptyCheck() {
            return this.propertiesRequiringIsEmptyCheck;
        }

        private static <K extends Comparable<?>, V> ImmutableSortedMap<K, V> union(ImmutableSortedMap<K, V> a, ImmutableSortedMap<K, V> b) {
            if (a.isEmpty()) {
                return b;
            }
            if (b.isEmpty()) {
                return a;
            }
            return ImmutableSortedMap.naturalOrder().putAll(a).putAll(b).build();
        }
    }
}

