/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;

public class FileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final byte[] contents;

    public FileInfo(String path, byte[] contents) {
        if (contents == null) {
            throw new NullPointerException("contents must not be null");
        }
        FileInfo.validatePath(path);
        this.contents = contents;
        this.path = path;
    }

    private static void validatePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new NullPointerException("path must not be null or blank");
        }
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public String getContentsAsString(Charset charset) {
        return new String(this.contents, charset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileInfo that = (FileInfo)obj;
        return this.path.equals(that.path) && Arrays.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "FileInfo[path='" + this.path + "', contents containing " + this.contents.length + " bytes]";
    }
}

