/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiQualifiedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public final class ExpressionUtil {
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier = PsiUtil.deparenthesizeExpression(refExpression.getQualifierExpression());
        if (qualifier == null) {
            return true;
        }
        if (qualifier instanceof PsiQualifiedExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            return innerMostClass == thisQualifier.resolve();
        }
        return false;
    }
}

