/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByAttributesException;
import org.gradle.internal.component.resolution.failure.formatting.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.type.NoVariantsWithMatchingCapabilitiesFailure;

public abstract class NoVariantsWithMatchingCapabilitiesFailureDescriber
extends AbstractResolutionFailureDescriber<NoVariantsWithMatchingCapabilitiesFailure> {
    public VariantSelectionByAttributesException describeFailure(NoVariantsWithMatchingCapabilitiesFailure failure) {
        String message = this.buildFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestReviewAlgorithm());
        return new VariantSelectionByAttributesException(message, failure, resolutions);
    }

    private String buildFailureMsg(NoVariantsWithMatchingCapabilitiesFailure failure) {
        StringBuilder sb = new StringBuilder("Unable to find a variant providing the requested ");
        sb.append(CapabilitiesDescriber.describeCapabilitiesWithTitle(failure.getRequestedCapabilities().asSet()));
        sb.append(":\n");
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            sb.append("   - Variant '").append(candidate.getDisplayName()).append("' provides ");
            sb.append(CapabilitiesDescriber.describeCapabilities(candidate.getCandidateCapabilities().asSet())).append("\n");
        }
        return sb.toString();
    }
}

