/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;

public class DefaultProvider<T>
extends AbstractMinimalProvider<T> {
    private final Callable<? extends T> value;

    public DefaultProvider(Callable<? extends T> value) {
        this.value = value;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        try {
            return this.inferTypeFromCallableGenericArgument();
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    @Nullable
    private Class<T> inferTypeFromCallableGenericArgument() {
        for (Type superType : this.value.getClass().getGenericInterfaces()) {
            Type argument;
            ParameterizedType parameterizedSuperType;
            if (!(superType instanceof ParameterizedType) || !(parameterizedSuperType = (ParameterizedType)superType).getRawType().equals(Callable.class) || !((argument = parameterizedSuperType.getActualTypeArguments()[0]) instanceof Class)) continue;
            return (Class)Cast.uncheckedCast((Object)argument);
        }
        return null;
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        EvaluationContext.ScopeContext ignored = this.openScope();
        try {
            ValueSupplier.Value<T> value = ValueSupplier.Value.ofNullable(this.value.call());
            if (ignored != null) {
                ignored.close();
            }
            return value;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }
}

