/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;
import org.jetbrains.org.objectweb.asm.Type;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<CallableDescriptor, ClassDescriptor> CLASS_FOR_CALLABLE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Type> ASM_TYPE = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    private static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<KtExpression, SamType> SAM_VALUE = Slices.createSimpleSlice();
    public static final WritableSlice<KtCallElement, KtExpression> SAM_CONSTRUCTOR_TO_ARGUMENT = Slices.createSimpleSlice();
    public static final WritableSlice<KtWhenExpression, WhenByEnumsMapping> MAPPING_FOR_WHEN_BY_ENUM = Slices.createSimpleSlice();
    public static final WritableSlice<String, List<WhenByEnumsMapping>> MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, FunctionDescriptor> SUSPEND_FUNCTION_TO_JVM_VIEW = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, Boolean> CAPTURES_CROSSINLINE_LAMBDA = Slices.createSimpleSlice();
    public static final WritableSlice<ValueParameterDescriptor, Boolean> CALL_SITE_IS_SUSPEND_FOR_CROSSINLINE_LAMBDA = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> RECURSIVE_SUSPEND_CALLABLE_REFERENCE = Slices.createSimpleSlice();
    public static final WritableSlice<ValueParameterDescriptor, ValueParameterDescriptor> PARAMETER_SYNONYM = Slices.createSimpleSlice();
    public static final WritableSlice<Type, List<VariableDescriptorWithAccessors>> DELEGATED_PROPERTIES_WITH_METADATA = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptorWithAccessors, Type> DELEGATED_PROPERTY_METADATA_OWNER = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptor, VariableDescriptor> LOCAL_VARIABLE_PROPERTY_METADATA = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, Boolean> PROPERTY_METADATA_REQUIRED_FOR_OPERATOR_CALL = Slices.createSimpleSlice();
    public static final WritableSlice<VariableDescriptorWithAccessors, Boolean> DELEGATED_PROPERTY_WITH_OPTIMIZED_METADATA = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, String> CALL_LABEL_FOR_LAMBDA_ARGUMENT = Slices.createSimpleSlice();

    private CodegenBinding() {
    }

    @Nullable
    public static List<LocalVariableDescriptor> getLocalDelegatedProperties(@NotNull BindingContext bindingContext, @NotNull Type owner) {
        List<VariableDescriptorWithAccessors> properties2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            CodegenBinding.$$$reportNull$$$0(1);
        }
        return (properties2 = bindingContext.get(DELEGATED_PROPERTIES_WITH_METADATA, owner)) == null ? null : CollectionsKt.filterIsInstance(properties2, LocalVariableDescriptor.class);
    }

    public static void initTrace(@NotNull GenerationState state, Collection<KtFile> files2) {
        if (state == null) {
            CodegenBinding.$$$reportNull$$$0(2);
        }
        CodegenAnnotatingVisitor visitor2 = new CodegenAnnotatingVisitor(state);
        for (KtFile file2 : CodegenBinding.allFilesInPackages(state.getBindingContext(), files2)) {
            PsiFile contextFile;
            PsiElement context2;
            file2.accept(visitor2);
            if (!(file2 instanceof KtCodeFragment) || (context2 = file2.getContext()) == null || (contextFile = context2.getContainingFile()) == null) continue;
            contextFile.accept(visitor2);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, KtEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext, bindingContext.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, ClassDescriptor classDescriptor2) {
        return Boolean.TRUE.equals(bindingContext.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor2));
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull KtElement expression2) {
        Type result2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(3);
        }
        if (expression2 == null) {
            CodegenBinding.$$$reportNull$$$0(4);
        }
        if ((result2 = CodegenBinding.asmTypeForAnonymousClassOrNull(bindingContext, expression2)) == null) {
            throw new KotlinExceptionWithAttachments("Couldn't compute ASM type for expression").withPsiAttachment("expression.kt", expression2);
        }
        Type type2 = result2;
        if (type2 == null) {
            CodegenBinding.$$$reportNull$$$0(5);
        }
        return type2;
    }

    @Nullable
    public static Type asmTypeForAnonymousClassOrNull(@NotNull BindingContext bindingContext, @NotNull KtElement expression2) {
        ClassDescriptor descriptor2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            CodegenBinding.$$$reportNull$$$0(7);
        }
        if (expression2 instanceof KtObjectLiteralExpression) {
            expression2 = ((KtObjectLiteralExpression)expression2).getObjectDeclaration();
        }
        if ((descriptor2 = bindingContext.get(BindingContext.CLASS, expression2)) != null) {
            return bindingContext.get(ASM_TYPE, descriptor2);
        }
        SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor != null) {
            return CodegenBinding.asmTypeForAnonymousClassOrNull(bindingContext, functionDescriptor);
        }
        VariableDescriptor variableDescriptor = bindingContext.get(BindingContext.VARIABLE, expression2);
        if (variableDescriptor != null) {
            return CodegenBinding.asmTypeForAnonymousClassOrNull(bindingContext, variableDescriptor);
        }
        return null;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull CallableDescriptor descriptor2) {
        Type result2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(8);
        }
        if (descriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(9);
        }
        if ((result2 = CodegenBinding.asmTypeForAnonymousClassOrNull(bindingContext, descriptor2)) == null) {
            throw new IllegalStateException("Type must not be null: " + descriptor2);
        }
        Type type2 = result2;
        if (type2 == null) {
            CodegenBinding.$$$reportNull$$$0(10);
        }
        return type2;
    }

    @Nullable
    public static Type asmTypeForAnonymousClassOrNull(@NotNull BindingContext bindingContext, @NotNull CallableDescriptor descriptor2) {
        ClassDescriptor classForCallable;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(12);
        }
        if ((classForCallable = bindingContext.get(CLASS_FOR_CALLABLE, descriptor2)) == null) {
            return null;
        }
        return bindingContext.get(ASM_TYPE, classForCallable);
    }

    public static boolean canHaveOuter(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor2) {
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(13);
        }
        if (classDescriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(14);
        }
        if (classDescriptor2.getKind() != ClassKind.CLASS) {
            return false;
        }
        MutableClosure closure = bindingContext.get(CLOSURE, classDescriptor2);
        if (closure == null || closure.getEnclosingClass() == null) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor2.getContainingDeclaration();
        return classDescriptor2.isInner() || containingDeclaration instanceof ScriptDescriptor || !(containingDeclaration instanceof ClassDescriptor);
    }

    @NotNull
    static MutableClosure recordClosure(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @Nullable ClassDescriptor enclosing, @NotNull Type asmType) {
        if (trace == null) {
            CodegenBinding.$$$reportNull$$$0(15);
        }
        if (classDescriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(16);
        }
        if (asmType == null) {
            CodegenBinding.$$$reportNull$$$0(17);
        }
        KtElement element = (KtElement)DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor2);
        assert (element != null) : "No source element for " + classDescriptor2;
        MutableClosure closure = new MutableClosure(classDescriptor2, enclosing);
        if (classDescriptor2.isInner()) {
            closure.setNeedsCaptureOuterClass();
        }
        trace.record(ASM_TYPE, classDescriptor2, asmType);
        trace.record(CLOSURE, classDescriptor2, closure);
        if (enclosing != null && !JvmCodegenUtil.isArgumentWhichWillBeInlined(trace.getBindingContext(), classDescriptor2)) {
            CodegenBinding.recordInnerClass(trace, enclosing, classDescriptor2);
        }
        MutableClosure mutableClosure = closure;
        if (mutableClosure == null) {
            CodegenBinding.$$$reportNull$$$0(18);
        }
        return mutableClosure;
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        Collection<ClassDescriptor> innerClasses2;
        if (bindingTrace == null) {
            CodegenBinding.$$$reportNull$$$0(19);
        }
        if (outer == null) {
            CodegenBinding.$$$reportNull$$$0(20);
        }
        if (inner == null) {
            CodegenBinding.$$$reportNull$$$0(21);
        }
        if ((innerClasses2 = bindingTrace.get(INNER_CLASSES, outer)) == null) {
            innerClasses2 = new ArrayList<ClassDescriptor>(1);
            bindingTrace.record(INNER_CLASSES, outer, innerClasses2);
        }
        innerClasses2.add(inner);
    }

    @NotNull
    private static Collection<KtFile> allFilesInPackages(BindingContext bindingContext, Collection<KtFile> files2) {
        HashSet<FqName> names2 = new HashSet<FqName>();
        for (KtFile ktFile : files2) {
            if (ktFile.isScript()) continue;
            names2.add(ktFile.getPackageFqName());
        }
        HashSet<KtFile> answer = new HashSet<KtFile>();
        answer.addAll(files2);
        for (FqName name2 : names2) {
            Collection<KtFile> ktFiles = bindingContext.get(BindingContext.PACKAGE_TO_FILES, name2);
            if (ktFiles == null) continue;
            answer.addAll(ktFiles);
        }
        ArrayList<KtFile> arrayList = new ArrayList<KtFile>(answer);
        arrayList.sort(Comparator.comparing(file2 -> {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            assert (virtualFile2 != null) : "VirtualFile is null for KtFile: " + file2.getName();
            return virtualFile2.getPath();
        }));
        ArrayList<KtFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CodegenBinding.$$$reportNull$$$0(22);
        }
        return arrayList2;
    }

    @NotNull
    public static Type getAsmType(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor klass) {
        Type type2;
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(23);
        }
        if (klass == null) {
            CodegenBinding.$$$reportNull$$$0(24);
        }
        if ((type2 = bindingContext.get(ASM_TYPE, klass)) == null) {
            throw new IllegalStateException("Type is not yet recorded for " + klass);
        }
        Type type3 = type2;
        if (type3 == null) {
            CodegenBinding.$$$reportNull$$$0(25);
        }
        return type3;
    }

    @NotNull
    public static VariableDescriptor getDelegatedLocalVariableMetadata(@NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext) {
        if (variableDescriptor == null) {
            CodegenBinding.$$$reportNull$$$0(26);
        }
        if (bindingContext == null) {
            CodegenBinding.$$$reportNull$$$0(27);
        }
        VariableDescriptor metadataVariableDescriptor = bindingContext.get(LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor);
        assert (metadataVariableDescriptor != null) : "Metadata for local delegated property should be not null: " + variableDescriptor;
        VariableDescriptor variableDescriptor2 = metadataVariableDescriptor;
        if (variableDescriptor2 == null) {
            CodegenBinding.$$$reportNull$$$0(28);
        }
        return variableDescriptor2;
    }

    static {
        BasicWritableSlice.initSliceDebugNames(CodegenBinding.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/CodegenBinding";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeForAnonymousClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClosure";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "allFilesInPackages";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsmType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegatedLocalVariableMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalDelegatedProperties";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initTrace";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeForAnonymousClass";
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeForAnonymousClassOrNull";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canHaveOuter";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "recordClosure";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "recordInnerClass";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAsmType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDelegatedLocalVariableMetadata";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 10: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

