/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;

public class LegacyConfigurationsSupplier
implements Supplier<ImmutableList<? extends ConfigurationGraphResolveMetadata>> {
    private final ComponentGraphResolveMetadata targetComponent;

    public LegacyConfigurationsSupplier(ComponentGraphResolveMetadata targetComponent) {
        this.targetComponent = targetComponent;
    }

    public ImmutableList<? extends ConfigurationGraphResolveMetadata> get() {
        Set<String> configurationNames = this.targetComponent.getConfigurationNames();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String configurationName : configurationNames) {
            ConfigurationGraphResolveMetadata configuration = this.targetComponent.getConfiguration(configurationName);
            if (!configuration.isCanBeConsumed()) continue;
            builder.add((Object)configuration);
        }
        return builder.build();
    }
}

