/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectOrderingUtil;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDestroyables;
import org.gradle.api.internal.tasks.DefaultTaskInputs;
import org.gradle.api.internal.tasks.DefaultTaskLocalState;
import org.gradle.api.internal.tasks.DefaultTaskOutputs;
import org.gradle.api.internal.tasks.DefaultTaskRequiredServices;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecutionAccessChecker;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskRequiredServices;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DescribingAndSpec;
import org.gradle.api.internal.tasks.properties.ServiceReferenceSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskDestroyables;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskLocalState;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.logging.slf4j.DefaultContextAwareTaskLogger;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.scripts.ScriptOriginUtil;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.util.Path;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;

@Deprecated
@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static final Logger BUILD_LOGGER = Logging.getLogger(Task.class);
    private static final ThreadLocal<TaskInfo> NEXT_INSTANCE = new ThreadLocal();
    private final TaskIdentity<?> identity;
    private final ProjectInternal project;
    private List<InputChangesAwareTaskAction> actions;
    private boolean enabled = true;
    private final DefaultTaskDependency dependencies;
    private final DefaultTaskDependency lifecycleDependencies;
    private final DefaultTaskDependency mustRunAfter;
    private final DefaultTaskDependency finalizedBy;
    private final DefaultTaskDependency shouldRunAfter;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private final Property<Duration> timeout;
    private DescribingAndSpec<Task> onlyIfSpec = this.createNewOnlyIfSpec();
    private String reasonNotToTrackState;
    private String reasonIncompatibleWithConfigurationCache;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private final ContextAwareTaskLogger logger = new DefaultContextAwareTaskLogger(BUILD_LOGGER);
    private final TaskMutator taskMutator;
    private ObservableList observableActionList;
    private boolean impliesSubProjects;
    private boolean hasCustomActions;
    private final TaskInputsInternal taskInputs;
    private final TaskOutputsInternal taskOutputs;
    private final TaskDestroyables taskDestroyables;
    private final TaskLocalStateInternal taskLocalState;
    private final TaskRequiredServices taskRequiredServices;
    private final TaskExecutionAccessChecker taskExecutionAccessChecker;
    private LoggingManagerInternal loggingManager;

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return NEXT_INSTANCE.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the Gradle API or DSL.", this.getClass().getName()));
        }
        this.identity = taskInfo.identity;
        this.project = taskInfo.project;
        assert (this.project != null);
        assert (this.identity.name != null);
        this.state = new TaskStateInternal();
        TaskDependencyFactory taskDependencyFactory = this.project.getTaskDependencyFactory();
        this.mustRunAfter = taskDependencyFactory.configurableDependency();
        this.finalizedBy = taskDependencyFactory.configurableDependency();
        this.shouldRunAfter = taskDependencyFactory.configurableDependency();
        this.lifecycleDependencies = taskDependencyFactory.configurableDependency();
        this.services = this.project.getServices();
        PropertyWalker propertyWalker = (PropertyWalker)this.services.get(PropertyWalker.class);
        FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)this.services.get(FileCollectionFactory.class);
        this.taskMutator = new TaskMutator(this);
        this.taskInputs = new DefaultTaskInputs(this, this.taskMutator, propertyWalker, this.project.getTaskDependencyFactory(), fileCollectionFactory);
        this.taskOutputs = new DefaultTaskOutputs(this, this.taskMutator, propertyWalker, this.project.getTaskDependencyFactory(), fileCollectionFactory);
        this.taskDestroyables = new DefaultTaskDestroyables(this.taskMutator, fileCollectionFactory);
        this.taskLocalState = new DefaultTaskLocalState(this.taskMutator, fileCollectionFactory);
        this.dependencies = taskDependencyFactory.configurableDependency(ImmutableSet.of((Object)this.taskInputs, (Object)this.lifecycleDependencies));
        this.taskRequiredServices = new DefaultTaskRequiredServices(this, this.taskMutator, propertyWalker);
        this.taskExecutionAccessChecker = (TaskExecutionAccessChecker)this.services.get(TaskExecutionAccessChecker.class);
        this.timeout = this.project.getObjects().property(Duration.class);
    }

    private void assertDynamicObject() {
        if (this.extensibleDynamicObject == null) {
            this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, this.identity.type, (InstanceGenerator)this.services.get(InstanceGenerator.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, TaskIdentity<T> identity, Callable<T> factory) {
        NEXT_INSTANCE.set(new TaskInfo(identity, project));
        try {
            Task task = (Task)GUtil.uncheckedCall(factory);
            return (T)task;
        }
        finally {
            NEXT_INSTANCE.set(null);
        }
    }

    @Override
    @Internal
    public TaskStateInternal getState() {
        return this.state;
    }

    @Internal
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Internal
    public Project getProject() {
        this.taskExecutionAccessChecker.notifyProjectAccess(this);
        return this.project;
    }

    @Internal
    public String getName() {
        return this.identity.name;
    }

    @Override
    public TaskIdentity<?> getTaskIdentity() {
        return this.identity;
    }

    @Internal
    public List<Action<? super Task>> getActions() {
        if (this.observableActionList == null) {
            this.observableActionList = new ObservableActionWrapperList(this.getTaskActions());
            this.observableActionList.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractTask.this.taskMutator.assertMutable("Task.getActions()", evt);
                }
            });
        }
        return (List)Cast.uncheckedNonnullCast((Object)this.observableActionList);
    }

    @Override
    public List<InputChangesAwareTaskAction> getTaskActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<InputChangesAwareTaskAction>(3);
        }
        return this.actions;
    }

    @Override
    public boolean hasTaskActions() {
        return this.actions != null && !this.actions.isEmpty();
    }

    public void setActions(final List<Action<? super Task>> replacements) {
        this.taskMutator.mutate("Task.setActions(List<Action>)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().clear();
                for (Action action : replacements) {
                    AbstractTask.this.doLast((Action<? super Task>)action);
                }
            }
        });
    }

    @Internal
    public TaskDependencyInternal getTaskDependencies() {
        this.taskExecutionAccessChecker.notifyTaskDependenciesAccess(this, "Task.taskDependencies");
        return this.dependencies;
    }

    @Internal
    public TaskDependencyInternal getLifecycleDependencies() {
        return this.lifecycleDependencies;
    }

    @Internal
    public Set<Object> getDependsOn() {
        this.taskExecutionAccessChecker.notifyTaskDependenciesAccess(this, "Task.dependsOn");
        return this.lifecycleDependencies.getMutableValues();
    }

    public void setDependsOn(final Iterable<?> dependsOn) {
        this.taskMutator.mutate("Task.setDependsOn(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.lifecycleDependencies.setValues(dependsOn);
            }
        });
    }

    public void onlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.onlyIf(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(onlyIfClosure, "Task satisfies onlyIf closure");
            }
        });
    }

    public void onlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.onlyIf(Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(spec, "Task satisfies onlyIf spec");
            }
        });
    }

    public void onlyIf(final String onlyIfReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.onlyIf(String, Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(spec, onlyIfReason);
            }
        });
    }

    public void setOnlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.setOnlyIf(Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(spec, "Task satisfies onlyIf spec");
            }
        });
    }

    public void setOnlyIf(final String onlyIfReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.setOnlyIf(String, Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(spec, onlyIfReason);
            }
        });
    }

    public void setOnlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.setOnlyIf(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(onlyIfClosure, "Task satisfies onlyIf closure");
            }
        });
    }

    private DescribingAndSpec<Task> createNewOnlyIfSpec() {
        return new DescribingAndSpec<Task>(new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        }, "Task is enabled");
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    public void doNotTrackState(String reasonNotToTrackState) {
        if (reasonNotToTrackState == null) {
            throw new InvalidUserDataException("notTrackingReason must not be null!");
        }
        this.taskMutator.mutate("Task.doNotTrackState(String)", () -> {
            this.reasonNotToTrackState = reasonNotToTrackState;
            return this.reasonNotToTrackState;
        });
    }

    @Override
    public Optional<String> getReasonNotToTrackState() {
        return Optional.ofNullable(this.reasonNotToTrackState);
    }

    public void notCompatibleWithConfigurationCache(String reason) {
        this.taskMutator.mutate("Task.notCompatibleWithConfigurationCache(String)", () -> {
            this.reasonIncompatibleWithConfigurationCache = reason;
        });
    }

    @Override
    public boolean isCompatibleWithConfigurationCache() {
        return this.reasonIncompatibleWithConfigurationCache == null;
    }

    @Override
    public Optional<String> getReasonTaskIsIncompatibleWithConfigurationCache() {
        return Optional.ofNullable(this.reasonIncompatibleWithConfigurationCache);
    }

    @Internal
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    @Internal
    public boolean isEnabled() {
        return this.enabled;
    }

    @Internal
    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.taskMutator.mutate("Task.setEnabled(boolean)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.enabled = enabled;
            }
        });
    }

    @Override
    public boolean getImpliesSubProjects() {
        return this.impliesSubProjects;
    }

    @Override
    public void setImpliesSubProjects(boolean impliesSubProjects) {
        this.impliesSubProjects = impliesSubProjects;
    }

    @Internal
    public String getPath() {
        return this.identity.projectPath.toString();
    }

    @Override
    public Path getIdentityPath() {
        return this.identity.identityPath;
    }

    public Task dependsOn(final Object ... paths) {
        this.taskMutator.mutate("Task.dependsOn(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.lifecycleDependencies.add(paths);
            }
        });
        return this;
    }

    public Task doFirst(Action<? super Task> action) {
        return this.doFirst("doFirst {} action", action);
    }

    public Task doFirst(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Action)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.wrap((Action<? super Task>)action, actionName));
            }
        });
        return this;
    }

    public Task doLast(Action<? super Task> action) {
        return this.doLast("doLast {} action", action);
    }

    public Task doLast(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Action)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.wrap((Action<? super Task>)action, actionName));
            }
        });
        return this;
    }

    public int compareTo(Task otherTask) {
        int depthCompare = ProjectOrderingUtil.compare(this.project, ((AbstractTask)otherTask).project);
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    @Internal
    public Logger getLogger() {
        return this.logger;
    }

    @Internal
    public LoggingManager getLogging() {
        return this.loggingManager();
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.loggingManager();
    }

    private LoggingManagerInternal loggingManager() {
        if (this.loggingManager == null) {
            this.loggingManager = (LoggingManagerInternal)this.services.getFactory(LoggingManagerInternal.class).create();
        }
        return this.loggingManager;
    }

    public Object property(String propertyName) throws MissingPropertyException {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    public boolean hasProperty(String propertyName) {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    public void setProperty(String name, Object value) {
        this.assertDynamicObject();
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Internal
    @Deprecated
    public Convention getConvention() {
        return this.getConventionVia("Task.convention");
    }

    @Internal
    public ExtensionContainer getExtensions() {
        return this.getConventionVia("Task.extensions");
    }

    private Convention getConventionVia(String invocationDescription) {
        this.notifyConventionAccess(invocationDescription);
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getConvention();
    }

    @Internal
    public DynamicObject getAsDynamicObject() {
        this.assertDynamicObject();
        return this.extensibleDynamicObject;
    }

    @Internal
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Internal
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    @Internal
    public TaskInputsInternal getInputs() {
        return this.taskInputs;
    }

    @Override
    @Internal
    public TaskOutputsInternal getOutputs() {
        return this.taskOutputs;
    }

    @Internal
    public TaskDestroyables getDestroyables() {
        return this.taskDestroyables;
    }

    @Internal
    public TaskLocalState getLocalState() {
        return this.taskLocalState;
    }

    @Internal
    protected ServiceRegistry getServices() {
        return this.services;
    }

    public Task doFirst(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.convertClosureToAction(action, "doFirst {} action"));
            }
        });
        return this;
    }

    public Task doLast(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.convertClosureToAction(action, "doLast {} action"));
            }
        });
        return this;
    }

    public Task configure(Closure closure) {
        return (Task)ConfigureUtil.configureSelf((Closure)closure, (Object)this);
    }

    @Internal
    public File getTemporaryDir() {
        return ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryDirectory(new String[]{this.getName()});
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).temporaryDirectoryFactory(new String[]{this.getName()});
    }

    private InputChangesAwareTaskAction convertClosureToAction(Closure actionClosure, String actionName) {
        return new ClosureTaskAction(actionClosure, actionName, ((UserCodeApplicationContext)this.getServices().get(UserCodeApplicationContext.class)).current());
    }

    private InputChangesAwareTaskAction wrap(Action<? super Task> action) {
        return this.wrap(action, "unnamed action");
    }

    private InputChangesAwareTaskAction wrap(Action<? super Task> action, String actionName) {
        if (action instanceof InputChangesAwareTaskAction) {
            return (InputChangesAwareTaskAction)action;
        }
        if (action instanceof ConfigureUtil.WrappedConfigureAction) {
            Closure configureClosure = ((ConfigureUtil.WrappedConfigureAction)action).getConfigureClosure();
            return this.convertClosureToAction(configureClosure, actionName);
        }
        return new TaskActionWrapper(action, actionName);
    }

    private static ImplementationSnapshot getActionImplementation(Object value, ClassLoaderHierarchyHasher hasher) {
        HashCode classLoaderHash = hasher.getClassLoaderHash(value.getClass().getClassLoader());
        String actionClassIdentifier = ScriptOriginUtil.getOriginClassIdentifier(value);
        return ImplementationSnapshot.of((String)actionClassIdentifier, (Object)value, (HashCode)classLoaderHash);
    }

    public void setMustRunAfter(final Iterable<?> mustRunAfterTasks) {
        this.taskMutator.mutate("Task.setMustRunAfter(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.mustRunAfter.setValues(mustRunAfterTasks);
            }
        });
    }

    public Task mustRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.mustRunAfter(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.mustRunAfter.add(paths);
            }
        });
        return this;
    }

    @Internal
    public TaskDependency getMustRunAfter() {
        return this.mustRunAfter;
    }

    public void setFinalizedBy(final Iterable<?> finalizedByTasks) {
        this.taskMutator.mutate("Task.setFinalizedBy(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.finalizedBy.setValues(finalizedByTasks);
            }
        });
    }

    public Task finalizedBy(final Object ... paths) {
        this.taskMutator.mutate("Task.finalizedBy(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.finalizedBy.add(paths);
            }
        });
        return this;
    }

    @Internal
    public TaskDependency getFinalizedBy() {
        return this.finalizedBy;
    }

    public TaskDependency shouldRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.shouldRunAfter(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.shouldRunAfter.add(paths);
            }
        });
        return this.shouldRunAfter;
    }

    public void setShouldRunAfter(final Iterable<?> shouldRunAfterTasks) {
        this.taskMutator.mutate("Task.setShouldRunAfter(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.shouldRunAfter.setValues(shouldRunAfterTasks);
            }
        });
    }

    @Internal
    public TaskDependency getShouldRunAfter() {
        return this.shouldRunAfter;
    }

    @Override
    public void prependParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(0, this.wrap(action));
    }

    @Override
    public void appendParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(this.wrap(action));
    }

    @Override
    public boolean isHasCustomActions() {
        return this.hasCustomActions;
    }

    @Internal
    public Property<Duration> getTimeout() {
        return this.timeout;
    }

    public void usesService(Provider<? extends BuildService<?>> service) {
        this.taskRequiredServices.registerServiceUsage(service);
    }

    @Override
    public TaskRequiredServices getRequiredServices() {
        return this.taskRequiredServices;
    }

    @Override
    public void acceptServiceReferences(Set<ServiceReferenceSpec> serviceReferences) {
        if (!this.taskRequiredServices.hasServiceReferences()) {
            BuildServiceRegistryInternal buildServiceRegistry = this.getBuildServiceRegistry();
            List asConsumedServices = serviceReferences.stream().map(it -> buildServiceRegistry.consume(it.getBuildServiceName(), it.getBuildServiceType())).collect(Collectors.toList());
            this.taskRequiredServices.acceptServiceReferences(asConsumedServices);
        }
    }

    public List<ResourceLock> getSharedResources() {
        return this.getBuildServiceRegistry().getSharedResources(this.taskRequiredServices.getElements());
    }

    private void notifyConventionAccess(String invocationDescription) {
        this.taskExecutionAccessChecker.notifyConventionAccess(this, invocationDescription);
    }

    private BuildServiceRegistryInternal getBuildServiceRegistry() {
        return (BuildServiceRegistryInternal)this.getServices().get(BuildServiceRegistryInternal.class);
    }

    private class ObservableActionWrapperList
    extends ObservableList {
        public ObservableActionWrapperList(List delegate) {
            super(delegate);
        }

        public boolean add(Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.add((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)Cast.uncheckedNonnullCast((Object)action))));
        }

        public void add(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            super.add(index, (Object)AbstractTask.this.wrap((Action<? super Task>)((Action)Cast.uncheckedNonnullCast((Object)action))));
        }

        public boolean addAll(Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(this.transformToContextAwareTaskActions((Collection)Cast.uncheckedNonnullCast((Object)actions)));
        }

        public boolean addAll(int index, Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(index, this.transformToContextAwareTaskActions((Collection)Cast.uncheckedNonnullCast((Object)actions)));
        }

        public Object set(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.set(index, (Object)AbstractTask.this.wrap((Action<? super Task>)((Action)Cast.uncheckedNonnullCast((Object)action))));
        }

        public boolean removeAll(Collection actions) {
            return super.removeAll(this.transformToContextAwareTaskActions((Collection)Cast.uncheckedNonnullCast((Object)actions)));
        }

        public boolean remove(Object action) {
            return super.remove((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)Cast.uncheckedNonnullCast((Object)action))));
        }

        private Collection<InputChangesAwareTaskAction> transformToContextAwareTaskActions(Collection<Object> c) {
            return Collections2.transform(c, input -> AbstractTask.this.wrap((Action<? super Task>)((Action)Cast.uncheckedCast((Object)input))));
        }
    }

    private static class TaskActionWrapper
    implements InputChangesAwareTaskAction {
        private final Action<? super Task> action;
        private final String maybeActionName;

        public TaskActionWrapper(Action<? super Task> action, String maybeActionName) {
            this.action = action;
            this.maybeActionName = maybeActionName;
        }

        @Override
        public void setInputChanges(InputChangesInternal inputChanges) {
        }

        @Override
        public void clearInputChanges() {
        }

        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute((Object)task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        @Override
        public ImplementationSnapshot getActionImplementation(ClassLoaderHierarchyHasher hasher) {
            return AbstractTask.getActionImplementation(this.action, hasher);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskActionWrapper)) {
                return false;
            }
            TaskActionWrapper that = (TaskActionWrapper)o;
            return this.action.equals(that.action);
        }

        public int hashCode() {
            return this.action.hashCode();
        }

        public String getDisplayName() {
            if (this.action instanceof Describable) {
                return ((Describable)this.action).getDisplayName();
            }
            return "Execute " + this.maybeActionName;
        }
    }

    private static class ClosureTaskAction
    implements InputChangesAwareTaskAction {
        private final Closure<?> closure;
        private final String actionName;
        @Nullable
        private final UserCodeApplicationContext.Application application;

        private ClosureTaskAction(Closure<?> closure, String actionName, @Nullable UserCodeApplicationContext.Application application) {
            this.closure = closure;
            this.actionName = actionName;
            this.application = application;
        }

        @Override
        public void setInputChanges(InputChangesInternal inputChanges) {
        }

        @Override
        public void clearInputChanges() {
        }

        public void execute(Task task) {
            if (this.application == null) {
                this.doExecute(task);
            } else {
                this.application.reapply(() -> this.doExecute(task));
            }
        }

        private void doExecute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        @Override
        public ImplementationSnapshot getActionImplementation(ClassLoaderHierarchyHasher hasher) {
            return AbstractTask.getActionImplementation(this.closure, hasher);
        }

        public String getDisplayName() {
            return "Execute " + this.actionName;
        }
    }

    private static class TaskInfo {
        private final TaskIdentity<?> identity;
        private final ProjectInternal project;

        private TaskInfo(TaskIdentity<?> identity, ProjectInternal project) {
            this.identity = identity;
            this.project = project;
        }
    }
}

