/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Configuration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public interface DeprecatableConfiguration
extends Configuration {
    @Nullable
    public List<String> getDeclarationAlternatives();

    @Nullable
    public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation();

    @Nullable
    public List<String> getResolutionAlternatives();

    public DeprecatableConfiguration deprecateForConsumption(Function<DeprecationMessageBuilder.DeprecateConfiguration, DeprecationMessageBuilder.WithDocumentation> var1);

    default public DeprecatableConfiguration deprecateForConsumption() {
        return this.deprecateForConsumption(depSpec -> (DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration((String)this.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations"));
    }

    public DeprecatableConfiguration deprecateForResolution(String ... var1);

    public DeprecatableConfiguration deprecateForDeclarationAgainst(String ... var1);

    public boolean isDeprecatedForConsumption();

    public boolean isDeprecatedForResolution();

    public boolean isDeprecatedForDeclarationAgainst();

    default public boolean canSafelyBeResolved() {
        if (!this.isCanBeResolved()) {
            return false;
        }
        List<String> resolutionAlternatives = this.getResolutionAlternatives();
        return resolutionAlternatives == null;
    }

    public void preventUsageMutation();

    @Incubating
    public void setCanBeDeclaredAgainst(boolean var1);

    @Incubating
    public boolean isCanBeDeclaredAgainst();
}

