/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.DecompressionCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.ScopedCache;

public class DefaultDecompressionCache
implements DecompressionCache {
    private static final String EXPANSION_CACHE_NAME = "Compressed Files Expansion Cache";
    private final PersistentCache cache;

    public DefaultDecompressionCache(ScopedCache cacheFactory) {
        this.cache = cacheFactory.crossVersionCache("expanded").withDisplayName(EXPANSION_CACHE_NAME).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
    }

    @VisibleForTesting
    public DefaultDecompressionCache(PersistentCache cache) {
        this.cache = cache;
    }

    @Override
    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public File getBaseDir() {
        return this.cache.getBaseDir();
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

