/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestClassProcessorFactory;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitPlatformTestFramework
implements TestFramework {
    private final JUnitPlatformOptions options;
    private final DefaultTestFilter filter;
    private final boolean useImplementationDependencies;

    public JUnitPlatformTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies) {
        this(filter, useImplementationDependencies, new JUnitPlatformOptions());
    }

    private JUnitPlatformTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies, JUnitPlatformOptions options) {
        this.filter = filter;
        this.useImplementationDependencies = useImplementationDependencies;
        this.options = options;
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitPlatformOptions copiedOptions = new JUnitPlatformOptions();
        copiedOptions.copyFrom(this.options);
        return new JUnitPlatformTestFramework((DefaultTestFilter)newTestFilters, this.useImplementationDependencies, copiedOptions);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        if (!JavaVersion.current().isJava8Compatible()) {
            throw new UnsupportedJavaRuntimeException("Running JUnit Platform requires Java 8+, please configure your test java executable with Java 8 or higher.");
        }
        return new JUnitPlatformTestClassProcessorFactory(new JUnitPlatformSpec(this.filter.toSpec(), this.options.getIncludeEngines(), this.options.getExcludeEngines(), this.options.getIncludeTags(), this.options.getExcludeTags()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
    }

    @Override
    public List<String> getTestWorkerApplicationClasses() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTestWorkerApplicationModules() {
        return ImmutableList.of((Object)"junit-platform-engine", (Object)"junit-platform-launcher", (Object)"junit-platform-commons");
    }

    @Override
    public boolean getUseDistributionDependencies() {
        return this.useImplementationDependencies;
    }

    @Override
    public JUnitPlatformOptions getOptions() {
        return this.options;
    }

    @Override
    public TestFrameworkDetector getDetector() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

