/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class RuntimeBeanNode<T> {
    private final T bean;
    private final String propertyName;
    private final RuntimeBeanNode<T> parentNode;

    protected RuntimeBeanNode(@Nullable RuntimeBeanNode<T> parentNode, @Nullable String propertyName, T bean) {
        this.propertyName = propertyName;
        this.parentNode = parentNode;
        this.bean = Preconditions.checkNotNull(bean, (String)"Null is not allowed as nested property '%s'", (Object)propertyName);
    }

    public T getBean() {
        return this.bean;
    }

    public abstract void visitNode(PropertyVisitor var1, Queue<RuntimeBeanNode<?>> var2, RuntimeBeanNodeFactory var3, TypeValidationContext var4);

    public RuntimeBeanNode<?> createChildNode(String propertyName, @Nullable Object input, RuntimeBeanNodeFactory nodeFactory) {
        String qualifiedPropertyName = this.getQualifiedPropertyName(propertyName);
        Object bean = Preconditions.checkNotNull((Object)input, (String)"Null is not allowed as nested property '%s'", (Object)qualifiedPropertyName);
        return nodeFactory.create(this, qualifiedPropertyName, bean);
    }

    @Nullable
    public String getPropertyName() {
        return this.propertyName;
    }

    protected String getQualifiedPropertyName(String childPropertyName) {
        return this.propertyName == null ? childPropertyName : this.propertyName + "." + childPropertyName;
    }

    public void checkCycles(String propertyName, T childBean) {
        RuntimeBeanNode<T> nodeCreatingCycle = this.findNodeCreatingCycle(childBean, Equivalence.identity());
        Preconditions.checkState((nodeCreatingCycle == null ? 1 : 0) != 0, (String)"Cycles between nested beans are not allowed. Cycle detected between: '%s' and '%s'.", nodeCreatingCycle, (Object)propertyName);
    }

    @Nullable
    private RuntimeBeanNode<T> findNodeCreatingCycle(T childValue, Equivalence<? super T> nodeEquivalence) {
        if (nodeEquivalence.equivalent(this.getBean(), childValue)) {
            return this;
        }
        if (this.parentNode == null) {
            return null;
        }
        return super.findNodeCreatingCycle(childValue, nodeEquivalence);
    }

    public String toString() {
        return this.propertyName == null ? "<root>" : this.getPropertyName();
    }
}

