/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import java.util.ArrayDeque;
import org.gradle.api.NonNullApi;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.properties.bean.RuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class DefaultPropertyWalker
implements PropertyWalker {
    private final RuntimeBeanNodeFactory nodeFactory;

    public DefaultPropertyWalker(TypeMetadataStore typeMetadataStore, ImplementationResolver implementationResolver) {
        this.nodeFactory = new RuntimeBeanNodeFactory(typeMetadataStore, implementationResolver);
    }

    @Override
    public void visitProperties(Object bean, TypeValidationContext validationContext, PropertyVisitor visitor) {
        ArrayDeque queue = new ArrayDeque();
        queue.add(this.nodeFactory.createRoot(bean));
        while (!queue.isEmpty()) {
            RuntimeBeanNode node = (RuntimeBeanNode)queue.remove();
            node.visitNode(visitor, queue, this.nodeFactory, validationContext);
        }
    }
}

