/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.DependenciesBuilder;
import org.gradle.buildinit.plugins.internal.RepositoriesBuilder;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TargetsBuilder;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TestingBuilder;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildScriptBuilder {
    private static final String INCUBATING_APIS_WARNING = "This project uses @Incubating APIs which are subject to change.";
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildScriptBuilder.class);
    private final BuildInitDsl dsl;
    private final String fileNameWithoutExtension;
    private boolean externalComments;
    private final MavenRepositoryURLHandler mavenRepoURLHandler;
    private final List<String> headerLines = new ArrayList<String>();
    private final TopLevelBlock block;
    private final boolean useIncubatingAPIs;
    private final boolean useTestSuites;

    BuildScriptBuilder(BuildInitDsl dsl, DocumentationRegistry documentationRegistry, String fileNameWithoutExtension, boolean useIncubatingAPIs, InsecureProtocolOption insecureProtocolOption) {
        this.dsl = dsl;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
        this.useIncubatingAPIs = useIncubatingAPIs;
        this.useTestSuites = useIncubatingAPIs;
        this.mavenRepoURLHandler = MavenRepositoryURLHandler.forInsecureProtocolOption(insecureProtocolOption, dsl, documentationRegistry);
        this.block = new TopLevelBlock(this);
    }

    public BuildScriptBuilder withExternalComments() {
        this.externalComments = true;
        return this;
    }

    public boolean isUsingTestSuites() {
        return this.useTestSuites;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public static String getIncubatingApisWarning() {
        return INCUBATING_APIS_WARNING;
    }

    public BuildScriptBuilder fileComment(String comment) {
        this.headerLines.addAll(BuildScriptBuilder.splitComment(comment));
        return this;
    }

    public List<SuiteSpec> getSuites() {
        return new ArrayList<SuiteSpec>(this.block.testing.suites);
    }

    private static List<String> splitComment(String comment) {
        return Splitter.on((String)"\n").splitToList((CharSequence)comment.trim());
    }

    private static URI uriFromString(String uriAsString) {
        try {
            return new URI(uriAsString);
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public BuildScriptBuilder plugin(@Nullable String comment, String pluginId) {
        this.block.plugins.add(new PluginSpec(pluginId, null, comment));
        return this;
    }

    public BuildScriptBuilder conventionPluginSupport(@Nullable String comment) {
        Syntax syntax = BuildScriptBuilder.syntaxFor(this.dsl);
        this.block.repositories.gradlePluginPortal("Use the plugin portal to apply community plugins in convention plugins.");
        syntax.configureConventionPlugin(comment, this.block.plugins, this.block.repositories);
        return this;
    }

    public BuildScriptBuilder plugin(@Nullable String comment, String pluginId, String version) {
        this.block.plugins.add(new PluginSpec(pluginId, version, comment));
        return this;
    }

    public BuildScriptBuilder dependency(String configuration, @Nullable String comment, String ... dependencies) {
        this.dependencies().dependency(configuration, comment, dependencies);
        return this;
    }

    public void dependencyForSuite(SuiteSpec targetSuite, String configuration, String comment, String ... dependencies) {
        targetSuite.dependencies.dependency(configuration, comment, dependencies);
    }

    public BuildScriptBuilder implementationDependency(@Nullable String comment, String ... dependencies) {
        return this.dependency("implementation", comment, dependencies);
    }

    public BuildScriptBuilder implementationDependencyConstraint(@Nullable String comment, String ... dependencies) {
        this.dependencies().dependencyConstraint("implementation", comment, dependencies);
        return this;
    }

    public BuildScriptBuilder testImplementationDependency(@Nullable String comment, String ... dependencies) {
        assert (!this.isUsingTestSuites()) : "do not add dependencies directly to testImplementation configuration";
        return this.dependency("testImplementation", comment, dependencies);
    }

    public BuildScriptBuilder testRuntimeOnlyDependency(@Nullable String comment, String ... dependencies) {
        assert (!this.isUsingTestSuites()) : "do not add dependencies directly to testRuntimeOnly configuration";
        return this.dependency("testRuntimeOnly", comment, dependencies);
    }

    public Expression methodInvocationExpression(String methodName, Object ... methodArgs) {
        return new MethodInvocationExpression(null, methodName, BuildScriptBuilder.expressionValues(methodArgs));
    }

    public Expression propertyExpression(String value) {
        return new LiteralValue(value);
    }

    public Expression propertyExpression(Expression expression, String value) {
        return new ChainedPropertyExpression(BuildScriptBuilder.expressionValue(expression), new LiteralValue(value));
    }

    public Expression containerElementExpression(String container, String element) {
        return new ContainerElementExpression(container, element);
    }

    private static List<ExpressionValue> expressionValues(Object ... expressions) {
        ArrayList<ExpressionValue> result = new ArrayList<ExpressionValue>(expressions.length);
        for (Object expression : expressions) {
            result.add(BuildScriptBuilder.expressionValue(expression));
        }
        return result;
    }

    private static Map<String, ExpressionValue> expressionMap(Map<String, ?> expressions) {
        LinkedHashMap<String, ExpressionValue> result = new LinkedHashMap<String, ExpressionValue>();
        for (Map.Entry<String, ?> entry : expressions.entrySet()) {
            result.put(entry.getKey(), BuildScriptBuilder.expressionValue(entry.getValue()));
        }
        return result;
    }

    private static ExpressionValue expressionValue(Object expression) {
        if (expression instanceof CharSequence) {
            return new StringValue((CharSequence)expression);
        }
        if (expression instanceof ExpressionValue) {
            return (ExpressionValue)expression;
        }
        if (expression instanceof Number || expression instanceof Boolean) {
            return new LiteralValue(expression);
        }
        if (expression instanceof Map) {
            return new MapLiteralValue(BuildScriptBuilder.expressionMap((Map)Cast.uncheckedNonnullCast((Object)expression)));
        }
        if (expression instanceof Enum) {
            return new EnumValue(expression);
        }
        throw new IllegalArgumentException("Don't know how to treat " + expression + " as an expression.");
    }

    public RepositoriesBuilder repositories() {
        return this.block.repositories;
    }

    public DependenciesBuilder dependencies() {
        return this.block.dependencies;
    }

    public TestingBuilder testing() {
        return this.block.testing;
    }

    public BuildScriptBuilder methodInvocation(@Nullable String comment, String methodName, Object ... methodArgs) {
        this.block.methodInvocation(comment, methodName, methodArgs);
        return this;
    }

    public BuildScriptBuilder methodInvocation(@Nullable String comment, Expression target, String methodName, Object ... methodArgs) {
        this.block.methodInvocation(comment, target, methodName, methodArgs);
        return this;
    }

    public BuildScriptBuilder propertyAssignment(@Nullable String comment, String propertyName, Object propertyValue) {
        this.block.propertyAssignment(comment, propertyName, propertyValue, true);
        return this;
    }

    public ScriptBlockBuilder block(@Nullable String comment, String methodName) {
        return this.block.block(comment, methodName);
    }

    public BuildScriptBuilder block(@Nullable String comment, String methodName, Action<? super ScriptBlockBuilder> blockContentBuilder) {
        blockContentBuilder.execute((Object)this.block.block(comment, methodName));
        return this;
    }

    public BuildScriptBuilder taskMethodInvocation(@Nullable String comment, String taskName, String taskType, String methodName, Object ... methodArgs) {
        this.block.tasks.add(new TaskSelector(taskName, taskType), new MethodInvocation(comment, new MethodInvocationExpression(null, methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        return this;
    }

    public BuildScriptBuilder taskPropertyAssignment(@Nullable String comment, String taskName, String taskType, String propertyName, Object propertyValue) {
        this.block.tasks.add(new TaskSelector(taskName, taskType), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue), true));
        return this;
    }

    public BuildScriptBuilder taskPropertyAssignment(@Nullable String comment, String taskType, String propertyName, Object propertyValue) {
        this.block.taskTypes.add(new TaskTypeSelector(taskType), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue), true));
        return this;
    }

    public TaskConfiguration taskConfiguration(@Nullable String comment, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        TaskConfiguration conf = new TaskConfiguration(comment, taskName, taskType);
        this.block.add(conf);
        blockContentsBuilder.execute((Object)conf.body);
        return conf;
    }

    public TaskConfiguration taskConfiguration(@Nullable String comment, BlockStatement containingBlock, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        TaskConfiguration conf = new TaskConfiguration(comment, taskName, taskType);
        containingBlock.add(conf);
        blockContentsBuilder.execute((Object)conf.body);
        return conf;
    }

    public TaskRegistration taskRegistration(@Nullable String comment, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        TaskRegistration registration = new TaskRegistration(comment, taskName, taskType);
        this.block.add(registration);
        blockContentsBuilder.execute((Object)registration.body);
        return registration;
    }

    public TaskRegistration taskRegistration(@Nullable String comment, BlockStatement containingBlock, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        TaskRegistration registration = new TaskRegistration(comment, taskName, taskType);
        containingBlock.add(registration);
        blockContentsBuilder.execute((Object)registration.body);
        return registration;
    }

    public SuiteConfiguration suiteConfiguration(@Nullable String comment, BlockStatement containingBlock, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        SuiteConfiguration conf = new SuiteConfiguration(comment, taskName, taskType);
        containingBlock.add(conf);
        blockContentsBuilder.execute((Object)conf.body);
        return conf;
    }

    public SuiteRegistration suiteRegistration(@Nullable String comment, BlockStatement containingBlock, String taskName, String taskType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
        SuiteRegistration registration = new SuiteRegistration(comment, taskName, taskType);
        containingBlock.add(registration);
        blockContentsBuilder.execute((Object)registration.body);
        return registration;
    }

    public Expression createContainerElement(@Nullable String comment, String container, String elementName, @Nullable String varName) {
        ContainerElement containerElement = new ContainerElement(comment, container, elementName, null, varName);
        this.block.add(containerElement);
        return containerElement;
    }

    public TemplateOperation create(Directory targetDirectory) {
        return () -> {
            if (this.useIncubatingAPIs) {
                this.headerLines.add(INCUBATING_APIS_WARNING);
            }
            File target = this.getTargetFile(targetDirectory);
            GFileUtils.mkdirs((File)target.getParentFile());
            try (PrintWriter writer = new PrintWriter(new FileWriter(target));){
                PrettyPrinter printer = new PrettyPrinter(BuildScriptBuilder.syntaxFor(this.dsl), writer, this.externalComments);
                printer.printFileHeader(this.headerLines);
                this.block.writeBodyTo(printer);
            }
            catch (Exception e) {
                throw new GradleException("Could not generate file " + target + ".", (Throwable)e);
            }
        };
    }

    public List<String> extractComments() {
        return this.block.extractComments();
    }

    private File getTargetFile(Directory targetDirectory) {
        return targetDirectory.file(this.dsl.fileNameFor(this.fileNameWithoutExtension)).getAsFile();
    }

    private static Syntax syntaxFor(BuildInitDsl dsl) {
        switch (dsl) {
            case KOTLIN: {
                return new KotlinSyntax();
            }
            case GROOVY: {
                return new GroovySyntax();
            }
        }
        throw new IllegalStateException();
    }

    private static interface MavenRepositoryURLHandler {
        public void handleURL(URI var1, PrettyPrinter var2);

        public static MavenRepositoryURLHandler forInsecureProtocolOption(InsecureProtocolOption insecureProtocolOption, BuildInitDsl dsl, DocumentationRegistry documentationRegistry) {
            switch (insecureProtocolOption) {
                case FAIL: {
                    return new FailingHandler(documentationRegistry);
                }
                case WARN: {
                    return new WarningHandler(dsl, documentationRegistry);
                }
                case ALLOW: {
                    return new AllowingHandler();
                }
                case UPGRADE: {
                    return new UpgradingHandler();
                }
            }
            throw new IllegalStateException(String.format("Unknown handler: '%s'.", new Object[]{insecureProtocolOption}));
        }

        public static class AllowingHandler
        extends AbstractMavenRepositoryURLHandler {
            @Override
            protected void handleInsecureURL(URI repoLocation, ScriptBlockImpl statements) {
                statements.propertyAssignment(null, "url", new MethodInvocationExpression(null, "uri", Collections.singletonList(new StringValue(repoLocation.toString()))), true);
                statements.propertyAssignment(null, "allowInsecureProtocol", new LiteralValue(true), true);
            }
        }

        public static class UpgradingHandler
        extends AbstractMavenRepositoryURLHandler {
            @Override
            protected void handleInsecureURL(URI repoLocation, ScriptBlockImpl statements) {
                URI secureUri = GUtil.toSecureUrl((URI)repoLocation);
                statements.propertyAssignment(null, "url", new MethodInvocationExpression(null, "uri", Collections.singletonList(new StringValue(secureUri.toString()))), true);
            }
        }

        public static class WarningHandler
        extends AbstractMavenRepositoryURLHandler {
            private final BuildInitDsl dsl;
            private final DocumentationRegistry documentationRegistry;

            public WarningHandler(BuildInitDsl dsl, DocumentationRegistry documentationRegistry) {
                this.dsl = dsl;
                this.documentationRegistry = documentationRegistry;
            }

            @Override
            protected void handleInsecureURL(URI repoLocation, ScriptBlockImpl statements) {
                LOGGER.warn("Gradle found an insecure protocol in a repository definition. You will have to opt into allowing insecure protocols in the generated build file. See {}.", (Object)this.documentationRegistry.getDocumentationFor("build_init_plugin", "allow_insecure"));
                statements.propertyAssignment(null, "url", new MethodInvocationExpression(null, "uri", Collections.singletonList(new StringValue(repoLocation.toString()))), true);
                statements.comment(this.buildAllowInsecureProtocolComment(this.dsl));
            }

            private String buildAllowInsecureProtocolComment(BuildInitDsl dsl) {
                PropertyAssignment assignment = new PropertyAssignment(null, "allowInsecureProtocol", new LiteralValue(true), true);
                StringWriter result = new StringWriter();
                PrintWriter writer = new PrintWriter(result);
                try {
                    PrettyPrinter printer = new PrettyPrinter(BuildScriptBuilder.syntaxFor(dsl), writer, false);
                    assignment.writeCodeTo(printer);
                    String string = result.toString();
                    writer.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new GradleException("Could not write comment.", (Throwable)e);
                    }
                }
            }
        }

        public static class FailingHandler
        extends AbstractMavenRepositoryURLHandler {
            private final DocumentationRegistry documentationRegistry;

            public FailingHandler(DocumentationRegistry documentationRegistry) {
                this.documentationRegistry = documentationRegistry;
            }

            @Override
            protected void handleInsecureURL(URI repoLocation, ScriptBlockImpl statements) {
                LOGGER.error("Gradle found an insecure protocol in a repository definition. The current strategy for handling insecure URLs is to fail. For more options, see {}.", (Object)this.documentationRegistry.getDocumentationFor("build_init_plugin", "allow_insecure"));
                throw new GradleException(String.format("Build generation aborted due to insecure protocol in repository: %s", repoLocation));
            }
        }

        public static abstract class AbstractMavenRepositoryURLHandler
        implements MavenRepositoryURLHandler {
            @Override
            public void handleURL(URI repoLocation, PrettyPrinter printer) {
                ScriptBlockImpl statements = new ScriptBlockImpl();
                if (GUtil.isSecureUrl((URI)repoLocation)) {
                    this.handleSecureURL(repoLocation, statements);
                } else {
                    this.handleInsecureURL(repoLocation, statements);
                }
                printer.printBlock("maven", statements);
            }

            protected void handleSecureURL(URI repoLocation, ScriptBlockImpl statements) {
                statements.propertyAssignment(null, "url", new MethodInvocationExpression(null, "uri", Collections.singletonList(new StringValue(repoLocation.toString()))), true);
            }

            protected abstract void handleInsecureURL(URI var1, ScriptBlockImpl var2);
        }
    }

    private static final class GroovySyntax
    implements Syntax {
        private GroovySyntax() {
        }

        @Override
        public String string(String string) {
            return "'" + this.escapeGroovyStringLiteral(string) + "'";
        }

        private String escapeGroovyStringLiteral(String string) {
            return string.replace("\\", "\\\\").replace("'", "\\'");
        }

        @Override
        public String mapLiteral(Map<String, ExpressionValue> map) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            this.addEntries(map, builder);
            builder.append("]");
            return builder.toString();
        }

        private void addEntries(Map<String, ExpressionValue> map, StringBuilder builder) {
            boolean first = true;
            for (Map.Entry<String, ExpressionValue> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(entry.getValue().with(this));
            }
        }

        @Override
        public String firstArg(ExpressionValue argument) {
            if (argument instanceof MapLiteralValue) {
                MapLiteralValue literalValue = (MapLiteralValue)argument;
                StringBuilder builder = new StringBuilder();
                this.addEntries(literalValue.literal, builder);
                return builder.toString();
            }
            return argument.with(this);
        }

        @Override
        public String pluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                return "id '" + pluginId + "' version '" + version + "'";
            }
            return "id '" + pluginId + "'";
        }

        @Override
        public String nestedPluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                throw new UnsupportedOperationException();
            }
            return "apply plugin: '" + pluginId + "'";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + " " + notation;
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            ExpressionValue propertyValue = expression.propertyValue;
            return propertyName + " = " + propertyValue.with(this);
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return null;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return "tasks.named('" + selector.taskName + "')";
        }

        @Override
        public String taskByTypeSelector(String taskType) {
            return "tasks.withType(" + taskType + ")";
        }

        @Override
        public String taskRegistration(String taskName, String taskType) {
            return "tasks.register('" + taskName + "', " + taskType + ")";
        }

        @Override
        public String taskConfiguration(String taskName, String taskType) {
            return taskName;
        }

        @Override
        public String suiteRegistration(String suiteName, String suiteType) {
            return suiteName + "(" + suiteType + ")";
        }

        @Override
        public String suiteConfiguration(String suiteName, String suiteType) {
            return suiteName;
        }

        @Override
        public String referenceTask(String taskName) {
            return "tasks." + taskName;
        }

        @Override
        public String referenceSuite(String suiteName) {
            return suiteName;
        }

        @Override
        public Statement createContainerElement(String comment, String container, String elementName, @Nullable String elementType, String varName, List<Statement> body) {
            ScriptBlock outerBlock = new ScriptBlock(comment, container);
            ScriptBlock innerBlock = new ScriptBlock(null, elementType == null ? elementName : elementName + "(" + elementType + ")");
            outerBlock.add(innerBlock);
            for (Statement statement : body) {
                innerBlock.add(statement);
            }
            return outerBlock;
        }

        @Override
        public String referenceCreatedContainerElement(String container, String elementName, String varName) {
            return container + "." + elementName;
        }

        @Override
        public String containerElement(String container, String element) {
            return container + "." + element;
        }

        @Override
        public void configureConventionPlugin(@Nullable String comment, BlockStatement plugins, RepositoriesBlock repositories) {
            plugins.add(new PluginSpec("groovy-gradle-plugin", null, comment));
        }
    }

    private static final class KotlinSyntax
    implements Syntax {
        private KotlinSyntax() {
        }

        @Override
        public String string(String string) {
            return '\"' + this.escapeKotlinStringLiteral(string) + '\"';
        }

        private String escapeKotlinStringLiteral(String string) {
            return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("$", "\\$");
        }

        @Override
        public String mapLiteral(Map<String, ExpressionValue> map) {
            StringBuilder builder = new StringBuilder();
            builder.append("mapOf(");
            boolean first = true;
            for (Map.Entry<String, ExpressionValue> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(this.string(entry.getKey()));
                builder.append(" to ");
                builder.append(entry.getValue().with(this));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        public String firstArg(ExpressionValue argument) {
            return argument.with(this);
        }

        @Override
        public String pluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                return "id(\"" + pluginId + "\") version \"" + version + "\"";
            }
            if (pluginId.contains(".")) {
                return "id(\"" + pluginId + "\")";
            }
            return pluginId.matches("[a-z]+") ? pluginId : "`" + pluginId + "`";
        }

        @Override
        public String nestedPluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                throw new UnsupportedOperationException();
            }
            return "plugins.apply(\"" + pluginId + "\")";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + "(" + notation + ")";
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            ExpressionValue propertyValue = expression.propertyValue;
            if (expression.legacyProperty) {
                if (propertyValue.isBooleanType()) {
                    return this.booleanPropertyNameFor(propertyName) + " = " + propertyValue.with(this);
                }
                return propertyName + " = " + propertyValue.with(this);
            }
            return propertyName + ".set(" + propertyValue.with(this) + ")";
        }

        private String booleanPropertyNameFor(String propertyName) {
            return "is" + StringUtils.capitalize((String)propertyName);
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return selector.conventionName;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return "tasks.named<" + selector.taskType + ">(\"" + selector.taskName + "\")";
        }

        @Override
        public String taskByTypeSelector(String taskType) {
            return "tasks.withType<" + taskType + ">()";
        }

        @Override
        public String taskRegistration(String taskName, String taskType) {
            return "val " + taskName + " by tasks.registering(" + taskType + "::class)";
        }

        @Override
        public String taskConfiguration(String taskName, String taskType) {
            return "val " + taskName + " by tasks.getting(" + taskType + "::class)";
        }

        @Override
        public String suiteRegistration(String suiteName, String suiteType) {
            return "val " + suiteName + " by registering(" + suiteType + "::class)";
        }

        @Override
        public String suiteConfiguration(String suiteName, String suiteType) {
            return "val " + suiteName + " by getting(" + suiteType + "::class)";
        }

        @Override
        public String referenceTask(String taskName) {
            return taskName;
        }

        @Override
        public String referenceSuite(String suiteName) {
            return suiteName;
        }

        @Override
        public Statement createContainerElement(String comment, String container, String elementName, @Nullable String elementType, String varName, List<Statement> body) {
            String literal = varName == null ? (elementType == null ? "val " + elementName + " by " + container + ".creating" : container + ".create<" + elementType + ">(" + this.string(elementName) + ")") : (elementType == null ? "val " + varName + " = " + container + ".create(" + this.string(elementName) + ")" : "val " + varName + " = " + container + ".create<" + elementType + ">(" + this.string(elementName) + ")");
            ScriptBlock blockStatement = new ScriptBlock(comment, literal);
            for (Statement statement : body) {
                blockStatement.add(statement);
            }
            return blockStatement;
        }

        @Override
        public String referenceCreatedContainerElement(String container, String elementName, String varName) {
            if (varName == null) {
                return elementName;
            }
            return varName;
        }

        @Override
        public String containerElement(String container, String element) {
            return container + "[" + this.string(element) + "]";
        }

        @Override
        public void configureConventionPlugin(@Nullable String comment, BlockStatement plugins, RepositoriesBlock repositories) {
            plugins.add(new PluginSpec("kotlin-dsl", null, comment));
        }
    }

    private static interface Syntax {
        public String pluginDependencySpec(String var1, @Nullable String var2);

        public String nestedPluginDependencySpec(String var1, @Nullable String var2);

        public String dependencySpec(String var1, String var2);

        public String propertyAssignment(PropertyAssignment var1);

        @Nullable
        public String conventionSelector(ConventionSelector var1);

        public String taskSelector(TaskSelector var1);

        public String taskByTypeSelector(String var1);

        public String string(String var1);

        public String taskRegistration(String var1, String var2);

        public String taskConfiguration(String var1, String var2);

        public String suiteRegistration(String var1, String var2);

        public String suiteConfiguration(String var1, String var2);

        public String referenceTask(String var1);

        public String referenceSuite(String var1);

        public String mapLiteral(Map<String, ExpressionValue> var1);

        public String firstArg(ExpressionValue var1);

        public Statement createContainerElement(@Nullable String var1, String var2, String var3, @Nullable String var4, @Nullable String var5, List<Statement> var6);

        public String referenceCreatedContainerElement(String var1, String var2, @Nullable String var3);

        public String containerElement(String var1, String var2);

        public void configureConventionPlugin(@Nullable String var1, BlockStatement var2, RepositoriesBlock var3);
    }

    private static final class PrettyPrinter {
        private final Syntax syntax;
        private final PrintWriter writer;
        private final boolean externalComments;
        private String indent = "";
        private String eolComment = null;
        private int commentCount = 0;
        private boolean needSeparatorLine = true;
        private boolean firstStatementOfBlock = false;
        private boolean hasSeparatorLine = false;

        PrettyPrinter(Syntax syntax, PrintWriter writer, boolean externalComments) {
            this.syntax = syntax;
            this.writer = writer;
            this.externalComments = externalComments;
        }

        public void printFileHeader(Collection<String> lines) {
            if (this.externalComments) {
                return;
            }
            this.println("/*");
            this.println(" * This file was generated by the Gradle 'init' task.");
            if (!lines.isEmpty()) {
                this.println(" *");
                for (String headerLine : lines) {
                    if (headerLine.isEmpty()) {
                        this.println(" *");
                        continue;
                    }
                    this.println(" * " + headerLine);
                }
            }
            this.println(" */");
        }

        public void printBlock(String blockSelector, BlockBody blockBody) {
            String indentBefore = this.indent;
            this.println(blockSelector + " {");
            this.indent = this.indent + "    ";
            this.needSeparatorLine = false;
            this.firstStatementOfBlock = true;
            blockBody.writeBodyTo(this);
            this.indent = indentBefore;
            this.println("}");
            this.needSeparatorLine = true;
        }

        public void printStatements(List<? extends Statement> statements) {
            for (Statement statement : statements) {
                this.printStatement(statement);
            }
        }

        private void printStatementSeparator() {
            if (this.needSeparatorLine && !this.hasSeparatorLine) {
                this.println();
                this.needSeparatorLine = false;
            }
        }

        private void printStatement(Statement statement) {
            boolean needsSeparator;
            Statement.Type type = statement.type();
            if (type == Statement.Type.Empty) {
                return;
            }
            boolean hasComment = statement.getComment() != null;
            boolean bl = needsSeparator = hasComment || type == Statement.Type.Group;
            if (needsSeparator && !this.firstStatementOfBlock) {
                this.needSeparatorLine = true;
            }
            this.printStatementSeparator();
            if (hasComment) {
                if (this.externalComments) {
                    ++this.commentCount;
                    this.eolComment = " // <" + this.commentCount + ">";
                } else {
                    for (String line : BuildScriptBuilder.splitComment(statement.getComment())) {
                        this.println("// " + line);
                    }
                }
            }
            statement.writeCodeTo(this);
            this.firstStatementOfBlock = false;
            if (needsSeparator) {
                this.needSeparatorLine = true;
            }
        }

        private void println(String s) {
            if (!this.indent.isEmpty()) {
                this.writer.print(this.indent);
            }
            if (this.eolComment != null) {
                this.writer.println(s + this.eolComment);
                this.eolComment = null;
            } else {
                this.writer.println(s);
            }
            this.hasSeparatorLine = false;
        }

        private void println() {
            this.writer.println();
            this.hasSeparatorLine = true;
        }
    }

    private static class ConfigurationStatements<T extends ConfigSelector>
    implements Statement {
        final ListMultimap<T, Statement> blocks = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private ConfigurationStatements() {
        }

        void add(T selector, Statement statement) {
            this.blocks.put(selector, (Object)statement);
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public Statement.Type type() {
            return this.blocks.isEmpty() ? Statement.Type.Empty : Statement.Type.Single;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            for (ConfigSelector configSelector : this.blocks.keySet()) {
                String selector = configSelector.codeBlockSelectorFor(printer.syntax);
                if (selector != null) {
                    BlockStatement statement = new BlockStatement(selector);
                    statement.body.statements.addAll(this.blocks.get((Object)configSelector));
                    printer.printStatement(statement);
                    continue;
                }
                printer.printStatements(this.blocks.get((Object)configSelector));
            }
        }
    }

    private static class SuiteRegistration
    implements Statement,
    ExpressionValue {
        final String suiteName;
        final String suiteType;
        final String comment;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        SuiteRegistration(@Nullable String comment, String suiteName, String suiteType) {
            this.comment = comment;
            this.suiteName = suiteName;
            this.suiteType = suiteType;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(printer.syntax.suiteRegistration(this.suiteName, this.suiteType), this.body);
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.referenceSuite(this.suiteName);
        }
    }

    private static class SuiteConfiguration
    implements Statement,
    ExpressionValue {
        final String suiteName;
        final String suiteType;
        final String comment;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        SuiteConfiguration(@Nullable String comment, String suiteName, String suiteType) {
            this.comment = comment;
            this.suiteName = suiteName;
            this.suiteType = suiteType;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(printer.syntax.suiteConfiguration(this.suiteName, this.suiteType), this.body);
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.referenceSuite(this.suiteName);
        }
    }

    private static class TaskRegistration
    implements Statement,
    ExpressionValue {
        final String taskName;
        final String taskType;
        final String comment;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        TaskRegistration(@Nullable String comment, String taskName, String taskType) {
            this.comment = comment;
            this.taskName = taskName;
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(printer.syntax.taskRegistration(this.taskName, this.taskType), this.body);
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.referenceTask(this.taskName);
        }
    }

    private static class TaskConfiguration
    implements Statement,
    ExpressionValue {
        final String taskName;
        final String taskType;
        final String comment;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        TaskConfiguration(@Nullable String comment, String taskName, String taskType) {
            this.comment = comment;
            this.taskName = taskName;
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(printer.syntax.taskConfiguration(this.taskName, this.taskType), this.body);
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.referenceTask(this.taskName);
        }
    }

    private static class TopLevelBlock
    extends ScriptBlockImpl {
        final BlockStatement plugins = new BlockStatement("plugins");
        final RepositoriesBlock repositories;
        final DependenciesBlock dependencies = new DependenciesBlock();
        final TestingBlock testing;
        final ConfigurationStatements<TaskTypeSelector> taskTypes = new ConfigurationStatements();
        final ConfigurationStatements<TaskSelector> tasks = new ConfigurationStatements();
        final ConfigurationStatements<ConventionSelector> conventions = new ConfigurationStatements();
        final BuildScriptBuilder builder;

        private TopLevelBlock(BuildScriptBuilder builder) {
            this.repositories = new RepositoriesBlock(builder);
            this.testing = new TestingBlock(builder);
            this.builder = builder;
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            printer.printStatement(this.plugins);
            printer.printStatement(this.repositories);
            printer.printStatement(this.dependencies);
            if (this.builder.useTestSuites && !this.builder.getSuites().isEmpty()) {
                printer.printStatement(this.testing);
            }
            super.writeBodyTo(printer);
            printer.printStatement(this.conventions);
            printer.printStatement(this.taskTypes);
            for (SuiteSpec suite : this.testing.suites) {
                if (suite.isDefaultTestSuite()) continue;
                this.addCheckDependsOn(suite);
            }
            printer.printStatement(this.tasks);
        }

        private void addCheckDependsOn(SuiteSpec suite) {
            ExpressionValue testSuites = BuildScriptBuilder.expressionValue(this.builder.propertyExpression(this.builder.propertyExpression("testing"), "suites"));
            if (this.builder.dsl == BuildInitDsl.GROOVY) {
                Expression suiteDependedUpon = this.builder.propertyExpression(testSuites, suite.getName());
                this.builder.taskMethodInvocation("Include " + suite.getName() + " as part of the check lifecycle", "check", Task.class.getSimpleName(), "dependsOn", suiteDependedUpon);
            } else {
                MethodInvocationExpression namedMethod = new MethodInvocationExpression(testSuites, "named", Collections.singletonList(new StringValue(suite.getName())));
                this.builder.taskMethodInvocation("Include " + suite.getName() + " as part of the check lifecycle", "check", Task.class.getSimpleName(), "dependsOn", namedMethod);
            }
        }

        public List<String> extractComments() {
            ArrayList<String> comments = new ArrayList<String>();
            this.collectComments(this.plugins.body.getStatements(), comments);
            this.collectComments(this.repositories.body.getStatements(), comments);
            this.collectComments(this.dependencies.getStatements(), comments);
            for (Statement otherBlock : this.getStatements()) {
                if (!(otherBlock instanceof BlockStatement)) continue;
                this.collectComments(((BlockStatement)otherBlock).body.getStatements(), comments);
            }
            this.collectComments(this.tasks.blocks.values(), comments);
            return comments;
        }

        private void collectComments(Collection<Statement> statements, List<String> comments) {
            for (Statement statement : statements) {
                if (statement.getComment() == null) continue;
                comments.add(statement.getComment());
            }
        }
    }

    public static class ScriptBlockImpl
    implements ScriptBlockBuilder,
    BlockBody {
        final List<Statement> statements = new ArrayList<Statement>();

        public void add(Statement statement) {
            this.statements.add(statement);
        }

        @Override
        public List<Statement> getStatements() {
            return this.statements;
        }

        public Statement.Type type() {
            for (Statement statement : this.statements) {
                if (statement.type() == Statement.Type.Empty) continue;
                return Statement.Type.Group;
            }
            return Statement.Type.Empty;
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            printer.printStatements(this.statements);
        }

        @Override
        public void propertyAssignment(String comment, String propertyName, Object propertyValue, boolean legacyProperty) {
            this.statements.add(new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue), legacyProperty));
        }

        @Override
        public void methodInvocation(String comment, String methodName, Object ... methodArgs) {
            this.statements.add(new MethodInvocation(comment, new MethodInvocationExpression(null, methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        }

        @Override
        public void methodInvocation(@Nullable String comment, Expression target, String methodName, Object ... methodArgs) {
            this.statements.add(new MethodInvocation(comment, new MethodInvocationExpression(BuildScriptBuilder.expressionValue(target), methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        }

        @Override
        public ScriptBlockBuilder block(String comment, String methodName) {
            ScriptBlock scriptBlock = new ScriptBlock(comment, methodName);
            this.statements.add(scriptBlock);
            return scriptBlock.body;
        }

        @Override
        public void statement(@Nullable String comment, Statement statement) {
            this.statements.add(statement);
        }

        @Override
        public void block(@Nullable String comment, String methodName, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
            blockContentsBuilder.execute((Object)this.block(comment, methodName));
        }

        @Override
        public Expression containerElement(@Nullable String comment, String container, String elementName, @Nullable String elementType, Action<? super ScriptBlockBuilder> blockContentsBuilder) {
            ContainerElement containerElement = new ContainerElement(comment, container, elementName, elementType, null);
            this.statements.add(containerElement);
            blockContentsBuilder.execute((Object)containerElement.body);
            return containerElement;
        }

        @Override
        public Expression propertyExpression(String value) {
            return new LiteralValue(value);
        }

        @Override
        public void comment(String comment) {
            this.statements.add(new SingleLineComment(comment));
        }
    }

    private static class MavenRepoExpression
    extends AbstractStatement {
        private final URI uri;
        private final BuildScriptBuilder builder;

        MavenRepoExpression(@Nullable String comment, String url, BuildScriptBuilder builder) {
            super(comment);
            this.uri = BuildScriptBuilder.uriFromString(url);
            this.builder = builder;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            this.builder.mavenRepoURLHandler.handleURL(this.uri, printer);
        }
    }

    private static class TargetSpec
    extends BlockStatement
    implements BlockBody {
        private final BuildScriptBuilder builder;
        private final String name;

        TargetSpec(@Nullable String comment, String name, BuildScriptBuilder builder, boolean testTaskShouldRunAfter) {
            super(comment);
            this.builder = builder;
            this.name = name;
            if (testTaskShouldRunAfter) {
                this.configureShouldRunAfterTest();
            }
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.name, this);
        }

        private void configureShouldRunAfterTest() {
            MethodInvocation shouldRunAfterCall = new MethodInvocation(null, new MethodInvocationExpression(null, "shouldRunAfter", Collections.singletonList(new LiteralValue("test"))));
            NoArgClosureExpression configBlock = new NoArgClosureExpression(shouldRunAfterCall);
            MethodInvocation functionalTestConfiguration = new MethodInvocation("This test suite should run after the built-in test suite has run its tests", new MethodInvocationExpression(BuildScriptBuilder.expressionValue(this.builder.propertyExpression("testTask")), "configure", configBlock));
            this.add(functionalTestConfiguration);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            for (Statement statement : this.body.statements) {
                printer.printStatement(statement);
            }
        }

        @Override
        public List<Statement> getStatements() {
            return this.body.statements;
        }
    }

    private static class TargetsBlock
    extends BlockStatement
    implements TargetsBuilder,
    BlockBody {
        private final BuildScriptBuilder builder;
        private final List<TargetSpec> targets = new ArrayList<TargetSpec>();

        TargetsBlock(BuildScriptBuilder builder) {
            super("targets");
            this.builder = builder;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.blockSelector, this);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            if (!this.targets.isEmpty()) {
                for (Statement statement : this.targets) {
                    printer.printStatement(statement);
                }
            }
        }

        @Override
        public List<Statement> getStatements() {
            return new ArrayList<Statement>(this.targets);
        }

        @Override
        public void all(boolean testTaskShouldRunAfter) {
            this.targets.add(new TargetSpec(null, "all", this.builder, testTaskShouldRunAfter));
        }
    }

    public static class SuiteSpec
    extends AbstractStatement {
        private final BuildScriptBuilder builder;
        private final String name;
        private final TestSuiteFramework framework;
        private final String frameworkVersion;
        private final DependenciesBlock dependencies = new DependenciesBlock();
        private final TargetsBlock targets;
        private final boolean isDefaultTestSuite;
        private final boolean isDefaultFramework;

        SuiteSpec(@Nullable String comment, String name, TestSuiteFramework framework, String frameworkVersion, BuildScriptBuilder builder) {
            super(comment);
            this.builder = builder;
            this.framework = framework;
            this.frameworkVersion = frameworkVersion;
            this.name = name;
            this.targets = new TargetsBlock(builder);
            this.isDefaultTestSuite = "test".equals(name);
            boolean bl = this.isDefaultFramework = framework == TestSuiteFramework.getDefault();
            if (!this.isDefaultTestSuite) {
                this.dependencies.selfDependency("implementation", name + " test suite depends on the production code in tests");
                this.targets.all(true);
            }
        }

        private Action<? super ScriptBlockBuilder> buildSuiteConfigurationContents() {
            return b -> {
                if (this.isDefaultTestSuite || !this.isDefaultFramework) {
                    if (this.frameworkVersion == null) {
                        b.methodInvocation("Use " + this.framework.displayName + " test framework", this.framework.method.methodName, new Object[0]);
                    } else {
                        b.methodInvocation("Use " + this.framework.displayName + " test framework", this.framework.method.methodName, this.frameworkVersion);
                    }
                }
                if (!this.dependencies.dependencies.isEmpty()) {
                    b.statement(null, this.dependencies);
                }
                if (!this.targets.targets.isEmpty()) {
                    b.statement(null, this.targets);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefaultTestSuite() {
            return this.isDefaultTestSuite;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        void implementation(String comment, String ... dependencies) {
            this.dependencies.dependency("implementation", comment, dependencies);
        }

        void runtimeOnly(String comment, String ... dependencies) {
            this.dependencies.dependency("runtimeOnly", comment, dependencies);
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            if (this.isDefaultTestSuite) {
                printer.printStatement(this.builder.suiteConfiguration("Configure the built-in test suite", ((BuildScriptBuilder)this.builder).block.testing, this.name, JvmTestSuite.class.getSimpleName(), this.buildSuiteConfigurationContents()));
            } else {
                printer.printStatement(this.builder.suiteRegistration("Create a new test suite", ((BuildScriptBuilder)this.builder).block.testing, this.name, JvmTestSuite.class.getSimpleName(), this.buildSuiteConfigurationContents()));
            }
        }

        public static enum TestSuiteFramework {
            JUNIT(new MethodInvocationExpression("useJUnit"), "JUnit4"),
            JUNIT_PLATFORM(new MethodInvocationExpression("useJUnitJupiter"), "JUnit Jupiter"),
            SPOCK(new MethodInvocationExpression("useSpock"), "Spock"),
            KOTLIN_TEST(new MethodInvocationExpression("useKotlinTest"), "Kotlin Test"),
            TEST_NG(new MethodInvocationExpression("useTestNG"), "TestNG");

            final String displayName;
            final MethodInvocationExpression method;

            private TestSuiteFramework(MethodInvocationExpression method, String displayName) {
                this.method = method;
                this.displayName = displayName;
            }

            public static TestSuiteFramework getDefault() {
                return JUNIT_PLATFORM;
            }
        }
    }

    private static class TestingBlock
    extends BlockStatement
    implements TestingBuilder,
    BlockBody {
        private final BuildScriptBuilder builder;
        private final List<SuiteSpec> suites = new ArrayList<SuiteSpec>();

        TestingBlock(BuildScriptBuilder builder) {
            super("testing");
            this.builder = builder;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.blockSelector, this);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            if (!this.suites.isEmpty()) {
                ScriptBlockImpl suitesBlock = new ScriptBlockImpl();
                for (Statement statement : this.suites) {
                    suitesBlock.add(statement);
                }
                printer.printBlock("suites", suitesBlock);
            }
        }

        @Override
        public List<Statement> getStatements() {
            return new ArrayList<Statement>(this.suites);
        }

        @Override
        public SuiteSpec junitSuite(String name, TemplateLibraryVersionProvider libraryVersionProvider) {
            SuiteSpec spec = new SuiteSpec(null, name, SuiteSpec.TestSuiteFramework.JUNIT, libraryVersionProvider.getVersion("junit"), this.builder);
            this.suites.add(spec);
            return spec;
        }

        @Override
        public SuiteSpec junitJupiterSuite(String name, TemplateLibraryVersionProvider libraryVersionProvider) {
            SuiteSpec spec = new SuiteSpec(null, name, SuiteSpec.TestSuiteFramework.JUNIT_PLATFORM, libraryVersionProvider.getVersion("junit-jupiter"), this.builder);
            this.suites.add(spec);
            return spec;
        }

        @Override
        public SuiteSpec spockSuite(String name, TemplateLibraryVersionProvider libraryVersionProvider) {
            SuiteSpec spec = new SuiteSpec(null, name, SuiteSpec.TestSuiteFramework.SPOCK, libraryVersionProvider.getVersion("spock"), this.builder);
            this.suites.add(spec);
            return spec;
        }

        @Override
        public SuiteSpec kotlinTestSuite(String name, TemplateLibraryVersionProvider libraryVersionProvider) {
            SuiteSpec spec = new SuiteSpec(null, name, SuiteSpec.TestSuiteFramework.KOTLIN_TEST, libraryVersionProvider.getVersion("kotlin"), this.builder);
            this.suites.add(spec);
            return spec;
        }

        @Override
        public SuiteSpec testNG(String name, TemplateLibraryVersionProvider libraryVersionProvider) {
            SuiteSpec spec = new SuiteSpec(null, name, SuiteSpec.TestSuiteFramework.TEST_NG, libraryVersionProvider.getVersion("testng"), this.builder);
            this.suites.add(spec);
            return spec;
        }
    }

    private static class DependenciesBlock
    implements DependenciesBuilder,
    Statement,
    BlockBody {
        final ListMultimap<String, Statement> dependencies = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        final ListMultimap<String, Statement> constraints = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private DependenciesBlock() {
        }

        @Override
        public void dependency(String configuration, @Nullable String comment, String ... dependencies) {
            this.dependencies.put((Object)configuration, (Object)new DepSpec(configuration, comment, Arrays.asList(dependencies)));
        }

        @Override
        public void dependencyConstraint(String configuration, @Nullable String comment, String ... constraints) {
            this.constraints.put((Object)configuration, (Object)new DepSpec(configuration, comment, Arrays.asList(constraints)));
        }

        @Override
        public void platformDependency(String configuration, @Nullable String comment, String dependency) {
            this.dependencies.put((Object)configuration, (Object)new PlatformDepSpec(configuration, comment, dependency));
        }

        @Override
        public void projectDependency(String configuration, @Nullable String comment, String projectPath) {
            this.dependencies.put((Object)configuration, (Object)new ProjectDepSpec(configuration, comment, projectPath));
        }

        @Override
        public void selfDependency(String configuration, @Nullable String comment) {
            this.dependencies.put((Object)configuration, (Object)new SelfDepSpec(configuration, comment));
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public Statement.Type type() {
            return this.dependencies.isEmpty() && this.constraints.isEmpty() ? Statement.Type.Empty : Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock("dependencies", this);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            if (!this.constraints.isEmpty()) {
                ScriptBlockImpl constraintsBlock = new ScriptBlockImpl();
                for (String config : this.constraints.keySet()) {
                    for (Statement constraintSpec : this.constraints.get((Object)config)) {
                        constraintsBlock.add(constraintSpec);
                    }
                }
                printer.printBlock("constraints", constraintsBlock);
            }
            for (String config : this.dependencies.keySet()) {
                for (Statement depSpec : this.dependencies.get((Object)config)) {
                    printer.printStatement(depSpec);
                }
            }
        }

        @Override
        public List<Statement> getStatements() {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            if (!this.constraints.isEmpty()) {
                ScriptBlock constraintsBlock = new ScriptBlock(null, "constraints");
                for (String config : this.constraints.keySet()) {
                    for (Statement statement : this.constraints.get((Object)config)) {
                        constraintsBlock.add(statement);
                    }
                }
                statements.add(constraintsBlock);
            }
            for (String config : this.dependencies.keySet()) {
                statements.addAll(this.dependencies.get((Object)config));
            }
            return statements;
        }
    }

    private static class RepositoriesBlock
    extends BlockStatement
    implements RepositoriesBuilder {
        private final BuildScriptBuilder builder;

        RepositoriesBlock(BuildScriptBuilder builder) {
            super("repositories");
            this.builder = builder;
        }

        @Override
        public void mavenLocal(String comment) {
            this.add(new MethodInvocation(comment, new MethodInvocationExpression("mavenLocal")));
        }

        @Override
        public void mavenCentral(@Nullable String comment) {
            this.add(new MethodInvocation(comment, new MethodInvocationExpression("mavenCentral")));
        }

        @Override
        public void gradlePluginPortal(@Nullable String comment) {
            this.add(new MethodInvocation(comment, new MethodInvocationExpression("gradlePluginPortal")));
        }

        @Override
        public void maven(String comment, String url) {
            this.add(new MavenRepoExpression(comment, url, this.builder));
        }
    }

    private static class ScriptBlock
    extends BlockStatement {
        ScriptBlock(String comment, String blockSelector) {
            super(comment, blockSelector);
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }
    }

    private static class BlockStatement
    implements Statement {
        private final String comment;
        final String blockSelector;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        BlockStatement(String blockSelector) {
            this(null, blockSelector);
        }

        BlockStatement(@Nullable String comment, String blockSelector) {
            this.comment = comment;
            this.blockSelector = blockSelector;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return this.body.type();
        }

        void add(Statement statement) {
            this.body.add(statement);
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.blockSelector, this.body);
        }
    }

    private static interface BlockBody {
        public void writeBodyTo(PrettyPrinter var1);

        public List<Statement> getStatements();
    }

    private static class SingleLineComment
    extends AbstractStatement {
        private SingleLineComment(String comment) {
            super(comment);
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
        }
    }

    private static class PropertyAssignment
    extends AbstractStatement {
        final String propertyName;
        final ExpressionValue propertyValue;
        final boolean legacyProperty;

        private PropertyAssignment(String comment, String propertyName, ExpressionValue propertyValue, boolean legacyProperty) {
            super(comment);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.legacyProperty = legacyProperty;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.propertyAssignment(this));
        }
    }

    private static class ContainerElement
    extends AbstractStatement
    implements ExpressionValue {
        private final String comment;
        private final String container;
        private final String elementName;
        @Nullable
        private final String varName;
        @Nullable
        private final String elementType;
        private final ScriptBlockImpl body = new ScriptBlockImpl();

        public ContainerElement(String comment, String container, String elementName, @Nullable String elementType, @Nullable String varName) {
            super(null);
            this.comment = comment;
            this.container = container;
            this.elementName = elementName;
            this.elementType = elementType;
            this.varName = varName;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            Statement statement = printer.syntax.createContainerElement(this.comment, this.container, this.elementName, this.elementType, this.varName, this.body.statements);
            printer.printStatement(statement);
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.referenceCreatedContainerElement(this.container, this.elementName, this.varName);
        }
    }

    private static class MethodInvocation
    extends AbstractStatement {
        final MethodInvocationExpression invocationExpression;

        private MethodInvocation(String comment, MethodInvocationExpression invocationExpression) {
            super(comment);
            this.invocationExpression = invocationExpression;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(this.invocationExpression.with(printer.syntax));
        }
    }

    private static abstract class AbstractStatement
    implements Statement {
        final String comment;

        AbstractStatement(@Nullable String comment) {
            this.comment = comment;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Single;
        }
    }

    public static interface Statement {
        @Nullable
        public String getComment();

        public Type type();

        public void writeCodeTo(PrettyPrinter var1);

        public static enum Type {
            Empty,
            Single,
            Group;

        }
    }

    private static class ConventionSelector
    implements ConfigSelector {
        final String conventionName;

        private ConventionSelector(String conventionName) {
            this.conventionName = conventionName;
        }

        @Override
        public String codeBlockSelectorFor(Syntax syntax) {
            return syntax.conventionSelector(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConventionSelector that = (ConventionSelector)o;
            return Objects.equal((Object)this.conventionName, (Object)that.conventionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.conventionName});
        }
    }

    private static class TaskTypeSelector
    implements ConfigSelector {
        final String taskType;

        TaskTypeSelector(String taskType) {
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String codeBlockSelectorFor(Syntax syntax) {
            return syntax.taskByTypeSelector(this.taskType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskTypeSelector that = (TaskTypeSelector)o;
            return Objects.equal((Object)this.taskType, (Object)that.taskType);
        }

        public int hashCode() {
            return this.taskType.hashCode();
        }
    }

    private static class TaskSelector
    implements ConfigSelector {
        final String taskName;
        final String taskType;

        private TaskSelector(String taskName, String taskType) {
            this.taskName = taskName;
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String codeBlockSelectorFor(Syntax syntax) {
            return syntax.taskSelector(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskSelector that = (TaskSelector)o;
            return Objects.equal((Object)this.taskName, (Object)that.taskName) && Objects.equal((Object)this.taskType, (Object)that.taskType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.taskName, this.taskType});
        }
    }

    private static interface ConfigSelector {
        @Nullable
        public String codeBlockSelectorFor(Syntax var1);
    }

    private static class ProjectDepSpec
    extends AbstractStatement {
        private final String configuration;
        private final String projectPath;

        ProjectDepSpec(String configuration, String comment, String projectPath) {
            super(comment);
            this.configuration = configuration;
            this.projectPath = projectPath;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.dependencySpec(this.configuration, "project(" + printer.syntax.string(this.projectPath) + ")"));
        }
    }

    private static class SelfDepSpec
    extends AbstractStatement {
        private final String configuration;

        SelfDepSpec(String configuration, @Nullable String comment) {
            super(comment);
            this.configuration = configuration;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.dependencySpec(this.configuration, "project()"));
        }
    }

    private static class PlatformDepSpec
    extends AbstractStatement {
        private final String configuration;
        private final String dep;

        PlatformDepSpec(String configuration, @Nullable String comment, String dep) {
            super(comment);
            this.configuration = configuration;
            this.dep = dep;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.dependencySpec(this.configuration, "platform(" + printer.syntax.string(this.dep) + ")"));
        }
    }

    private static class DepSpec
    extends AbstractStatement {
        final String configuration;
        final List<String> deps;

        DepSpec(String configuration, @Nullable String comment, List<String> deps) {
            super(comment);
            this.configuration = configuration;
            this.deps = deps;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            for (String dep : this.deps) {
                printer.println(printer.syntax.dependencySpec(this.configuration, printer.syntax.string(dep)));
            }
        }
    }

    private static class PluginSpec
    extends AbstractStatement {
        final String id;
        @Nullable
        final String version;

        PluginSpec(String id, @Nullable String version, String comment) {
            super(comment);
            this.id = id;
            this.version = version;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.pluginDependencySpec(this.id, this.version));
        }
    }

    private static class ContainerElementExpression
    implements ExpressionValue {
        private final String container;
        private final String element;

        public ContainerElementExpression(String container, String element) {
            this.container = container;
            this.element = element;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.containerElement(this.container, this.element);
        }
    }

    private static class MethodInvocationExpression
    implements ExpressionValue {
        @Nullable
        private final ExpressionValue target;
        final String methodName;
        final List<ExpressionValue> arguments;

        MethodInvocationExpression(@Nullable ExpressionValue target, String methodName, List<ExpressionValue> arguments) {
            this.target = target;
            this.methodName = methodName;
            this.arguments = arguments;
        }

        MethodInvocationExpression(@Nullable ExpressionValue target, String methodName, NoArgClosureExpression closureArg) {
            this.target = target;
            this.methodName = methodName;
            this.arguments = Collections.singletonList(closureArg);
        }

        MethodInvocationExpression(String methodName) {
            this(null, methodName, Collections.emptyList());
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            boolean onlyArgIsClosure;
            StringBuilder result = new StringBuilder();
            if (this.target != null) {
                result.append(this.target.with(syntax));
                result.append('.');
            }
            result.append(this.methodName);
            boolean bl = onlyArgIsClosure = this.arguments.size() == 1 && this.arguments.get(0) instanceof NoArgClosureExpression;
            if (onlyArgIsClosure) {
                result.append(' ');
            } else {
                result.append("(");
            }
            for (int i = 0; i < this.arguments.size(); ++i) {
                ExpressionValue argument = this.arguments.get(i);
                if (i == 0) {
                    result.append(syntax.firstArg(argument));
                    continue;
                }
                result.append(", ");
                result.append(argument.with(syntax));
            }
            if (onlyArgIsClosure) {
                result.append(' ');
            } else {
                result.append(")");
            }
            return result.toString();
        }
    }

    private static class NoArgClosureExpression
    implements ExpressionValue {
        final List<MethodInvocation> calls = new ArrayList<MethodInvocation>();

        NoArgClosureExpression(MethodInvocation ... calls) {
            this.calls.addAll(Arrays.asList(calls));
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return "{" + this.calls.stream().map(call -> call.invocationExpression.with(syntax)).collect(Collectors.joining("\n", " ", " ")) + "}";
        }
    }

    private static class MapLiteralValue
    implements ExpressionValue {
        final Map<String, ExpressionValue> literal;

        public MapLiteralValue(Map<String, ExpressionValue> literal) {
            this.literal = literal;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.mapLiteral(this.literal);
        }
    }

    private static class EnumValue
    implements ExpressionValue {
        final Enum<?> literal;

        EnumValue(Object literal) {
            this.literal = (Enum)Cast.uncheckedNonnullCast((Object)literal);
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return this.literal.getClass().getSimpleName() + "." + this.literal.name();
        }
    }

    private static class LiteralValue
    implements ExpressionValue {
        final Object literal;

        LiteralValue(Object literal) {
            this.literal = literal;
        }

        @Override
        public boolean isBooleanType() {
            return this.literal instanceof Boolean;
        }

        @Override
        public String with(Syntax syntax) {
            return this.literal.toString();
        }
    }

    private static class StringValue
    implements ExpressionValue {
        final CharSequence value;

        StringValue(CharSequence value) {
            this.value = value;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.string(this.value.toString());
        }
    }

    private static class ChainedPropertyExpression
    implements ExpressionValue {
        private final ExpressionValue left;
        private final ExpressionValue right;

        public ChainedPropertyExpression(ExpressionValue left, ExpressionValue right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return this.left.with(syntax) + "." + this.right.with(syntax);
        }
    }

    private static interface ExpressionValue
    extends Expression {
        public boolean isBooleanType();

        public String with(Syntax var1);
    }

    public static interface Expression {
    }
}

