/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.worker.RemoteTestClassProcessor;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.internal.tasks.testing.worker.TestWorker;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.internal.CollectionUtils;

public class ForkingTestClassProcessor
implements TestClassProcessor {
    private final WorkerProcessFactory workerFactory;
    private final WorkerTestClassProcessorFactory processorFactory;
    private final JavaForkOptions options;
    private final Iterable<File> classPath;
    private final Iterable<File> modulePath;
    private final Action<WorkerProcessBuilder> buildConfigAction;
    private final ModuleRegistry moduleRegistry;
    private final Lock lock = new ReentrantLock();
    private final WorkerThreadRegistry workerThreadRegistry;
    private RemoteTestClassProcessor remoteProcessor;
    private WorkerProcess workerProcess;
    private TestResultProcessor resultProcessor;
    private WorkerLeaseRegistry.WorkerLeaseCompletion completion;
    private final DocumentationRegistry documentationRegistry;
    private boolean stoppedNow;

    public ForkingTestClassProcessor(WorkerThreadRegistry workerThreadRegistry, WorkerProcessFactory workerFactory, WorkerTestClassProcessorFactory processorFactory, JavaForkOptions options, Iterable<File> classPath, Iterable<File> modulePath, Action<WorkerProcessBuilder> buildConfigAction, ModuleRegistry moduleRegistry, DocumentationRegistry documentationRegistry) {
        this.workerThreadRegistry = workerThreadRegistry;
        this.workerFactory = workerFactory;
        this.processorFactory = processorFactory;
        this.options = options;
        this.classPath = classPath;
        this.modulePath = modulePath;
        this.buildConfigAction = buildConfigAction;
        this.moduleRegistry = moduleRegistry;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        this.lock.lock();
        try {
            if (this.stoppedNow) {
                return;
            }
            if (this.remoteProcessor == null) {
                this.completion = this.workerThreadRegistry.startWorker();
                try {
                    this.remoteProcessor = this.forkProcess();
                }
                catch (RuntimeException e) {
                    this.completion.leaseFinish();
                    this.completion = null;
                    throw e;
                }
            }
            this.remoteProcessor.processTestClass(testClass);
        }
        finally {
            this.lock.unlock();
        }
    }

    RemoteTestClassProcessor forkProcess() {
        WorkerProcessBuilder builder = this.workerFactory.create((Action)new TestWorker(this.processorFactory));
        builder.setBaseName("Gradle Test Executor");
        builder.setImplementationClasspath(this.getTestWorkerImplementationClasspath());
        builder.applicationClasspath(this.classPath);
        builder.applicationModulePath(this.modulePath);
        this.options.copyTo((JavaForkOptions)builder.getJavaCommand());
        builder.getJavaCommand().jvmArgs(new Object[]{"-Dorg.gradle.native=false"});
        this.buildConfigAction.execute((Object)builder);
        this.workerProcess = builder.build();
        this.workerProcess.start();
        ObjectConnection connection = this.workerProcess.getConnection();
        connection.useParameterSerializers(TestEventSerializer.create());
        connection.addIncoming(TestResultProcessor.class, (Object)this.resultProcessor);
        RemoteTestClassProcessor remoteProcessor = (RemoteTestClassProcessor)connection.addOutgoing(RemoteTestClassProcessor.class);
        connection.connect();
        remoteProcessor.startProcessing();
        return remoteProcessor;
    }

    List<URL> getTestWorkerImplementationClasspath() {
        return CollectionUtils.flattenCollections(URL.class, (Object[])new Object[]{this.moduleRegistry.getModule("gradle-core-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-worker-processes").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-core").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-messaging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-files").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-file-temp").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-hashing").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-enterprise-workers").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-native").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-base").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-jvm-infrastructure").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-junit-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-process-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-build-operations").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("slf4j-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("jul-to-slf4j").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("native-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("kryo").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("commons-lang").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("javax.inject").getImplementationClasspath().getAsURLs()});
    }

    @Override
    public void stop() {
        block11: {
            try {
                if (this.remoteProcessor == null) break block11;
                this.lock.lock();
                try {
                    if (!this.stoppedNow) {
                        this.remoteProcessor.stop();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                this.workerProcess.waitForStop();
            }
            catch (ExecException e) {
                if (!this.stoppedNow) {
                    throw new ExecException(e.getMessage() + "\nThis problem might be caused by incorrect test process configuration.\nPlease refer to the test execution section in the User Manual at " + this.documentationRegistry.getDocumentationFor("java_testing", "sec:test_execution"), e.getCause());
                }
            }
            finally {
                if (this.completion != null) {
                    this.completion.leaseFinish();
                }
            }
        }
    }

    @Override
    public void stopNow() {
        this.lock.lock();
        try {
            this.stoppedNow = true;
            if (this.remoteProcessor != null) {
                this.workerProcess.stopNow();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

