/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/UpperBoundViolatedInTypealiasConstructorChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class UpperBoundViolatedInTypealiasConstructorChecker
implements CallChecker {
    @NotNull
    public static final UpperBoundViolatedInTypealiasConstructorChecker INSTANCE = new UpperBoundViolatedInTypealiasConstructorChecker();

    private UpperBoundViolatedInTypealiasConstructorChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        void $this$mapTo$iv$iv;
        Object it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = obj instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)obj : null;
        if (typeAliasConstructorDescriptor == null) {
            return;
        }
        TypeAliasConstructorDescriptor resultingDescriptor = typeAliasConstructorDescriptor;
        PsiElement $this$getStrictParentOfType$iv = reportOn;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtCallExpression.class, true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        KotlinType kotlinType = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"resultingDescriptor.unde\u2026ctorDescriptor.returnType");
        KotlinType underlyingConstructedType = kotlinType;
        List<TypeProjection> underlyingTypeArguments = underlyingConstructedType.getArguments();
        List<TypeParameterDescriptor> list2 = resultingDescriptor.getUnderlyingConstructorDescriptor().getReturnType().getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resultingDescriptor.unde\u2026pe.constructor.parameters");
        List<TypeParameterDescriptor> underlyingTypeParameters = list2;
        ClassicTypeCheckerState state = new ClassicTypeCheckerState(false, false, null, null, null, 30, null);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)underlyingTypeParameters);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object object = destination$iv$iv;
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = new Pair((Object)((TypeParameterDescriptor)it.getValue()).getTypeConstructor(), (Object)underlyingTypeArguments.get(it.getIndex()).getType().unwrap());
            object.put(it.getFirst(), it.getSecond());
        }
        Map map = destination$iv$iv;
        NewTypeSubstitutorByConstructorMap substitutor2 = new NewTypeSubstitutorByConstructorMap(map);
        List<TypeParameterDescriptor> list3 = resolvedCall2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"resolvedCall.candidateDescriptor.typeParameters");
        List<TypeParameterDescriptor> aliasTypeParameters = list3;
        Iterable $this$map$iv = resultingDescriptor.getTypeAliasDescriptor().getUnderlyingType().getArguments();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getType());
        }
        List originalTypes = (List)destination$iv$iv2;
        Iterator iterator2 = CollectionsKt.zip((Iterable)underlyingTypeArguments, (Iterable)underlyingTypeParameters).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            Pair argumentAndParameter = (Pair)iterator2.next();
            TypeProjection argument2 = (TypeProjection)argumentAndParameter.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)argumentAndParameter.component2();
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.getOrNull(aliasTypeParameters, (int)index2);
            if (Intrinsics.areEqual((Object)(typeParameterDescriptor != null ? typeParameterDescriptor.getDefaultType() : null), (Object)CollectionsKt.getOrNull((List)originalTypes, (int)index2))) continue;
            for (KotlinType upperBound : parameter.getUpperBounds()) {
                TypeCheckerState typeCheckerState2 = state;
                KotlinType kotlinType2 = argument2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"argument.type");
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)kotlinType2, (KotlinTypeMarker)substitutor2.safeSubstitute(upperBound.unwrap()), false, 8, null)) continue;
                List<KtTypeProjection> list4 = callExpression.getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"callExpression.typeArguments");
                KtModifierListOwnerStub ktModifierListOwnerStub = (KtTypeProjection)CollectionsKt.getOrNull(list4, (int)index2);
                if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
                KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
                context.getTrace().report(Errors.UPPER_BOUND_VIOLATED_WARNING.on((KtTypeReference)typeReference, upperBound, argument2.getType()));
            }
        }
    }
}

