/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal;

import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.ant.BasicAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.internal.jvm.Jvm;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AntWorkAction<T extends WorkParameters>
implements WorkAction<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntWorkAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        LOGGER.info("Running {} with toolchain '{}'.", (Object)this.getActionName(), (Object)Jvm.current().getJavaHome().getAbsolutePath());
        BasicAntBuilder antBuilder = new BasicAntBuilder();
        AntLoggingAdapter antLogger = new AntLoggingAdapter();
        try {
            this.configureAntBuilder((AntBuilder)antBuilder, antLogger);
            AntBuilderDelegate delegate = new AntBuilderDelegate((Object)antBuilder, Thread.currentThread().getContextClassLoader());
            this.getAntAction().execute((Object)delegate);
        }
        finally {
            this.disposeBuilder(antBuilder, antLogger);
        }
    }

    protected abstract String getActionName();

    protected abstract Action<AntBuilderDelegate> getAntAction();

    private void configureAntBuilder(AntBuilder antBuilder, AntLoggingAdapter antLogger) {
        try {
            Project project = this.getProject(antBuilder);
            Vector listeners = project.getBuildListeners();
            project.removeBuildListener((BuildListener)listeners.get(0));
            project.addBuildListener((BuildListener)antLogger);
        }
        catch (Exception ex) {
            throw new GradleException("Unable to configure AntBuilder", (Throwable)ex);
        }
    }

    private void disposeBuilder(Object antBuilder, AntLoggingAdapter antLogger) {
        try {
            Project project = this.getProject(antBuilder);
            project.removeBuildListener((BuildListener)antLogger);
            antBuilder.getClass().getDeclaredMethod("close", new Class[0]).invoke(antBuilder, new Object[0]);
        }
        catch (Exception ex) {
            throw new GradleException("Unable to dispose AntBuilder", (Throwable)ex);
        }
    }

    private Project getProject(Object antBuilder) throws Exception {
        return (Project)antBuilder.getClass().getMethod("getProject", new Class[0]).invoke(antBuilder, new Object[0]);
    }
}

