/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Describable;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.AbstractTrackedResourceLock;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ProjectLock;
import org.gradle.internal.resources.ProjectLockRegistry;
import org.gradle.internal.resources.ProjectLockStatistics;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.resources.TaskExecutionLockRegistry;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.DefaultSynchronizer;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.Synchronizer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerLeaseService
implements WorkerLeaseService,
Stoppable {
    public static final String PROJECT_LOCK_STATS_PROPERTY = "org.gradle.internal.project.lock.stats";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerLeaseService.class);
    private final int maxWorkerCount;
    private int counter = 1;
    private final Root root = new Root();
    private final ResourceLockCoordinationService coordinationService;
    private final TaskExecutionLockRegistry taskLockRegistry;
    private final ProjectLockRegistry projectLockRegistry;
    private final WorkerLeaseLockRegistry workerLeaseLockRegistry;
    private final ProjectLockStatisticsImpl projectLockStatistics = new ProjectLockStatisticsImpl();

    public DefaultWorkerLeaseService(ResourceLockCoordinationService coordinationService, ParallelismConfiguration parallelismConfiguration) {
        this.maxWorkerCount = parallelismConfiguration.getMaxWorkerCount();
        this.coordinationService = coordinationService;
        this.projectLockRegistry = new ProjectLockRegistry(coordinationService, parallelismConfiguration.isParallelProjectExecutionEnabled());
        this.taskLockRegistry = new TaskExecutionLockRegistry(coordinationService, this.projectLockRegistry);
        this.workerLeaseLockRegistry = new WorkerLeaseLockRegistry(coordinationService);
        LOGGER.info("Using {} worker leases.", (Object)this.maxWorkerCount);
    }

    @Override
    public int getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    @Override
    public WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        Collection<ResourceLock> operations = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (operations.isEmpty()) {
            throw new NoAvailableWorkerLeaseException("No worker lease associated with the current thread");
        }
        return (DefaultWorkerLease)operations.toArray()[operations.size() - 1];
    }

    private synchronized DefaultWorkerLease getWorkerLease(LeaseHolder parent) {
        int workerId = this.counter++;
        Thread ownerThread = Thread.currentThread();
        return this.workerLeaseLockRegistry.getResourceLock(parent, workerId, ownerThread);
    }

    @Override
    public DefaultWorkerLease getWorkerLease() {
        return this.getWorkerLease(this.root);
    }

    @Override
    public boolean isWorkerThread() {
        return this.workerLeaseLockRegistry.holdsLock();
    }

    @Override
    public <T> T runAsWorkerThread(Factory<T> action) {
        Collection<ResourceLock> locks = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        if (!locks.isEmpty()) {
            return action.create();
        }
        return this.withLocks(Collections.singletonList(this.getWorkerLease()), action);
    }

    @Override
    public void runAsWorkerThread(Runnable action) {
        this.runAsWorkerThread(Factories.toFactory(action));
    }

    @Override
    public Synchronizer newResource() {
        return new DefaultSynchronizer(this);
    }

    @Override
    public void stop() {
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (DefaultWorkerLeaseService.this.workerLeaseLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some worker leases have not been marked as completed.");
                }
                if (DefaultWorkerLeaseService.this.projectLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some project locks have not been unlocked.");
                }
                if (DefaultWorkerLeaseService.this.taskLockRegistry.hasOpenLocks()) {
                    throw new IllegalStateException("Some task execution locks have not been unlocked.");
                }
                return ResourceLockState.Disposition.FINISHED;
            }
        });
        if (this.projectLockStatistics.isEnabled()) {
            LOGGER.warn("Time spent waiting on project locks: " + this.projectLockStatistics.getTotalWaitTimeMillis() + "ms");
        }
    }

    @Override
    public boolean getAllowsParallelExecution() {
        return this.projectLockRegistry.getAllowsParallelExecution();
    }

    @Override
    public ResourceLock getAllProjectsLock() {
        return this.projectLockRegistry.getAllProjectsLock();
    }

    @Override
    public ResourceLock getProjectLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.projectLockRegistry.getResourceLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public ResourceLock getTaskExecutionLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.taskLockRegistry.getTaskExecutionLock(buildIdentityPath, projectIdentityPath);
    }

    @Override
    public Collection<? extends ResourceLock> getCurrentProjectLocks() {
        return this.projectLockRegistry.getResourceLocksByCurrentThread();
    }

    @Override
    public void runAsIsolatedTask() {
        Collection<? extends ResourceLock> projectLocks = this.getCurrentProjectLocks();
        this.releaseLocks(projectLocks);
        this.releaseLocks(this.taskLockRegistry.getResourceLocksByCurrentThread());
    }

    public void releaseCurrentResourceLocks() {
        this.releaseLocks(this.workerLeaseLockRegistry.getResourceLocksByCurrentThread());
    }

    @Override
    public void runAsIsolatedTask(Runnable runnable) {
        this.runAsIsolatedTask(Factories.toFactory(runnable));
    }

    @Override
    @Deprecated
    public void withoutProjectLock(Runnable action) {
        this.runAsIsolatedTask(action);
    }

    @Override
    public <T> T runAsIsolatedTask(Factory<T> factory) {
        Collection<? extends ResourceLock> projectLocks = this.getCurrentProjectLocks();
        Collection<ResourceLock> taskLocks = this.taskLockRegistry.getResourceLocksByCurrentThread();
        ArrayList<? extends ResourceLock> locks = new ArrayList<ResourceLock>(projectLocks.size() + taskLocks.size());
        locks.addAll(projectLocks);
        locks.addAll(taskLocks);
        return this.withoutLocks(locks, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blocking(Runnable action) {
        Collection<? extends ResourceLock> projectLocks;
        if (this.projectLockRegistry.mayAttemptToChangeLocks() && !(projectLocks = this.getCurrentProjectLocks()).isEmpty()) {
            ArrayList<? extends ResourceLock> locks = new ArrayList<ResourceLock>(projectLocks.size() + 1);
            locks.addAll(projectLocks);
            locks.add(this.getCurrentWorkerLease());
            this.releaseLocks(locks);
            try {
                action.run();
                return;
            }
            finally {
                this.acquireLocks(locks);
            }
        }
        List<WorkerLeaseRegistry.WorkerLease> locks = Collections.singletonList(this.getCurrentWorkerLease());
        this.releaseLocks(locks);
        try {
            action.run();
        }
        finally {
            this.acquireLocks(locks);
        }
    }

    @Override
    public <T> T whileDisallowingProjectLockChanges(Factory<T> action) {
        return this.projectLockRegistry.whileDisallowingLockChanges(action);
    }

    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        return this.projectLockRegistry.allowUncontrolledAccessToAnyResource(factory);
    }

    @Override
    public boolean isAllowedUncontrolledAccessToAnyProject() {
        return this.projectLockRegistry.isAllowedUncontrolledAccessToAnyResource();
    }

    @Override
    public void withLocks(Iterable<? extends ResourceLock> locks, Runnable runnable) {
        this.withLocks(locks, Factories.toFactory(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLocks(Iterable<? extends ResourceLock> locks, Factory<T> factory) {
        Iterable<? extends ResourceLock> locksToAcquire = this.locksNotHeld(locks);
        if (Iterables.isEmpty(locksToAcquire)) {
            return factory.create();
        }
        this.acquireLocks(locksToAcquire);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.releaseLocks(locksToAcquire);
        }
    }

    private void releaseLocks(Iterable<? extends ResourceLock> locks) {
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(locks));
    }

    private void acquireLocks(final Iterable<? extends ResourceLock> locks) {
        if (this.containsProjectLocks(locks)) {
            this.projectLockStatistics.measure(new Runnable(){

                @Override
                public void run() {
                    DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
                }
            });
        } else {
            this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(locks));
        }
    }

    private boolean containsProjectLocks(Iterable<? extends ResourceLock> locks) {
        for (ResourceLock resourceLock : locks) {
            if (!(resourceLock instanceof ProjectLock)) continue;
            return true;
        }
        return false;
    }

    private Iterable<? extends ResourceLock> locksNotHeld(Iterable<? extends ResourceLock> locks) {
        if (Iterables.isEmpty(locks)) {
            return locks;
        }
        final ArrayList locksNotHeld = Lists.newArrayList(locks);
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                Iterator iterator = locksNotHeld.iterator();
                while (iterator.hasNext()) {
                    ResourceLock lock = (ResourceLock)iterator.next();
                    if (!lock.isLockedByCurrentThread()) continue;
                    iterator.remove();
                }
                return ResourceLockState.Disposition.FINISHED;
            }
        });
        return locksNotHeld;
    }

    @Override
    public void withoutLocks(Iterable<? extends ResourceLock> locks, Runnable runnable) {
        this.withoutLocks(locks, Factories.toFactory(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withoutLocks(Iterable<? extends ResourceLock> locks, Factory<T> factory) {
        if (Iterables.isEmpty(locks)) {
            return factory.create();
        }
        if (!this.allLockedByCurrentThread(locks)) {
            throw new IllegalStateException("Not all of the locks specified are currently held by the current thread.  This could lead to orphaned locks.");
        }
        this.releaseLocks(locks);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            if (!this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.tryLock(locks))) {
                this.releaseWorkerLeaseAndWaitFor(locks);
            }
        }
    }

    @Override
    public WorkerLeaseRegistry.WorkerLeaseCompletion startWorker() {
        DefaultWorkerLease lease = this.getWorkerLease();
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(lease));
        return lease;
    }

    private void releaseWorkerLeaseAndWaitFor(Iterable<? extends ResourceLock> locks) {
        Collection<ResourceLock> workerLeases = this.workerLeaseLockRegistry.getResourceLocksByCurrentThread();
        ArrayList allLocks = Lists.newArrayList();
        allLocks.addAll(workerLeases);
        Iterables.addAll((Collection)allLocks, locks);
        this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(workerLeases));
        this.acquireLocks(allLocks);
    }

    private boolean allLockedByCurrentThread(final Iterable<? extends ResourceLock> locks) {
        final MutableBoolean allLocked = new MutableBoolean();
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                allLocked.set(CollectionUtils.every(locks, new Spec<ResourceLock>(){

                    @Override
                    public boolean isSatisfiedBy(ResourceLock lock) {
                        return lock.isLockedByCurrentThread();
                    }
                }));
                return ResourceLockState.Disposition.FINISHED;
            }
        });
        return allLocked.get();
    }

    private static class ProjectLockStatisticsImpl
    implements ProjectLockStatistics {
        private final AtomicLong total = new AtomicLong(-1L);

        private ProjectLockStatisticsImpl() {
        }

        @Override
        public void measure(Runnable runnable) {
            if (this.isEnabled()) {
                Timer timer = Time.startTimer();
                runnable.run();
                this.total.addAndGet(timer.getElapsedMillis());
            } else {
                runnable.run();
            }
        }

        @Override
        public long getTotalWaitTimeMillis() {
            return this.total.get();
        }

        public boolean isEnabled() {
            return System.getProperty(DefaultWorkerLeaseService.PROJECT_LOCK_STATS_PROPERTY) != null;
        }
    }

    private class DefaultWorkerLease
    extends AbstractTrackedResourceLock
    implements WorkerLeaseRegistry.WorkerLeaseCompletion,
    WorkerLeaseRegistry.WorkerLease {
        private final LeaseHolder parent;
        private final Thread ownerThread;
        boolean active;

        public DefaultWorkerLease(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner, LeaseHolder parent, Thread ownerThread) {
            super(displayName, coordinationService, owner);
            this.parent = parent;
            this.ownerThread = ownerThread;
        }

        @Override
        protected boolean doIsLocked() {
            return this.active;
        }

        @Override
        protected boolean doIsLockedByCurrentThread() {
            return this.active && Thread.currentThread() == this.ownerThread;
        }

        @Override
        protected boolean acquireLock() {
            if (this.parent.grantLease()) {
                this.active = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Worker lease {} started ({} worker(s) in use).", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Build operation {} could not be started yet ({} worker(s) in use).", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
            }
            return this.active;
        }

        @Override
        protected void releaseLock() {
            if (Thread.currentThread() != this.ownerThread) {
                throw new UnsupportedOperationException("Must complete operation from owner thread.");
            }
            this.parent.releaseLease();
            this.active = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Worker lease {} completed ({} worker(s) in use)", (Object)this.getDisplayName(), (Object)((DefaultWorkerLeaseService)DefaultWorkerLeaseService.this).root.leasesInUse);
            }
        }

        @Override
        public void leaseFinish() {
            DefaultWorkerLeaseService.this.coordinationService.withStateLock(DefaultResourceLockCoordinationService.unlock(this));
        }
    }

    private class Root
    implements LeaseHolder {
        int leasesInUse;

        private Root() {
        }

        @Override
        public String getDisplayName() {
            return "root";
        }

        @Override
        public boolean grantLease() {
            if (this.leasesInUse >= DefaultWorkerLeaseService.this.maxWorkerCount) {
                return false;
            }
            ++this.leasesInUse;
            return true;
        }

        @Override
        public void releaseLease() {
            --this.leasesInUse;
        }
    }

    private static interface LeaseHolder
    extends Describable {
        public boolean grantLease();

        public void releaseLease();
    }

    private class WorkerLeaseLockRegistry
    extends AbstractResourceLockRegistry<String, DefaultWorkerLease> {
        WorkerLeaseLockRegistry(ResourceLockCoordinationService coordinationService) {
            super(coordinationService);
        }

        DefaultWorkerLease getResourceLock(final LeaseHolder parent, int workerId, final Thread ownerThread) {
            String displayName = parent.getDisplayName() + '.' + workerId;
            return this.getOrRegisterResourceLock(displayName, new AbstractResourceLockRegistry.ResourceLockProducer<String, DefaultWorkerLease>(){

                @Override
                public DefaultWorkerLease create(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                    return new DefaultWorkerLease(displayName, coordinationService, owner, parent, ownerThread);
                }
            });
        }
    }
}

