/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.time.Duration;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class CaptureStateAfterExecutionStep<C extends BeforeExecutionContext>
extends BuildOperationStep<C, AfterExecutionResult> {
    private final UniqueId buildInvocationScopeId;
    private final OutputSnapshotter outputSnapshotter;
    private final Step<? super C, ? extends Result> delegate;

    public CaptureStateAfterExecutionStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, OutputSnapshotter outputSnapshotter, Step<? super C, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.outputSnapshotter = outputSnapshotter;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, C context) {
        final Result result = this.delegate.execute(work, context);
        final Duration duration = result.getDuration();
        final Optional afterExecutionState = context.getBeforeExecutionState().flatMap(beforeExecutionState -> this.captureStateAfterExecution(work, (BeforeExecutionContext)context, (BeforeExecutionState)beforeExecutionState, duration));
        return new AfterExecutionResult(){

            @Override
            public Optional<AfterExecutionState> getAfterExecutionState() {
                return afterExecutionState;
            }

            @Override
            public Try<ExecutionResult> getExecutionResult() {
                return result.getExecutionResult();
            }

            @Override
            public Duration getDuration() {
                return duration;
            }
        };
    }

    private Optional<AfterExecutionState> captureStateAfterExecution(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState, Duration duration) {
        return this.operation(operationContext -> {
            try {
                Timer timer = Time.startTimer();
                ImmutableSortedMap<String, FileSystemSnapshot> outputsProducedByWork = this.captureOutputs(work, context, beforeExecutionState);
                long snapshotOutputDuration = timer.getElapsedMillis();
                Duration originExecutionTime = duration.plus(Duration.ofMillis(snapshotOutputDuration));
                OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), originExecutionTime);
                DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, outputsProducedByWork, originMetadata, false);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.of(afterExecutionState);
            }
            catch (OutputSnapshotter.OutputFileSnapshottingException e) {
                work.handleUnreadableOutputs(e);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.empty();
            }
        }, BuildOperationDescriptor.displayName((String)("Snapshot outputs after executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> captureOutputs(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState) {
        ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
        if (beforeExecutionState.getDetectedOverlappingOutputs().isPresent()) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

