/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.cfa.CfaUtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgUtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.ControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.EventOccurrencesRangeInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.FirCallsEffectAnalyzer;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwareControlFlowInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.InitBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.NormalPath;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.PropertyInitializerExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ImmutableCollection;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005,-./0B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J<\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u0017*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u0004\u0018\u00010%*\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010&\u001a\u00020\u0011*\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010\u001c*\u0004\u0018\u00010 H\u0002R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "()V", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getContractDescription", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "investigate", "", "info", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "requiredRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "referenceToSymbol", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "getArgumentCallsEffect", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "arg", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getParameterCallsEffect", "index", "", "getParameterCallsEffectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "isFunctionalTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInPlaceLambda", "toQualifiedReference", "CapturedLambdaFinder", "IllegalScopeContext", "InvocationDataCollector", "LambdaInvocationInfo", "PathAwareLambdaInvocationInfo", "checkers"})
public final class FirCallsEffectAnalyzer
extends FirControlFlowChecker {
    @NotNull
    public static final FirCallsEffectAnalyzer INSTANCE = new FirCallsEffectAnalyzer();

    private FirCallsEffectAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        void destination$iv;
        void $this$filterTo$iv;
        ConeCallsEffectDeclaration effectDeclaration;
        Map map;
        boolean bl;
        int $i$a$-any-FirCallsEffectAnalyzer$analyze$22;
        boolean bl2;
        List<ConeEffectDeclaration> list2;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirSession session2 = context2.getSession();
        FirDeclaration firDeclaration = graph2.getDeclaration();
        List<ConeEffectDeclaration> list3 = list2 = firDeclaration instanceof FirFunction ? (FirFunction)firDeclaration : null;
        if (list2 == null) {
            return;
        }
        List<ConeEffectDeclaration> function2 = list2;
        if (!(function2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        list2 = ContractUtilsKt.getConeEffects(((FirContractDescriptionOwner)((Object)function2)).getContractDescription());
        if (list2 == null) {
            bl2 = false;
        } else {
            boolean bl3;
            block18: {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeEffectDeclaration it = (ConeEffectDeclaration)element$iv;
                        $i$a$-any-FirCallsEffectAnalyzer$analyze$22 = 0;
                        if (!(it instanceof ConeCallsEffectDeclaration)) continue;
                        bl3 = true;
                        break block18;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
        }
        if (!bl2) {
            return;
        }
        boolean $this$any$iv = false;
        Map functionalTypeEffects = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed222 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ConeCallsEffectDeclaration effectDeclaration2;
            Iterator parameter;
            $i$a$-any-FirCallsEffectAnalyzer$analyze$22 = index$iv2++;
            bl = false;
            if ($i$a$-any-FirCallsEffectAnalyzer$analyze$22 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int index2 = $i$a$-any-FirCallsEffectAnalyzer$analyze$22;
            boolean bl4 = false;
            if (!INSTANCE.isFunctionalTypeRef(((FirValueParameter)((Object)parameter)).getReturnTypeRef(), session2) || (effectDeclaration2 = INSTANCE.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), index2)) == null) continue;
            map = functionalTypeEffects;
            FirVariableSymbol<FirValueParameter> firVariableSymbol = ((FirValueParameter)((Object)parameter)).getSymbol();
            boolean bl5 = false;
            map.put(firVariableSymbol, effectDeclaration2);
        }
        if (this.isFunctionalTypeRef(function2.getReceiverTypeRef(), session2) && (effectDeclaration = this.getParameterCallsEffectDeclaration(((FirContractDescriptionOwner)((Object)function2)).getContractDescription(), -1)) != null) {
            Map $i$f$forEachIndexed222 = functionalTypeEffects;
            FirFunctionSymbol index$iv2 = function2.getSymbol();
            boolean element$iv = false;
            $i$f$forEachIndexed222.put(index$iv2, effectDeclaration);
        }
        if (functionalTypeEffects.isEmpty()) {
            return;
        }
        boolean $i$f$forEachIndexed222 = false;
        Map leakedSymbols = new LinkedHashMap();
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, new CapturedLambdaFinder((FirFunction<?>)((Object)function2)), new IllegalScopeContext(functionalTypeEffects.keySet(), leakedSymbols));
        Object index$iv2 = leakedSymbols;
        boolean element$iv = false;
        Iterator $i$f$forEachIndexed222 = index$iv2.entrySet().iterator();
        while ($i$f$forEachIndexed222.hasNext()) {
            Object item$iv;
            item$iv = index$iv2 = $i$f$forEachIndexed222.next();
            $i$a$-any-FirCallsEffectAnalyzer$analyze$22 = 0;
            AbstractFirBasedSymbol symbol22 = (AbstractFirBasedSymbol)item$iv.getKey();
            Object $i$a$-any-FirCallsEffectAnalyzer$analyze$22 = index$iv2;
            bl = false;
            List leakedPlaces = (List)$i$a$-any-FirCallsEffectAnalyzer$analyze$22.getValue();
            DiagnosticReporterKt.reportOn$default(reporter, ((FirContractDescriptionOwner)((Object)function2)).getContractDescription().getSource(), FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), symbol22, context2, null, 16, null);
            Iterable $this$forEach$iv = leakedPlaces;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                FirSourceElement it2 = (FirSourceElement)element$iv2;
                boolean bl6 = false;
                DiagnosticReporterKt.reportOn$default(reporter, it2, FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), symbol22, context2, null, 16, null);
            }
        }
        index$iv2 = functionalTypeEffects.keySet();
        boolean symbol22 = false;
        Collection symbol22 = new LinkedHashSet();
        ControlFlowInfo controlFlowInfo = PathAwareLambdaInvocationInfo.Companion.getEMPTY();
        TraverseDirection traverseDirection = TraverseDirection.Forward;
        ControlFlowGraph controlFlowGraph = graph2;
        boolean $i$f$filterTo = false;
        for (Object element$iv22 : $this$filterTo$iv) {
            AbstractFirBasedSymbol it = (AbstractFirBasedSymbol)element$iv22;
            boolean bl7 = false;
            Map it2 = leakedSymbols;
            boolean bl6 = false;
            map = it2;
            boolean bl8 = false;
            boolean bl9 = !map.containsKey(it);
            if (!bl9) continue;
            destination$iv.add(element$iv22);
        }
        void var26_58 = destination$iv;
        Set set = (Set)var26_58;
        Map<CFGNode<?>, ControlFlowInfo> invocationData = CfgTraverserKt.collectDataForNode(controlFlowGraph, traverseDirection, controlFlowInfo, new InvocationDataCollector(set));
        Object object = functionalTypeEffects;
        $i$f$filterTo = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object $this$forEach$iv = object = iterator2.next();
            boolean element$iv22 = false;
            AbstractFirBasedSymbol symbol3 = (AbstractFirBasedSymbol)$this$forEach$iv.getKey();
            Object element$iv22 = object;
            boolean it = false;
            ConeCallsEffectDeclaration effectDeclaration3 = (ConeCallsEffectDeclaration)element$iv22.getValue();
            Iterable $this$forEach$iv2 = CfgUtilsKt.getPreviousCfgNodes(graph2.getExitNode());
            boolean $i$f$forEach = false;
            block6: for (Object element$iv3 : $this$forEach$iv2) {
                CFGNode node = (CFGNode)element$iv3;
                boolean bl10 = false;
                EventOccurrencesRange requiredRange = effectDeclaration3.getKind();
                PathAwareLambdaInvocationInfo pathAwareInfo = (PathAwareLambdaInvocationInfo)MapsKt.getValue(invocationData, (Object)node);
                for (LambdaInvocationInfo info : (ImmutableCollection)pathAwareInfo.values()) {
                    if (!INSTANCE.investigate(info, symbol3, requiredRange, (FirContractDescriptionOwner)((Object)function2), reporter, context2)) continue;
                    continue block6;
                }
            }
        }
    }

    private final boolean investigate(LambdaInvocationInfo info, AbstractFirBasedSymbol<?> symbol2, EventOccurrencesRange requiredRange, FirContractDescriptionOwner function2, DiagnosticReporter reporter, CheckerContext context2) {
        EventOccurrencesRange foundRange;
        EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)info.get(symbol2));
        EventOccurrencesRange eventOccurrencesRange2 = foundRange = eventOccurrencesRange == null ? EventOccurrencesRange.ZERO : eventOccurrencesRange;
        if (!requiredRange.contains(foundRange)) {
            DiagnosticReporterKt.reportOn$default(reporter, function2.getContractDescription().getSource(), FirErrors.INSTANCE.getWRONG_INVOCATION_KIND(), symbol2, (Object)requiredRange, (Object)foundRange, context2, null, 64, null);
            return true;
        }
        return false;
    }

    private final boolean isFunctionalTypeRef(FirTypeRef $this$isFunctionalTypeRef, FirSession session2) {
        boolean bl;
        FirTypeRef firTypeRef = $this$isFunctionalTypeRef;
        if (firTypeRef == null) {
            bl = false;
        } else {
            ConeKotlinType coneKotlinType;
            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            bl = (coneKotlinType = coneKotlinType2) == null ? false : InferenceUtilsKt.isBuiltinFunctionalType(coneKotlinType, session2);
        }
        return bl;
    }

    private final FirContractDescription getContractDescription(FirFunction<?> $this$contractDescription) {
        FirContractDescriptionOwner firContractDescriptionOwner = $this$contractDescription instanceof FirContractDescriptionOwner ? (FirContractDescriptionOwner)((Object)$this$contractDescription) : null;
        return firContractDescriptionOwner == null ? null : firContractDescriptionOwner.getContractDescription();
    }

    private final ConeCallsEffectDeclaration getParameterCallsEffectDeclaration(FirContractDescription $this$getParameterCallsEffectDeclaration, int index2) {
        ConeEffectDeclaration coneEffectDeclaration;
        FirContractDescription firContractDescription = $this$getParameterCallsEffectDeclaration;
        List<ConeEffectDeclaration> effects = firContractDescription == null ? null : ContractUtilsKt.getConeEffects(firContractDescription);
        List<ConeEffectDeclaration> list2 = effects;
        if (list2 == null) {
            coneEffectDeclaration = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable = list2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ConeEffectDeclaration it = (ConeEffectDeclaration)t;
                    boolean bl3 = false;
                    if (!(it instanceof ConeCallsEffectDeclaration && ((ConeCallsEffectDeclaration)it).getValueParameterReference().getParameterIndex() == index2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            coneEffectDeclaration = v1;
        }
        ConeEffectDeclaration callsEffect = coneEffectDeclaration;
        return callsEffect instanceof ConeCallsEffectDeclaration ? (ConeCallsEffectDeclaration)callsEffect : null;
    }

    private final EventOccurrencesRange getArgumentCallsEffect(FirFunctionCall $this$getArgumentCallsEffect, FirExpression arg) {
        EventOccurrencesRange eventOccurrencesRange;
        FirResolvedArgumentList resolvedArguments;
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol($this$getArgumentCallsEffect);
        FirFunctionSymbol firFunctionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
        FirFunction function2 = firFunctionSymbol == null ? null : (FirFunction)firFunctionSymbol.getFir();
        firCallableSymbol = function2;
        FirContractDescription contractDescription = firCallableSymbol == null ? null : this.getContractDescription((FirFunction<?>)((Object)firCallableSymbol));
        FirArgumentList firArgumentList = $this$getArgumentCallsEffect.getArgumentList();
        FirResolvedArgumentList firResolvedArgumentList = resolvedArguments = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
        if (function2 != null && resolvedArguments != null) {
            FirValueParameter parameter = resolvedArguments.getMapping().get(arg);
            eventOccurrencesRange = this.getParameterCallsEffect(contractDescription, CollectionsKt.indexOf(function2.getValueParameters(), (Object)parameter));
        } else {
            eventOccurrencesRange = null;
        }
        return eventOccurrencesRange;
    }

    private final EventOccurrencesRange getParameterCallsEffect(FirContractDescription $this$getParameterCallsEffect, int index2) {
        ConeCallsEffectDeclaration coneCallsEffectDeclaration = this.getParameterCallsEffectDeclaration($this$getParameterCallsEffect, index2);
        return coneCallsEffectDeclaration == null ? null : coneCallsEffectDeclaration.getKind();
    }

    private final boolean isInPlaceLambda(FirFunction<?> $this$isInPlaceLambda) {
        return $this$isInPlaceLambda instanceof FirAnonymousFunction && ((FirAnonymousFunction)$this$isInPlaceLambda).isLambda() && ((FirAnonymousFunction)$this$isInPlaceLambda).getInvocationKind() != null;
    }

    private final FirReference toQualifiedReference(FirExpression $this$toQualifiedReference) {
        FirQualifiedAccess firQualifiedAccess = $this$toQualifiedReference instanceof FirQualifiedAccess ? (FirQualifiedAccess)((Object)$this$toQualifiedReference) : null;
        return firQualifiedAccess == null ? null : firQualifiedAccess.getCalleeReference();
    }

    private final AbstractFirBasedSymbol<?> referenceToSymbol(FirReference reference) {
        FirReference firReference = reference;
        return firReference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : (firReference instanceof FirThisReference ? ((FirThisReference)reference).getBoundSymbol() : null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ2\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0013R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "leakedSymbols", "", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "(Ljava/util/Set;Ljava/util/Map;)V", "illegalScopeDepth", "", "Ljava/lang/Integer;", "inIllegalScope", "", "getInIllegalScope", "()Z", "scopeDepth", "checkExpressionForLeakedSymbols", "", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "source", "illegalUsage", "Lkotlin/Function0;", "enterScope", "legal", "exitScope", "checkers"})
    private static final class IllegalScopeContext {
        @NotNull
        private final Set<AbstractFirBasedSymbol<?>> functionalTypeSymbols;
        @NotNull
        private final Map<AbstractFirBasedSymbol<?>, List<FirSourceElement>> leakedSymbols;
        private int scopeDepth;
        @Nullable
        private Integer illegalScopeDepth;

        public IllegalScopeContext(@NotNull Set<? extends AbstractFirBasedSymbol<?>> functionalTypeSymbols, @NotNull Map<AbstractFirBasedSymbol<?>, List<FirSourceElement>> leakedSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            Intrinsics.checkNotNullParameter(leakedSymbols, (String)"leakedSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
            this.leakedSymbols = leakedSymbols;
        }

        public final boolean getInIllegalScope() {
            return this.illegalScopeDepth != null;
        }

        public final void enterScope(boolean legal) {
            IllegalScopeContext illegalScopeContext = this;
            int n = illegalScopeContext.scopeDepth;
            illegalScopeContext.scopeDepth = n + 1;
            if (this.illegalScopeDepth == null && !legal) {
                this.illegalScopeDepth = this.scopeDepth;
            }
        }

        public final void exitScope() {
            Integer n = this.illegalScopeDepth;
            if (n != null && this.scopeDepth == n) {
                this.illegalScopeDepth = null;
            }
            IllegalScopeContext illegalScopeContext = this;
            int n2 = illegalScopeContext.scopeDepth;
            illegalScopeContext.scopeDepth = n2 + -1;
        }

        public final void checkExpressionForLeakedSymbols(@Nullable FirExpression fir, @Nullable FirSourceElement source, @NotNull Function0<Boolean> illegalUsage) {
            Intrinsics.checkNotNullParameter(illegalUsage, (String)"illegalUsage");
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this.functionalTypeSymbols.contains(symbol2) && (this.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object;
                Map $this$getOrPut$iv = this.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source);
            }
        }

        public static /* synthetic */ void checkExpressionForLeakedSymbols$default(IllegalScopeContext this_, FirExpression fir, FirSourceElement source, Function0 illegalUsage, int n, Object object) {
            if ((n & 2) != 0) {
                FirExpression firExpression2 = fir;
                FirSourceElement firSourceElement = source = firExpression2 == null ? null : firExpression2.getSource();
            }
            if ((n & 4) != 0) {
                illegalUsage = checkExpressionForLeakedSymbols.1.INSTANCE;
            }
            Intrinsics.checkNotNullParameter((Object)illegalUsage, (String)"illegalUsage");
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir));
            if (symbol2 != null && this_.functionalTypeSymbols.contains(symbol2) && (this_.getInIllegalScope() || ((Boolean)illegalUsage.invoke()).booleanValue())) {
                Object object2;
                Map $this$getOrPut$iv = this_.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(symbol2);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(symbol2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object2, source);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001c\u0010\u0015\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$CapturedLambdaFinder;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$IllegalScopeContext;", "rootFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "getRootFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitFunctionEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionEnterNode;", "visitFunctionExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionExitNode;", "visitInitBlockEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockEnterNode;", "visitInitBlockExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/InitBlockExitNode;", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitPropertyInitializerEnterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerEnterNode;", "visitPropertyInitializerExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/PropertyInitializerExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class CapturedLambdaFinder
    extends ControlFlowGraphVisitor<Unit, IllegalScopeContext> {
        @NotNull
        private final FirFunction<?> rootFunction;

        public CapturedLambdaFinder(@NotNull FirFunction<?> rootFunction) {
            Intrinsics.checkNotNullParameter(rootFunction, (String)"rootFunction");
            this.rootFunction = rootFunction;
        }

        @NotNull
        public final FirFunction<?> getRootFunction() {
            return this.rootFunction;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitFunctionEnterNode(@NotNull FunctionEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(node.getFir() == this.rootFunction || INSTANCE.isInPlaceLambda((FirFunction)node.getFir()));
        }

        @Override
        public void visitFunctionExitNode(@NotNull FunctionExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitPropertyInitializerEnterNode(@NotNull PropertyInitializerEnterNode node, @NotNull IllegalScopeContext data) {
            FirExpression fir$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
            FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
            FirSourceElement source$iv = firExpression2 == null ? null : firExpression2.getSource();
            boolean $i$f$checkExpressionForLeakedSymbols = false;
            AbstractFirBasedSymbol symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
            if (symbol$iv != null && data.functionalTypeSymbols.contains(symbol$iv) && (data.getInIllegalScope() || false)) {
                Object object;
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        @Override
        public void visitPropertyInitializerExitNode(@NotNull PropertyInitializerExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitInitBlockEnterNode(@NotNull InitBlockEnterNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.enterScope(false);
        }

        @Override
        public void visitInitBlockExitNode(@NotNull InitBlockExitNode node, @NotNull IllegalScopeContext data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.exitScope();
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                AbstractFirBasedSymbol symbol$iv;
                FirSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    FirExpression firExpression2 = fir$iv = node.getFir().getRValue();
                    source$iv = firExpression2 == null ? null : firExpression2.getSource();
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !data.functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (data.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull IllegalScopeContext data) {
            block5: {
                Object object;
                AbstractFirBasedSymbol symbol$iv;
                FirSourceElement source$iv;
                block6: {
                    FirExpression fir$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    FirExpression firExpression2 = fir$iv = node.getFir().getInitializer();
                    source$iv = firExpression2 == null ? null : firExpression2.getSource();
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !data.functionalTypeSymbols.contains(symbol$iv)) break block5;
                    if (data.getInIllegalScope()) break block6;
                    boolean bl = false;
                    if (!true) break block5;
                }
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object, source$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull IllegalScopeContext data) {
            Object object;
            block9: {
                Object object2;
                void this_$iv;
                AbstractFirBasedSymbol symbol$iv;
                Iterator<FirExpression> callSource;
                block10: {
                    CallableId callableId;
                    Iterator<FirExpression> iterator2;
                    FirFunctionSymbol functionSymbol;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
                    FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
                    FirContractDescription contractDescription = firFunctionSymbol == null ? null : ((iterator2 = (FirFunction)firFunctionSymbol.getFir()) == null ? null : INSTANCE.getContractDescription((FirFunction)((Object)iterator2)));
                    FirExpression firExpression2 = node.getFir().getExplicitReceiver();
                    iterator2 = firExpression2 == null ? null : firExpression2.getSource();
                    callSource = iterator2 == null ? node.getFir().getSource() : iterator2;
                    iterator2 = data;
                    FirExpression fir$iv = node.getFir().getExplicitReceiver();
                    boolean $i$f$checkExpressionForLeakedSymbols = false;
                    symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(fir$iv));
                    if (symbol$iv == null || !((IllegalScopeContext)this_$iv).functionalTypeSymbols.contains(symbol$iv)) break block9;
                    if (this_$iv.getInIllegalScope()) break block10;
                    boolean bl = false;
                    object = functionSymbol;
                    if (!(!(object == null ? false : ((callableId = ((FirFunctionSymbol)object).getCallableId()) == null ? false : ResolveUtilsKt.isInvoke(callableId))) && ((object = contractDescription) == null ? null : INSTANCE.getParameterCallsEffect((FirContractDescription)object, -1)) == null)) break block9;
                }
                Map $this$getOrPut$iv$iv = ((IllegalScopeContext)this_$iv).leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object2 = answer$iv$iv;
                } else {
                    object2 = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object2, callSource);
            }
            for (FirExpression arg : node.getFir().getArgumentList().getArguments()) {
                Object object3;
                object = arg;
                FirSourceElement source$iv = object == null ? null : ((FirExpression)object).getSource();
                boolean $i$f$checkExpressionForLeakedSymbols = false;
                AbstractFirBasedSymbol symbol$iv = INSTANCE.referenceToSymbol(INSTANCE.toQualifiedReference(arg));
                if (symbol$iv == null || !data.functionalTypeSymbols.contains(symbol$iv)) continue;
                if (!data.getInIllegalScope()) {
                    boolean bl = false;
                    if (!(INSTANCE.getArgumentCallsEffect(node.getFir(), arg) == null)) continue;
                }
                Map $this$getOrPut$iv$iv = data.leakedSymbols;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(symbol$iv);
                if (value$iv$iv == null) {
                    boolean bl = false;
                    boolean bl3 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(symbol$iv, answer$iv$iv);
                    object3 = answer$iv$iv;
                } else {
                    object3 = value$iv$iv;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)object3, source$iv);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001\u000fB\u001f\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R0\u0010\u0007\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/EventOccurrencesRangeInfo;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "map", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "Companion", "checkers"})
    public static final class LambdaInvocationInfo
    extends EventOccurrencesRangeInfo<LambdaInvocationInfo, FirBasedSymbol<?>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> constructor;
        @NotNull
        private final Function0<LambdaInvocationInfo> empty;
        @NotNull
        private static final LambdaInvocationInfo EMPTY = new LambdaInvocationInfo(null, 1, null);

        public LambdaInvocationInfo(@NotNull PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ LambdaInvocationInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<FirBasedSymbol<?>, ? extends EventOccurrencesRange>, LambdaInvocationInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<LambdaInvocationInfo> getEmpty() {
            return this.empty;
        }

        public LambdaInvocationInfo() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LambdaInvocationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006R,\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0004\u0012\u00020\u00000\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwareControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$LambdaInvocationInfo;", "map", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "constructor", "Lkotlin/Function1;", "getConstructor", "()Lkotlin/jvm/functions/Function1;", "empty", "Lkotlin/Function0;", "getEmpty", "()Lkotlin/jvm/functions/Function0;", "Companion", "checkers"})
    public static final class PathAwareLambdaInvocationInfo
    extends PathAwareControlFlowInfo<PathAwareLambdaInvocationInfo, LambdaInvocationInfo> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Function1<PersistentMap<EdgeLabel, LambdaInvocationInfo>, PathAwareLambdaInvocationInfo> constructor;
        @NotNull
        private final Function0<PathAwareLambdaInvocationInfo> empty;
        @NotNull
        private static final PathAwareLambdaInvocationInfo EMPTY;

        public PathAwareLambdaInvocationInfo(@NotNull PersistentMap<EdgeLabel, LambdaInvocationInfo> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.constructor = constructor.1.INSTANCE;
            this.empty = (Function0)new PropertyReference0(Companion){

                @NotNull
                public String getName() {
                    return "EMPTY";
                }

                @NotNull
                public KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class);
                }

                @NotNull
                public String getSignature() {
                    return "getEMPTY()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;";
                }

                @Nullable
                public Object get() {
                    return ((Companion)this.receiver).getEMPTY();
                }
            };
        }

        public /* synthetic */ PathAwareLambdaInvocationInfo(PersistentMap persistentMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                persistentMap = ExtensionsKt.persistentMapOf(new Pair[0]);
            }
            this(persistentMap);
        }

        @Override
        @NotNull
        protected Function1<PersistentMap<EdgeLabel, LambdaInvocationInfo>, PathAwareLambdaInvocationInfo> getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        protected Function0<PathAwareLambdaInvocationInfo> getEmpty() {
            return this.empty;
        }

        public PathAwareLambdaInvocationInfo() {
            this(null, 1, null);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NormalPath.INSTANCE, (Object)LambdaInvocationInfo.Companion.getEMPTY())};
            EMPTY = new PathAwareLambdaInvocationInfo(ExtensionsKt.persistentMapOf(pairArray));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "getEMPTY", "()Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "checkers"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PathAwareLambdaInvocationInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u00030\u0001B\u0017\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ#\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001J*\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J.\u0010\u0014\u001a\u00020\u00022\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00152\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00040\u0003H\u0016J\u001c\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J%\u0010\u0019\u001a\u00020\u0002*\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0082\bR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$InvocationDataCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/FirCallsEffectAnalyzer$PathAwareLambdaInvocationInfo;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "functionalTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "(Ljava/util/Set;)V", "getFunctionalTypeSymbols", "()Ljava/util/Set;", "collectDataForReference", "", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "visitFunctionCallNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "data", "visitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "addInvocationInfo", "range", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "checkReference", "rangeGetter", "Lkotlin/Function0;", "checkers"})
    private static final class InvocationDataCollector
    extends ControlFlowGraphVisitor<PathAwareLambdaInvocationInfo, Collection<? extends Pair<? extends EdgeLabel, ? extends PathAwareLambdaInvocationInfo>>> {
        @NotNull
        private final Set<AbstractFirBasedSymbol<?>> functionalTypeSymbols;

        public InvocationDataCollector(@NotNull Set<? extends AbstractFirBasedSymbol<?>> functionalTypeSymbols) {
            Intrinsics.checkNotNullParameter(functionalTypeSymbols, (String)"functionalTypeSymbols");
            this.functionalTypeSymbols = functionalTypeSymbols;
        }

        @NotNull
        public final Set<AbstractFirBasedSymbol<?>> getFunctionalTypeSymbols() {
            return this.functionalTypeSymbols;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PathAwareLambdaInvocationInfo visitNode(@NotNull CFGNode<?> node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareLambdaInvocationInfo>> data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (data.isEmpty()) {
                return PathAwareLambdaInvocationInfo.Companion.getEMPTY();
            }
            Iterable $this$map$iv = data;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$label$info;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EdgeLabel label = (EdgeLabel)$dstr$label$info.component1();
                PathAwareLambdaInvocationInfo info = (PathAwareLambdaInvocationInfo)$dstr$label$info.component2();
                PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo = (PathAwareLambdaInvocationInfo)info.applyLabel(node, label);
                collection.add(pathAwareLambdaInvocationInfo);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                PathAwareLambdaInvocationInfo $i$f$mapTo2 = (PathAwareLambdaInvocationInfo)iterator$iv.next();
                PathAwareLambdaInvocationInfo p0 = (PathAwareLambdaInvocationInfo)accumulator$iv;
                boolean bl = false;
                accumulator$iv = (PathAwareLambdaInvocationInfo)p0.merge((PathAwareControlFlowInfo)p1);
            }
            return (PathAwareLambdaInvocationInfo)accumulator$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PathAwareLambdaInvocationInfo visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull Collection<? extends Pair<? extends EdgeLabel, PathAwareLambdaInvocationInfo>> data) {
            PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo;
            EventOccurrencesRange eventOccurrencesRange;
            void var14_13;
            void var15_12;
            void $this$checkReference$iv;
            FirReference firReference;
            void this_$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PathAwareLambdaInvocationInfo dataForNode = this.visitNode((CFGNode)node, data);
            FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(node.getFir());
            FirFunctionSymbol functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
            Iterator<FirExpression> iterator2 = functionSymbol;
            FirContractDescription contractDescription = iterator2 == null ? null : ((object = (FirFunction)((AbstractFirBasedSymbol)((Object)iterator2)).getFir()) == null ? null : INSTANCE.getContractDescription((FirFunction)object));
            iterator2 = this;
            object = dataForNode;
            Object reference$iv = INSTANCE.toQualifiedReference(node.getFir().getExplicitReceiver());
            boolean $i$f$checkReference2 = false;
            if (((InvocationDataCollector)this_$iv).collectDataForReference((FirReference)reference$iv)) {
                CallableId callableId;
                firReference = reference$iv;
                var15_12 = $this$checkReference$iv;
                var14_13 = this_$iv;
                boolean bl = false;
                Object object2 = functionSymbol;
                eventOccurrencesRange = (object2 == null ? false : ((callableId = object2.getCallableId()) == null ? false : ResolveUtilsKt.isInvoke(callableId))) ? EventOccurrencesRange.EXACTLY_ONCE : ((object2 = INSTANCE.getParameterCallsEffect(contractDescription, -1)) == null ? EventOccurrencesRange.UNKNOWN : object2);
                pathAwareLambdaInvocationInfo = ((InvocationDataCollector)var14_13).addInvocationInfo((PathAwareLambdaInvocationInfo)var15_12, firReference, eventOccurrencesRange);
            } else {
                pathAwareLambdaInvocationInfo = $this$checkReference$iv;
            }
            dataForNode = pathAwareLambdaInvocationInfo;
            for (FirExpression arg : node.getFir().getArgumentList().getArguments()) {
                PathAwareLambdaInvocationInfo pathAwareLambdaInvocationInfo2;
                void $this$checkReference$iv2;
                void this_$iv2;
                reference$iv = this;
                PathAwareLambdaInvocationInfo $i$f$checkReference2 = dataForNode;
                FirReference reference$iv2 = INSTANCE.toQualifiedReference(arg);
                boolean $i$f$checkReference3 = false;
                if (((InvocationDataCollector)this_$iv2).collectDataForReference(reference$iv2)) {
                    firReference = reference$iv2;
                    var15_12 = $this$checkReference$iv2;
                    var14_13 = this_$iv2;
                    boolean bl = false;
                    EventOccurrencesRange eventOccurrencesRange2 = INSTANCE.getArgumentCallsEffect(node.getFir(), arg);
                    eventOccurrencesRange = eventOccurrencesRange2 == null ? EventOccurrencesRange.ZERO : eventOccurrencesRange2;
                    pathAwareLambdaInvocationInfo2 = ((InvocationDataCollector)var14_13).addInvocationInfo((PathAwareLambdaInvocationInfo)var15_12, firReference, eventOccurrencesRange);
                } else {
                    pathAwareLambdaInvocationInfo2 = $this$checkReference$iv2;
                }
                dataForNode = pathAwareLambdaInvocationInfo2;
            }
            return dataForNode;
        }

        private final boolean collectDataForReference(FirReference reference) {
            boolean bl = false;
            return reference != null && CollectionsKt.contains((Iterable)this.functionalTypeSymbols, (Object)INSTANCE.referenceToSymbol(reference));
        }

        private final PathAwareLambdaInvocationInfo addInvocationInfo(PathAwareLambdaInvocationInfo $this$addInvocationInfo, FirReference reference, EventOccurrencesRange range) {
            AbstractFirBasedSymbol symbol2 = INSTANCE.referenceToSymbol(reference);
            return symbol2 != null ? (PathAwareLambdaInvocationInfo)CfaUtilsKt.addRange((PathAwareControlFlowInfo)$this$addInvocationInfo, symbol2, range, addInvocationInfo.1.INSTANCE) : $this$addInvocationInfo;
        }
    }
}

