/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u001e\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0012H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018*\u00020)2\u0006\u0010&\u001a\u00020\u0012H\u0002J\f\u0010*\u001a\u00020\u001f*\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "erasedType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getErasedType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;", "generateIsInterface", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argument", "toType", "generateIsSubClass", "generateTypeCheck", "valueProvider", "Lkotlin/Function0;", "generateTypeCheckNonNull", "generateTypeCheckWithTypeParameter", "lowerCast", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSafe", "", "lowerImplicitCast", "lowerInstanceOf", "inverted", "lowerIntegerCoercion", "narrowType", "fromType", "value", "visitTypeOperator", "cacheValue", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "isInlined", "backend.wasm"})
public final class WasmBaseTypeOperatorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final IrBuiltIns builtIns;
    private DeclarationIrBuilder builder;

    public WasmBaseTypeOperatorTransformer(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.symbols = this.context.getWasmSymbols();
        this.builtIns = this.context.getIrBuiltIns();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitTypeOperator(expression2);
        BackendContext backendContext = this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
        IrTypeOperator irTypeOperator = expression2.getOperator();
        int n = WhenMappings.$EnumSwitchMapping$0[irTypeOperator.ordinal()];
        switch (n) {
            case 1: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 2: {
                String string2 = "Dynamic casts are not supported in Wasm backend";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            case 3: {
                irExpression = expression2.getArgument();
                break;
            }
            case 4: {
                irExpression = this.lowerIntegerCoercion(expression2);
                break;
            }
            case 5: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 6: {
                irExpression = this.lowerInstanceOf(expression2, false);
                break;
            }
            case 7: {
                irExpression = this.lowerInstanceOf(expression2, true);
                break;
            }
            case 8: {
                irExpression = this.lowerCast(expression2, false);
                break;
            }
            case 9: {
                irExpression = this.lowerCast(expression2, true);
                break;
            }
            case 10: {
                String string3 = Intrinsics.stringPlus((String)"SAM conversion: ", (Object)RenderIrElementKt.render(expression2));
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string3);
            }
            case 11: {
                irExpression = expression2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, boolean inverted) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrBuilderWithScope irBuilderWithScope = this.builder;
        if (irBuilderWithScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        } else {
            declarationIrBuilder = irBuilderWithScope;
        }
        irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = this.builtIns.getBooleanType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerInstanceOf_u24lambda_u2d0 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerInstanceOf_u24lambda_u2d0, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument2, expression2.getTypeOperand());
        if (inverted) {
            DeclarationIrBuilder declarationIrBuilder2;
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            } else {
                declarationIrBuilder2 = declarationIrBuilder3;
            }
            $this$lowerInstanceOf_u24lambda_u2d0.unaryPlus(LowerUtilsKt.irNot(declarationIrBuilder2, check2));
        } else {
            $this$lowerInstanceOf_u24lambda_u2d0.unaryPlus(check2);
        }
        return this_$iv$iv.doBuild();
    }

    private final Function0<IrExpression> cacheValue(IrBlockBuilder $this$cacheValue, IrExpression value2) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(value2, true, false, null, 6, null) && IrUtilsKt.isTrivial(value2)) {
            return (Function0)new Function0<IrExpression>(value2){
                final /* synthetic */ IrExpression $value;
                {
                    this.$value = $value;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrExpression invoke() {
                    void p1;
                    void p0;
                    IrElement $this$deepCopyWithSymbols_u24default$iv = this.$value;
                    IrDeclarationParent initialParent$iv = null;
                    boolean $i$f$deepCopyWithSymbols = false;
                    DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                    IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                    DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                    TypeRemapper typeRemapper = typeRemapper$iv;
                    SymbolRemapper symbolRemapper = symbolRemapper$iv;
                    IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
                    IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                    if (irElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    return (IrExpression)((IrElement)((IrExpression)irElement2));
                }
            };
        }
        IrVariable tmpVal = IrBuildersKt.createTmpVariable$default($this$cacheValue, value2, null, false, null, null, 30, null);
        return (Function0)new Function0<IrGetValueImpl>(this, tmpVal){
            final /* synthetic */ WasmBaseTypeOperatorTransformer this$0;
            final /* synthetic */ IrVariable $tmpVal;
            {
                this.this$0 = $receiver;
                this.$tmpVal = $tmpVal;
                super(0);
            }

            @NotNull
            public final IrGetValueImpl invoke() {
                DeclarationIrBuilder declarationIrBuilder;
                DeclarationIrBuilder declarationIrBuilder2 = WasmBaseTypeOperatorTransformer.access$getBuilder$p(this.this$0);
                if (declarationIrBuilder2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                    declarationIrBuilder = null;
                } else {
                    declarationIrBuilder = declarationIrBuilder2;
                }
                return ExpressionHelpersKt.irGet(declarationIrBuilder, this.$tmpVal);
            }
        };
    }

    private final boolean isInlined(IrType $this$isInlined) {
        return this.context.getInlineClassesUtils().isTypeInlined($this$isInlined);
    }

    private final IrType getErasedType(IrType $this$erasedType) {
        IrClass irClass2 = TypeTransformerKt.getErasedUpperBound($this$erasedType);
        IrSimpleType irSimpleType = irClass2 == null ? null : IrUtilsKt.getDefaultType(irClass2);
        return irSimpleType == null ? this.builtIns.getAnyType() : (IrType)irSimpleType;
    }

    private final IrExpression generateTypeCheck(Function0<? extends IrExpression> valueProvider, IrType toType) {
        IrExpression irExpression;
        IrType toNotNullable = IrTypesKt.makeNotNull(toType);
        IrExpression valueInstance = (IrExpression)valueProvider.invoke();
        IrType fromType = valueInstance.getType();
        if (this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder;
            boolean result2 = IrTypeUtilsKt.isSubtypeOf(this.getErasedType(fromType), this.getErasedType(toType), this.builtIns);
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            } else {
                declarationIrBuilder = declarationIrBuilder2;
            }
            return ExpressionHelpersKt.irBoolean(declarationIrBuilder, result2);
        }
        IrExpression instanceCheck = this.generateTypeCheckNonNull(valueInstance, toNotNullable);
        boolean isFromNullable = IrTypeUtilsKt.isNullable(valueInstance.getType());
        boolean isToNullable = IrTypeUtilsKt.isNullable(toType);
        if (!isFromNullable) {
            irExpression = instanceCheck;
        } else {
            DeclarationIrBuilder declarationIrBuilder;
            DeclarationIrBuilder declarationIrBuilder3;
            DeclarationIrBuilder declarationIrBuilder4;
            DeclarationIrBuilder declarationIrBuilder5 = this.builder;
            if (declarationIrBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder4 = null;
            } else {
                declarationIrBuilder4 = declarationIrBuilder5;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder4;
            IrType irType = this.builtIns.getBooleanType();
            declarationIrBuilder5 = this.builder;
            if (declarationIrBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            } else {
                declarationIrBuilder3 = declarationIrBuilder5;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irEqualsNull(declarationIrBuilder3, (IrExpression)valueProvider.invoke());
            declarationIrBuilder5 = this.builder;
            if (declarationIrBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            } else {
                declarationIrBuilder = declarationIrBuilder5;
            }
            irExpression = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression2, ExpressionHelpersKt.irBoolean(declarationIrBuilder, isToNullable), instanceCheck, null, 16, null);
        }
        return irExpression;
    }

    private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrType irType = expression2.getTypeOperand();
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) {
            irExpression = expression2.getArgument();
        } else if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) {
            DeclarationIrBuilder declarationIrBuilder;
            Object object = this.builder;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            } else {
                declarationIrBuilder = object;
            }
            object = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getIntToLong());
            boolean bl = false;
            boolean bl2 = false;
            Object $this$lowerIntegerCoercion_u24lambda_u2d1 = object;
            boolean bl3 = false;
            ((IrFunctionAccessExpression)$this$lowerIntegerCoercion_u24lambda_u2d1).putValueArgument(0, expression2.getArgument());
            irExpression = (IrExpression)object;
        } else {
            String string2 = "Unreachable execution (coercion to non-Integer type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckNonNull(IrExpression argument2, IrType toType) {
        IrExpression irExpression;
        boolean bl = !IrTypePredicatesKt.isMarkedNullable(toType);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (IrTypePredicatesKt.isNothing(toType)) {
            DeclarationIrBuilder declarationIrBuilder;
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder2;
            IrBuilderWithScope irBuilderWithScope = this.builder;
            if (irBuilderWithScope == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            } else {
                declarationIrBuilder2 = irBuilderWithScope;
            }
            irBuilderWithScope = declarationIrBuilder2;
            IrType resultType$iv = this.builtIns.getBooleanType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$generateTypeCheckNonNull_u24lambda_u2d2 = this_$iv$iv;
            boolean bl5 = false;
            $this$generateTypeCheckNonNull_u24lambda_u2d2.unaryPlus(argument2);
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            } else {
                declarationIrBuilder = declarationIrBuilder3;
            }
            $this$generateTypeCheckNonNull_u24lambda_u2d2.unaryPlus(ExpressionHelpersKt.irFalse(declarationIrBuilder));
            irExpression = this_$iv$iv.doBuild();
        } else {
            irExpression = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter(toType) ? this.generateTypeCheckWithTypeParameter(argument2, toType) : (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface(toType) ? this.generateIsInterface(argument2, toType) : this.generateIsSubClass(argument2, toType));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression narrowType(IrType fromType, IrType toType, IrExpression value2) {
        DeclarationIrBuilder declarationIrBuilder;
        if (Intrinsics.areEqual((Object)fromType, (Object)toType)) {
            return value2;
        }
        if (Intrinsics.areEqual((Object)toType, (Object)this.builtIns.getNothingNType())) {
            DeclarationIrBuilder declarationIrBuilder2;
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder3;
            IrBuilderWithScope irBuilderWithScope = this.builder;
            if (irBuilderWithScope == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            } else {
                declarationIrBuilder3 = irBuilderWithScope;
            }
            irBuilderWithScope = declarationIrBuilder3;
            IrType resultType$iv = this.builtIns.getNothingNType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u2d3 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u2d3.unaryPlus(value2);
            DeclarationIrBuilder declarationIrBuilder4 = this.builder;
            if (declarationIrBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            } else {
                declarationIrBuilder2 = declarationIrBuilder4;
            }
            $this$narrowType_u24lambda_u2d3.unaryPlus(ExpressionHelpersKt.irNull(declarationIrBuilder2));
            return this_$iv$iv.doBuild();
        }
        if (this.isInlined(toType) && !this.isInlined(fromType)) {
            Object[] objectArray;
            Object $this$irComposite_u24default$iv = this.builder;
            if ($this$irComposite_u24default$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                objectArray = null;
            } else {
                objectArray = $this$irComposite_u24default$iv;
            }
            $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)objectArray, this.symbols.getUnboxIntrinsic(), toType, CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean startOffset$iv = false;
            boolean endOffset$iv = false;
            Object it = $this$irComposite_u24default$iv;
            boolean bl = false;
            ((IrMemberAccessExpression)it).putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (!this.isInlined(toType) && this.isInlined(fromType)) {
            Object[] objectArray;
            Object $this$irComposite_u24default$iv = this.builder;
            if ($this$irComposite_u24default$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                objectArray = null;
            } else {
                objectArray = $this$irComposite_u24default$iv;
            }
            $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)objectArray, this.symbols.getBoxIntrinsic(), toType, CollectionsKt.listOf((Object[])$this$irComposite_u24default$iv));
            boolean startOffset$iv = false;
            boolean endOffset$iv = false;
            Object it = $this$irComposite_u24default$iv;
            boolean bl = false;
            ((IrMemberAccessExpression)it).putValueArgument(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (IrTypeUtilsKt.isSubtypeOf(this.getErasedType(fromType), this.getErasedType(toType), this.context.getIrBuiltIns())) {
            return value2;
        }
        if (IrTypePredicatesKt.isNothing(toType)) {
            return value2;
        }
        if (IrTypeUtilsKt.isNullable(toType) && IrTypeUtilsKt.isNullable(fromType)) {
            void $this$narrowType_u24lambda_u2d7_u24lambda_u2d6;
            DeclarationIrBuilder declarationIrBuilder5;
            DeclarationIrBuilder declarationIrBuilder6;
            DeclarationIrBuilder declarationIrBuilder7;
            DeclarationIrBuilder declarationIrBuilder8;
            IrBuilderWithScope $this$irComposite_u24default$iv = this.builder;
            if ($this$irComposite_u24default$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder8 = null;
            } else {
                declarationIrBuilder8 = $this$irComposite_u24default$iv;
            }
            $this$irComposite_u24default$iv = declarationIrBuilder8;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            IrBlockBuilder $this$narrowType_u24lambda_u2d7 = this_$iv$iv;
            boolean bl = false;
            Function0<IrExpression> cachedValue = this.cacheValue($this$narrowType_u24lambda_u2d7, value2);
            Object object = this.builder;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder7 = null;
            } else {
                declarationIrBuilder7 = object;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder7;
            IrExpression irExpression = (IrExpression)cachedValue.invoke();
            object = this.builder;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder6 = null;
            } else {
                declarationIrBuilder6 = object;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irNull(declarationIrBuilder6, toType);
            object = this.builder;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder5 = null;
            } else {
                declarationIrBuilder5 = object;
            }
            object = ExpressionHelpersKt.irCall$default(declarationIrBuilder5, this.symbols.getWasmRefCast(), toType, 0, 0, null, 28, null);
            boolean bl2 = false;
            boolean bl3 = false;
            Object object2 = object;
            IrExpression irExpression3 = irExpression2;
            IrExpression irExpression4 = irExpression;
            IrType irType = toType;
            IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
            IrBlockBuilder irBlockBuilder = $this$narrowType_u24lambda_u2d7;
            boolean bl4 = false;
            $this$narrowType_u24lambda_u2d7_u24lambda_u2d6.putTypeArgument(0, fromType);
            $this$narrowType_u24lambda_u2d7_u24lambda_u2d6.putTypeArgument(1, toType);
            $this$narrowType_u24lambda_u2d7_u24lambda_u2d6.putValueArgument(0, (IrExpression)cachedValue.invoke());
            Unit unit = Unit.INSTANCE;
            irBlockBuilder.unaryPlus(ExpressionHelpersKt.irIfNull(irBuilderWithScope2, irType, irExpression4, irExpression3, (IrExpression)object));
            return this_$iv$iv.doBuild();
        }
        Object object = this.builder;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        } else {
            declarationIrBuilder = object;
        }
        object = ExpressionHelpersKt.irCall$default(declarationIrBuilder, this.symbols.getWasmRefCast(), toType, 0, 0, null, 28, null);
        boolean bl = false;
        boolean bl5 = false;
        Object $this$narrowType_u24lambda_u2d8 = object;
        boolean bl6 = false;
        ((IrMemberAccessExpression)$this$narrowType_u24lambda_u2d8).putTypeArgument(0, fromType);
        ((IrMemberAccessExpression)$this$narrowType_u24lambda_u2d8).putTypeArgument(1, toType);
        ((IrFunctionAccessExpression)$this$narrowType_u24lambda_u2d8).putValueArgument(0, value2);
        return (IrExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrTypeOperatorCall expression2, boolean isSafe) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrExpression irExpression;
        IrBuilderWithScope irBuilderWithScope;
        IrType toType = expression2.getTypeOperand();
        IrType fromType = expression2.getArgument().getType();
        if (IrTypeUtilsKt.isSubtypeOf(this.getErasedType(fromType), this.getErasedType(expression2.getType()), this.context.getIrBuiltIns())) {
            return this.narrowType(fromType, expression2.getType(), expression2.getArgument());
        }
        if (isSafe) {
            DeclarationIrBuilder declarationIrBuilder2;
            irBuilderWithScope = this.builder;
            if (irBuilderWithScope == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            } else {
                declarationIrBuilder2 = irBuilderWithScope;
            }
            irExpression = ExpressionHelpersKt.irNull(declarationIrBuilder2);
        } else {
            DeclarationIrBuilder declarationIrBuilder3;
            irBuilderWithScope = this.builder;
            if (irBuilderWithScope == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            } else {
                declarationIrBuilder3 = irBuilderWithScope;
            }
            irExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder3, this.context.getIr().getSymbols().getThrowTypeCastException());
        }
        IrExpression failResult = irExpression;
        irBuilderWithScope = this.builder;
        if (irBuilderWithScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        } else {
            declarationIrBuilder = irBuilderWithScope;
        }
        irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = expression2.getType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerCast_u24lambda_u2d9 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument2 = this.cacheValue((IrBlockBuilder)$this$lowerCast_u24lambda_u2d9, expression2.getArgument());
        IrExpression narrowArg = this.narrowType(fromType, expression2.getType(), (IrExpression)argument2.invoke());
        IrExpression check2 = this.generateTypeCheck(argument2, toType);
        if (check2 instanceof IrConst) {
            Object t = ((IrConst)check2).getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean value2 = (Boolean)t;
            if (value2) {
                $this$lowerCast_u24lambda_u2d9.unaryPlus(narrowArg);
            } else {
                $this$lowerCast_u24lambda_u2d9.unaryPlus(failResult);
            }
        } else {
            DeclarationIrBuilder declarationIrBuilder4;
            DeclarationIrBuilder declarationIrBuilder5 = this.builder;
            if (declarationIrBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder4 = null;
            } else {
                declarationIrBuilder4 = declarationIrBuilder5;
            }
            $this$lowerCast_u24lambda_u2d9.unaryPlus(ExpressionHelpersKt.irIfThenElse$default(declarationIrBuilder4, expression2.getType(), check2, narrowArg, failResult, null, 16, null));
        }
        return this_$iv$iv.doBuild();
    }

    private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
        return this.narrowType(expression2.getArgument().getType(), expression2.getTypeOperand(), expression2.getArgument());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument2, IrType toType) {
        void $this$fold$iv;
        Object object;
        Object object2;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
        Object object3 = irClassifierSymbol == null ? null : irClassifierSymbol.getOwner();
        Object object4 = object2 = object3 instanceof IrTypeParameter ? (IrTypeParameter)object3 : null;
        if (object2 == null) {
            object3 = Intrinsics.stringPlus((String)"expected type parameter, but got ", (Object)toType);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        IrTypeParameter typeParameter = object2;
        object2 = typeParameter.getSuperTypes();
        object3 = this.builder;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            object = null;
        } else {
            object = object3;
        }
        IrConstImpl<Boolean> initial$iv = ExpressionHelpersKt.irTrue((IrBuilderWithScope)object);
        boolean $i$f$fold = false;
        IrExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            DeclarationIrBuilder declarationIrBuilder;
            void t;
            IrType irType = (IrType)element$iv;
            IrExpression r = accumulator$iv;
            boolean bl = false;
            IrExpression check2 = this.generateTypeCheckNonNull(IrUtilsKt.shallowCopy(argument2), IrTypesKt.makeNotNull((IrType)t));
            Object object5 = this.builder;
            if (object5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder = null;
            } else {
                declarationIrBuilder = object5;
            }
            object5 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getBooleanAnd());
            boolean bl2 = false;
            boolean bl3 = false;
            Object $this$generateTypeCheckWithTypeParameter_u24lambda_u2d11_u24lambda_u2d10 = object5;
            boolean bl4 = false;
            ((IrFunctionAccessExpression)$this$generateTypeCheckWithTypeParameter_u24lambda_u2d11_u24lambda_u2d10).putValueArgument(0, r);
            ((IrFunctionAccessExpression)$this$generateTypeCheckWithTypeParameter_u24lambda_u2d11_u24lambda_u2d10).putValueArgument(1, check2);
            accumulator$iv = (IrExpression)object5;
        }
        return accumulator$iv;
    }

    private final IrExpression generateIsInterface(IrExpression argument2, IrType toType) {
        Object object;
        DeclarationIrBuilder declarationIrBuilder;
        Object object2 = this.builder;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        } else {
            declarationIrBuilder = object2;
        }
        object2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getWasmInterfaceId());
        boolean bl = false;
        boolean bl2 = false;
        Object $this$generateIsInterface_u24lambda_u2d12 = object2;
        boolean bl3 = false;
        ((IrMemberAccessExpression)$this$generateIsInterface_u24lambda_u2d12).putTypeArgument(0, toType);
        Object interfaceId = object2;
        object2 = this.builder;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            object = null;
        } else {
            object = object2;
        }
        object2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)object, this.symbols.isInterface());
        bl = false;
        bl2 = false;
        Object $this$generateIsInterface_u24lambda_u2d13 = object2;
        boolean bl4 = false;
        ((IrFunctionAccessExpression)$this$generateIsInterface_u24lambda_u2d13).putValueArgument(0, argument2);
        ((IrFunctionAccessExpression)$this$generateIsInterface_u24lambda_u2d13).putValueArgument(1, (IrExpression)interfaceId);
        return (IrExpression)object2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateIsSubClass(IrExpression argument2, IrType toType) {
        DeclarationIrBuilder declarationIrBuilder;
        IrType fromType = argument2.getType();
        IrType fromTypeErased = this.getErasedType(fromType);
        IrType toTypeErased = this.getErasedType(toType);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(toTypeErased);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        if (IrTypeUtilsKt.isSubtypeOfClass(fromTypeErased, irClassSymbol)) {
            DeclarationIrBuilder declarationIrBuilder2;
            void this_$iv$iv;
            DeclarationIrBuilder declarationIrBuilder3;
            DeclarationIrBuilder declarationIrBuilder4 = this.builder;
            if (declarationIrBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder3 = null;
            } else {
                declarationIrBuilder3 = declarationIrBuilder4;
            }
            IrBuilderWithScope $this$irComposite_u24default$iv = declarationIrBuilder3;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$generateIsSubClass_u24lambda_u2d14 = this_$iv$iv;
            boolean bl = false;
            $this$generateIsSubClass_u24lambda_u2d14.unaryPlus(argument2);
            DeclarationIrBuilder declarationIrBuilder5 = this.builder;
            if (declarationIrBuilder5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder2 = null;
            } else {
                declarationIrBuilder2 = declarationIrBuilder5;
            }
            $this$generateIsSubClass_u24lambda_u2d14.unaryPlus(ExpressionHelpersKt.irTrue(declarationIrBuilder2));
            return this_$iv$iv.doBuild();
        }
        IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(fromTypeErased);
        Intrinsics.checkNotNull((Object)irClassSymbol2);
        if (!IrTypeUtilsKt.isSubtypeOfClass(toTypeErased, irClassSymbol2)) {
            DeclarationIrBuilder declarationIrBuilder6;
            DeclarationIrBuilder declarationIrBuilder7;
            IrBuilderWithScope $this$irComposite_u24default$iv = this.builder;
            if ($this$irComposite_u24default$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder7 = null;
            } else {
                declarationIrBuilder7 = $this$irComposite_u24default$iv;
            }
            $this$irComposite_u24default$iv = declarationIrBuilder7;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            IrBlockBuilder $this$generateIsSubClass_u24lambda_u2d15 = this_$iv$iv;
            boolean bl = false;
            $this$generateIsSubClass_u24lambda_u2d15.unaryPlus(argument2);
            DeclarationIrBuilder declarationIrBuilder8 = this.builder;
            if (declarationIrBuilder8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
                declarationIrBuilder6 = null;
            } else {
                declarationIrBuilder6 = declarationIrBuilder8;
            }
            $this$generateIsSubClass_u24lambda_u2d15.unaryPlus(ExpressionHelpersKt.irFalse(declarationIrBuilder6));
            return this_$iv$iv.doBuild();
        }
        Object object = this.builder;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
            declarationIrBuilder = null;
        } else {
            declarationIrBuilder = object;
        }
        object = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getRefTest());
        boolean bl = false;
        boolean bl2 = false;
        Object $this$generateIsSubClass_u24lambda_u2d16 = object;
        boolean bl3 = false;
        ((IrFunctionAccessExpression)$this$generateIsSubClass_u24lambda_u2d16).putValueArgument(0, argument2);
        ((IrMemberAccessExpression)$this$generateIsSubClass_u24lambda_u2d16).putTypeArgument(0, toType);
        return (IrExpression)object;
    }

    public static final /* synthetic */ DeclarationIrBuilder access$getBuilder$p(WasmBaseTypeOperatorTransformer $this) {
        return $this.builder;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 1;
            nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 2;
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 4;
            nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 5;
            nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 6;
            nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 7;
            nArray[IrTypeOperator.CAST.ordinal()] = 8;
            nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 10;
            nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 11;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

