/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.AllProjectsLock;
import org.gradle.internal.resources.ProjectLock;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.util.Path;

public class ProjectLockRegistry
extends AbstractResourceLockRegistry<Path, ProjectLock> {
    private final boolean parallelEnabled;
    private final AllProjectsLock allProjectsLock;

    public ProjectLockRegistry(ResourceLockCoordinationService coordinationService, boolean parallelEnabled) {
        super(coordinationService);
        this.parallelEnabled = parallelEnabled;
        this.allProjectsLock = new AllProjectsLock("All projects", coordinationService, this);
    }

    @Override
    public boolean hasOpenLocks() {
        if (super.hasOpenLocks()) {
            return true;
        }
        return this.allProjectsLock.isLocked();
    }

    public boolean getAllowsParallelExecution() {
        return this.parallelEnabled;
    }

    public ResourceLock getAllProjectsLock() {
        return this.allProjectsLock;
    }

    public ProjectLock getResourceLock(Path buildIdentityPath, Path projectIdentityPath) {
        return this.getResourceLock(this.parallelEnabled ? projectIdentityPath : buildIdentityPath);
    }

    private ProjectLock getResourceLock(final Path lockPath) {
        return this.getOrRegisterResourceLock(lockPath, new AbstractResourceLockRegistry.ResourceLockProducer<Path, ProjectLock>(){

            @Override
            public ProjectLock create(Path projectPath, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                String displayName = ProjectLockRegistry.this.parallelEnabled ? "state of project " + lockPath : "state of build " + lockPath;
                return new ProjectLock(displayName, coordinationService, owner, ProjectLockRegistry.this.allProjectsLock);
            }
        });
    }
}

