/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.diagnostics.internal.ReportGenerator;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.serialization.Transient;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class ConventionReportTask
extends ConventionTask {
    private final Transient.Var<Set<Project>> projects = Transient.varOf(new HashSet<Project>(Collections.singleton(this.getProject())));
    private final DirectoryProperty reportDir = this.getProject().getObjects().directoryProperty();
    private File outputFile;

    @Internal
    public DirectoryProperty getProjectReportDirectory() {
        return this.reportDir;
    }

    protected ConventionReportTask() {
        this.doNotTrackState("Uses the whole project state as an input");
    }

    @Internal
    protected abstract ReportRenderer getRenderer();

    @Nullable
    @Optional
    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(@Nullable File outputFile) {
        this.outputFile = outputFile;
    }

    @Internal
    public Set<Project> getProjects() {
        return Objects.requireNonNull((Set)this.projects.get());
    }

    public void setProjects(Set<Project> projects) {
        this.projects.set(projects);
    }

    ReportGenerator reportGenerator() {
        return new ReportGenerator(this.getRenderer(), this.getClientMetaData(), this.getOutputFile(), this.getTextOutputFactory());
    }

    void logClickableOutputFileUrl() {
        if (this.shouldCreateReportFile()) {
            this.getLogger().lifecycle("See the report at: {}", new Object[]{this.clickableOutputFileUrl()});
        }
    }

    String clickableOutputFileUrl() {
        return new ConsoleRenderer().asClickableFileUrl(this.getOutputFile());
    }

    boolean shouldCreateReportFile() {
        return this.getOutputFile() != null;
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }
}

