/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.execution.internal.TaskInputsListeners;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.taskfactory.IncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskInputsTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskValidationContext;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationResult;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.ExecuteTaskActionBuildOperationType;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.Sync;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.work.AsyncWorkTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecution
implements UnitOfWork {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecution.class);
    private static final SnapshotTaskInputsBuildOperationType.Details SNAPSHOT_TASK_INPUTS_DETAILS = new SnapshotTaskInputsBuildOperationType.Details(){};
    private final TaskInternal task;
    private final TaskExecutionContext context;
    private final boolean emitLegacySnapshottingOperations;
    private final TaskActionListener actionListener;
    private final AsyncWorkTracker asyncWorkTracker;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ExecutionHistoryStore executionHistoryStore;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileOperations fileOperations;
    private final InputFingerprinter inputFingerprinter;
    private final ListenerManager listenerManager;
    private final ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final TaskInputsListeners taskInputsListeners;

    public TaskExecution(TaskInternal task, TaskExecutionContext context, boolean emitLegacySnapshottingOperations, TaskActionListener actionListener, AsyncWorkTracker asyncWorkTracker, BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ExecutionHistoryStore executionHistoryStore, FileCollectionFactory fileCollectionFactory, FileOperations fileOperations, InputFingerprinter inputFingerprinter, ListenerManager listenerManager, ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry, TaskCacheabilityResolver taskCacheabilityResolver, TaskInputsListeners taskInputsListeners) {
        this.task = task;
        this.context = context;
        this.emitLegacySnapshottingOperations = emitLegacySnapshottingOperations;
        this.actionListener = actionListener;
        this.asyncWorkTracker = asyncWorkTracker;
        this.buildOperationExecutor = buildOperationExecutor;
        this.executionHistoryStore = executionHistoryStore;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileOperations = fileOperations;
        this.inputFingerprinter = inputFingerprinter;
        this.listenerManager = listenerManager;
        this.reservedFileSystemLocationRegistry = reservedFileSystemLocationRegistry;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.taskInputsListeners = taskInputsListeners;
    }

    public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        return () -> ((TaskInternal)this.task).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
        FileCollection previousFiles = executionRequest.getPreviouslyProducedOutputs().map(previousOutputs -> new PreviousOutputFileCollection(this.task, this.fileCollectionFactory, (ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputs)).orElseGet(() -> ((FileCollectionFactory)this.fileCollectionFactory).empty());
        TaskOutputsInternal outputs = this.task.getOutputs();
        outputs.setPreviousOutputFiles(previousFiles);
        try {
            final UnitOfWork.WorkResult didWork = this.executeWithPreviousOutputFiles(executionRequest.getInputChanges().orElse(null));
            UnitOfWork.WorkOutput workOutput = new UnitOfWork.WorkOutput(){

                public UnitOfWork.WorkResult getDidWork() {
                    return didWork;
                }

                public Object getOutput() {
                    throw new UnsupportedOperationException();
                }
            };
            return workOutput;
        }
        finally {
            outputs.setPreviousOutputFiles(null);
        }
    }

    private UnitOfWork.WorkResult executeWithPreviousOutputFiles(@Nullable InputChangesInternal inputChanges) {
        this.task.getState().setExecuting(true);
        try {
            LOGGER.debug("Executing actions for {}.", (Object)this.task);
            this.actionListener.beforeActions((Task)this.task);
            this.executeActions(this.task, inputChanges);
            UnitOfWork.WorkResult workResult = this.task.getState().getDidWork() ? UnitOfWork.WorkResult.DID_WORK : UnitOfWork.WorkResult.DID_NO_WORK;
            return workResult;
        }
        finally {
            this.task.getState().setExecuting(false);
            this.actionListener.afterActions((Task)this.task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions(TaskInternal task, @Nullable InputChangesInternal inputChanges) {
        boolean hasTaskListener = this.listenerManager.hasListeners(TaskActionListener.class) || this.listenerManager.hasListeners(TaskExecutionListener.class);
        Iterator<InputChangesAwareTaskAction> actions = new ArrayList<InputChangesAwareTaskAction>(task.getTaskActions()).iterator();
        while (actions.hasNext()) {
            InputChangesAwareTaskAction action = actions.next();
            task.getState().setDidWork(true);
            task.getStandardOutputCapture().start();
            boolean hasMoreWork = hasTaskListener || actions.hasNext();
            try {
                this.executeAction(action.getDisplayName(), task, action, inputChanges, hasMoreWork);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final InputChangesAwareTaskAction action, @Nullable InputChangesInternal inputChanges, final boolean hasMoreWork) {
        if (inputChanges != null) {
            action.setInputChanges(inputChanges);
        }
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)(actionDisplayName + " for " + task.getIdentityPath().getPath())).name(actionDisplayName).details((Object)ExecuteTaskActionBuildOperationType.DETAILS_INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(BuildOperationContext context) {
                try {
                    BuildOperationRef currentOperation = TaskExecution.this.buildOperationExecutor.getCurrentOperation();
                    Throwable actionFailure = null;
                    try {
                        action.execute(task);
                    }
                    catch (Throwable t) {
                        actionFailure = t;
                    }
                    finally {
                        action.clearInputChanges();
                    }
                    try {
                        TaskExecution.this.asyncWorkTracker.waitForCompletion(currentOperation, hasMoreWork ? AsyncWorkTracker.ProjectLockRetention.RELEASE_AND_REACQUIRE_PROJECT_LOCKS : AsyncWorkTracker.ProjectLockRetention.RELEASE_PROJECT_LOCKS);
                    }
                    catch (Throwable t) {
                        ArrayList failures = Lists.newArrayList();
                        if (actionFailure != null) {
                            failures.add(actionFailure);
                        }
                        if (t instanceof MultiCauseException) {
                            failures.addAll(((MultiCauseException)t).getCauses());
                        } else {
                            failures.add(t);
                        }
                        if (failures.size() > 1) {
                            throw new MultipleTaskActionFailures("Multiple task action failures occurred:", failures);
                        }
                        throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)failures.get(0)));
                    }
                    if (actionFailure != null) {
                        context.failed(actionFailure);
                        throw UncheckedException.throwAsUncheckedException((Throwable)actionFailure);
                    }
                }
                finally {
                    context.setResult((Object)ExecuteTaskActionBuildOperationType.RESULT_INSTANCE);
                }
            }
        });
    }

    public WorkspaceProvider getWorkspaceProvider() {
        return new WorkspaceProvider(){

            public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
                return (T)action.executeInWorkspace(null, TaskExecution.this.context.getTaskExecutionMode().isTaskHistoryMaintained() ? TaskExecution.this.executionHistoryStore : null);
            }
        };
    }

    public InputFingerprinter getInputFingerprinter() {
        return this.inputFingerprinter;
    }

    public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
        visitor.visitImplementation(this.task.getClass());
        List<InputChangesAwareTaskAction> taskActions = this.task.getTaskActions();
        for (InputChangesAwareTaskAction taskAction : taskActions) {
            visitor.visitImplementation(taskAction.getActionImplementation(this.classLoaderHierarchyHasher));
        }
    }

    public void visitRegularInputs(InputFingerprinter.InputVisitor visitor) {
        TaskProperties taskProperties = this.context.getTaskProperties();
        ImmutableSortedSet<InputPropertySpec> inputProperties = taskProperties.getInputProperties();
        ImmutableSortedSet<InputFilePropertySpec> inputFileProperties = taskProperties.getInputFileProperties();
        for (InputPropertySpec inputProperty : inputProperties) {
            visitor.visitInputProperty(inputProperty.getPropertyName(), () -> InputParameterUtils.prepareInputParameterValue(inputProperty, this.task));
        }
        for (InputFilePropertySpec inputFileProperty : inputFileProperties) {
            Object value = inputFileProperty.getValue();
            InputFingerprinter.InputPropertyType type = inputFileProperty.isSkipWhenEmpty() ? InputFingerprinter.InputPropertyType.PRIMARY : (inputFileProperty.isIncremental() ? InputFingerprinter.InputPropertyType.INCREMENTAL : InputFingerprinter.InputPropertyType.NON_INCREMENTAL);
            String propertyName = inputFileProperty.getPropertyName();
            visitor.visitInputFileProperty(propertyName, type, new InputFingerprinter.FileValueSupplier(value, inputFileProperty.getNormalizer(), inputFileProperty.getDirectorySensitivity(), inputFileProperty.getLineEndingNormalization(), inputFileProperty::getPropertyFiles));
        }
    }

    public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
        TaskProperties taskProperties = this.context.getTaskProperties();
        for (OutputFilePropertySpec property : taskProperties.getOutputFileProperties()) {
            File outputFile = property.getOutputFile();
            if (outputFile == null) continue;
            visitor.visitOutputProperty(property.getPropertyName(), property.getOutputType(), outputFile, (FileCollection)property.getPropertyFiles());
        }
        for (File localStateRoot : taskProperties.getLocalStateFiles()) {
            visitor.visitLocalState(localStateRoot);
        }
        for (File destroyableRoot : taskProperties.getDestroyableFiles()) {
            visitor.visitDestroyable(destroyableRoot);
        }
    }

    public void handleUnreadableInputs(InputFingerprinter.InputFileFingerprintingException ex) {
        this.nagUserAboutUnreadableInputsOrOutputs("input", ex.getPropertyName(), ex.getCause());
    }

    public void handleUnreadableOutputs(OutputSnapshotter.OutputFileSnapshottingException ex) {
        this.nagUserAboutUnreadableInputsOrOutputs("output", ex.getPropertyName(), ex.getCause());
    }

    private void nagUserAboutUnreadableInputsOrOutputs(String propertyType, String propertyName, Throwable cause) {
        if (!(cause instanceof java.io.UncheckedIOException) && !(cause instanceof UncheckedIOException)) {
            throw UncheckedException.throwAsUncheckedException((Throwable)cause);
        }
        LOGGER.info("Cannot access {} property '{}' of {}", new Object[]{propertyType, propertyName, this.getDisplayName(), cause});
        boolean isDestinationDir = propertyName.equals("destinationDir");
        DeprecationMessageBuilder builder = isDestinationDir && this.task instanceof Copy ? DeprecationLogger.deprecateAction((String)"Cannot access a file in the destination directory (see --info log for details). Copying to a directory which contains unreadable content").withAdvice("Declare the task as untracked by using Task.doNotTrackState().") : (isDestinationDir && this.task instanceof Sync ? DeprecationLogger.deprecateAction((String)"Cannot access a file in the destination directory (see --info log for details). Syncing to a directory which contains unreadable content").withAdvice("Use a Copy task with Task.doNotTrackState() instead.") : DeprecationLogger.deprecateAction((String)String.format("Cannot access %s property '%s' of %s (see --info log for details). Accessing unreadable inputs or outputs", propertyType, propertyName, this.getDisplayName())).withAdvice("Declare the task as untracked by using Task.doNotTrackState()."));
        builder.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "declare_unreadable_input_output").nagUser();
    }

    public UnitOfWork.OverlappingOutputHandling getOverlappingOutputHandling() {
        return UnitOfWork.OverlappingOutputHandling.DETECT_OVERLAPS;
    }

    public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
        return this.getInputChangeTrackingStrategy() == UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
    }

    public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        if (this.task.isHasCustomActions()) {
            LOGGER.info("Custom actions are attached to {}.", (Object)this.task);
        }
        return this.taskCacheabilityResolver.shouldDisableCaching(this.task, this.context.getTaskProperties(), this.task.getOutputs().getCacheIfSpecs(), this.task.getOutputs().getDoNotCacheIfSpecs(), detectedOverlappingOutputs);
    }

    public boolean isAllowedToLoadFromCache() {
        return this.context.getTaskExecutionMode().isAllowedToUseCachedResults();
    }

    public Optional<Duration> getTimeout() {
        return Optional.ofNullable((Duration)this.task.getTimeout().getOrNull());
    }

    public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
        for (InputChangesAwareTaskAction taskAction : this.task.getTaskActions()) {
            if (taskAction instanceof IncrementalInputsTaskAction) {
                return UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
            }
            if (!(taskAction instanceof IncrementalTaskInputsTaskAction)) continue;
            return UnitOfWork.InputChangeTrackingStrategy.ALL_PARAMETERS;
        }
        return UnitOfWork.InputChangeTrackingStrategy.NONE;
    }

    public void markLegacySnapshottingInputsStarted() {
        if (this.emitLegacySnapshottingOperations) {
            BuildOperationContext operationContext = this.buildOperationExecutor.start(BuildOperationDescriptor.displayName((String)("Snapshot task inputs for " + this.task.getIdentityPath())).name("Snapshot task inputs").details((Object)SNAPSHOT_TASK_INPUTS_DETAILS));
            this.context.setSnapshotTaskInputsBuildOperationContext(operationContext);
        }
    }

    public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
        this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult((Object)new SnapshotTaskInputsBuildOperationResult(cachingState, (Set<InputFilePropertySpec>)this.context.getTaskProperties().getInputFileProperties())));
    }

    public void ensureLegacySnapshottingInputsClosed() {
        this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult((Object)new SnapshotTaskInputsBuildOperationResult(CachingState.NOT_DETERMINED, Collections.emptySet())));
    }

    public void validate(WorkValidationContext validationContext) {
        Class taskType = GeneratedSubclasses.unpackType((Object)this.task);
        boolean cacheable = taskType.isAnnotationPresent(CacheableTask.class);
        TypeValidationContext typeValidationContext = validationContext.forType(taskType, cacheable);
        this.context.getTaskProperties().validateType(typeValidationContext);
        this.context.getTaskProperties().validate(new DefaultTaskValidationContext(this.fileOperations, this.reservedFileSystemLocationRegistry, typeValidationContext));
        this.context.getValidationAction().validate(this.context.getTaskExecutionMode().isTaskHistoryMaintained(), typeValidationContext);
    }

    public void broadcastRelevantFileSystemInputs(final boolean hasEmptySources) {
        this.taskInputsListeners.broadcastFileSystemInputsOf(this.task, (FileCollectionInternal)new CompositeFileCollection(){

            public String getDisplayName() {
                return TaskExecution.this.getDisplayName() + " relevant file inputs";
            }

            protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
                for (InputFilePropertySpec filePropertySpec : TaskExecution.this.context.getTaskProperties().getInputFileProperties()) {
                    if (hasEmptySources && !filePropertySpec.isSkipWhenEmpty()) continue;
                    visitor.accept(filePropertySpec.getPropertyFiles());
                }
            }
        });
    }

    public String getDisplayName() {
        return this.task.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message, Iterable<? extends Throwable> causes) {
            super(message, causes);
        }
    }

    private static class PreviousOutputFileCollection
    extends LazilyInitializedFileCollection {
        private final TaskInternal task;
        private final FileCollectionFactory fileCollectionFactory;
        private final ImmutableSortedMap<String, FileSystemSnapshot> previousOutputs;

        public PreviousOutputFileCollection(TaskInternal task, FileCollectionFactory fileCollectionFactory, ImmutableSortedMap<String, FileSystemSnapshot> previousOutputs) {
            this.task = task;
            this.fileCollectionFactory = fileCollectionFactory;
            this.previousOutputs = previousOutputs;
        }

        public FileCollectionInternal createDelegate() {
            List outputs = this.previousOutputs.values().stream().map(SnapshotUtil::index).map(Map::keySet).flatMap(Collection::stream).map(File::new).collect(Collectors.toList());
            return this.fileCollectionFactory.fixed(outputs);
        }

        public String getDisplayName() {
            return "previous output files of " + this.task;
        }
    }
}

