/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.gradle.internal.Pair;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.AbstractTrackedResourceLock;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;

public class SharedResourceLeaseRegistry
extends AbstractResourceLockRegistry<String, SharedResourceLease> {
    private final Map<String, Pair<Integer, Semaphore>> sharedResources = Maps.newConcurrentMap();

    public SharedResourceLeaseRegistry(ResourceLockCoordinationService coordinationService) {
        super(coordinationService);
    }

    public void registerSharedResource(String name, int leases) {
        this.sharedResources.put(name, Pair.of(leases, new Semaphore(leases)));
    }

    public ResourceLock getResourceLock(final String sharedResource, final int leases) {
        String displayName = "lease of " + leases + " for " + sharedResource;
        return this.createResourceLock(displayName, new AbstractResourceLockRegistry.ResourceLockProducer<String, SharedResourceLease>(){

            @Override
            public SharedResourceLease create(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
                return new SharedResourceLease(displayName, coordinationService, owner, sharedResource, leases);
            }
        });
    }

    public class SharedResourceLease
    extends AbstractTrackedResourceLock {
        private final int leases;
        private final Pair<Integer, Semaphore> semaphore;
        private Thread ownerThread;
        private boolean active;

        SharedResourceLease(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner, String sharedResource, int leases) {
            super(displayName, coordinationService, owner);
            this.active = false;
            this.leases = leases;
            this.semaphore = (Pair)SharedResourceLeaseRegistry.this.sharedResources.get(sharedResource);
        }

        @Override
        protected boolean acquireLock() {
            if (this.leases > this.semaphore.getLeft()) {
                throw new IllegalArgumentException("Cannot acquire lock on " + this.getDisplayName() + " as max available leases is " + this.semaphore.getLeft());
            }
            if (this.semaphore.getRight().tryAcquire(this.leases)) {
                this.active = true;
                this.ownerThread = Thread.currentThread();
            }
            return this.doIsLockedByCurrentThread();
        }

        @Override
        protected void releaseLock() {
            if (Thread.currentThread() != this.ownerThread) {
                throw new UnsupportedOperationException("Lock cannot be released from non-owner thread.");
            }
            this.semaphore.getRight().release(this.leases);
            this.active = false;
            this.ownerThread = null;
        }

        @Override
        protected boolean doIsLocked() {
            return this.active;
        }

        @Override
        protected boolean doIsLockedByCurrentThread() {
            return this.active && this.ownerThread == Thread.currentThread();
        }
    }
}

