/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsFileEventFunctions
extends AbstractFileEventFunctions<WindowsFileWatcher> {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int DEFAULT_COMMAND_TIMEOUT_IN_SECONDS = 5;

    public WatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> eventQueue) {
        return new WatcherBuilder(eventQueue);
    }

    private static native Object startWatcher0(int var0, long var1, AbstractFileEventFunctions.NativeFileWatcherCallback var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WatcherBuilder
    extends AbstractFileEventFunctions.AbstractWatcherBuilder<WindowsFileWatcher> {
        private int bufferSize = 65536;
        private long commandTimeoutInMillis = TimeUnit.SECONDS.toMillis(5L);

        private WatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            super(eventQueue);
        }

        public WatcherBuilder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public WatcherBuilder withCommandTimeout(int timeoutValue, TimeUnit timeoutUnit) {
            this.commandTimeoutInMillis = timeoutUnit.toMillis(timeoutValue);
            return this;
        }

        @Override
        protected Object startWatcher(AbstractFileEventFunctions.NativeFileWatcherCallback callback) {
            return WindowsFileEventFunctions.startWatcher0(this.bufferSize, this.commandTimeoutInMillis, callback);
        }

        @Override
        protected WindowsFileWatcher createWatcher(Object server, long startTimeout, TimeUnit startTimeoutUnit, AbstractFileEventFunctions.NativeFileWatcherCallback callback) throws InterruptedException {
            return new WindowsFileWatcher(server, startTimeout, startTimeoutUnit, callback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WindowsFileWatcher
    extends AbstractFileEventFunctions.NativeFileWatcher {
        public WindowsFileWatcher(Object server, long startTimeout, TimeUnit startTimeoutUnit, AbstractFileEventFunctions.NativeFileWatcherCallback callback) throws InterruptedException {
            super(server, startTimeout, startTimeoutUnit, callback);
        }

        public List<File> stopWatchingMovedPaths() {
            ArrayList<String> droppedPathStrings = new ArrayList<String>();
            this.stopWatchingMovedPaths0(this.server, droppedPathStrings);
            ArrayList<File> droppedPaths = new ArrayList<File>(droppedPathStrings.size());
            for (String droppedPath : droppedPathStrings) {
                droppedPaths.add(new File(droppedPath));
            }
            return droppedPaths;
        }

        private native void stopWatchingMovedPaths0(Object var1, List<String> var2);
    }
}

