/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.WindowsFileEventFunctions;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.HierarchicalFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<WindowsFileEventFunctions, WindowsFileEventFunctions.WindowsFileWatcher> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsFileWatcherRegistryFactory.class);
    private static final int BUFFER_SIZE = 65536;

    public WindowsFileWatcherRegistryFactory(WatchableFileSystemDetector watchableFileSystemDetector, Predicate<String> watchFilter) throws NativeIntegrationUnavailableException {
        super((WindowsFileEventFunctions)FileEvents.get(WindowsFileEventFunctions.class), watchableFileSystemDetector, watchFilter);
    }

    @Override
    protected WindowsFileEventFunctions.WindowsFileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return (WindowsFileEventFunctions.WindowsFileWatcher)((WindowsFileEventFunctions)this.fileEventFunctions).newWatcher(fileEvents).withBufferSize(65536).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(WindowsFileEventFunctions.WindowsFileWatcher watcher, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies) {
        return new HierarchicalFileWatcherUpdater((FileWatcher)watcher, HierarchicalFileWatcherUpdater.FileSystemLocationToWatchValidator.NO_VALIDATION, probeRegistry, watchableHierarchies, root -> WindowsFileWatcherRegistryFactory.invalidateMovedPaths(watcher, root));
    }

    private static SnapshotHierarchy invalidateMovedPaths(WindowsFileEventFunctions.WindowsFileWatcher watcher, SnapshotHierarchy root) {
        for (File movedPath : watcher.stopWatchingMovedPaths()) {
            LOGGER.info("Dropping VFS state for moved path {}", (Object)movedPath.getAbsolutePath());
            root = root.invalidate(movedPath.getAbsolutePath(), SnapshotHierarchy.NodeDiffListener.NOOP);
        }
        return root;
    }
}

