/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;

class AbstractArraySnapshot<T extends Hashable>
implements Hashable {
    protected final ImmutableList<T> elements;

    public AbstractArraySnapshot(ImmutableList<T> elements) {
        this.elements = elements;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)"Array");
        hasher.putInt(this.elements.size());
        for (Hashable element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractArraySnapshot other = (AbstractArraySnapshot)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

