/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.reflect.validation.DefaultPropertyValidationProblemBuilder;
import org.gradle.internal.reflect.validation.DefaultTypeValidationProblemBuilder;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.TypeProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.plugin.use.PluginId;

public abstract class ProblemRecordingTypeValidationContext
implements TypeValidationContext {
    private final DocumentationRegistry documentationRegistry;
    private final Class<?> rootType;
    private final PluginId pluginId;

    public ProblemRecordingTypeValidationContext(DocumentationRegistry documentationRegistry, @Nullable Class<?> rootType, @Nullable PluginId pluginId) {
        this.documentationRegistry = documentationRegistry;
        this.rootType = rootType;
        this.pluginId = pluginId;
    }

    @Override
    public void visitTypeProblem(Action<? super TypeProblemBuilder> problemSpec) {
        DefaultTypeValidationProblemBuilder builder = new DefaultTypeValidationProblemBuilder(this.documentationRegistry, this.pluginId);
        problemSpec.execute((Object)builder);
        this.recordProblem(builder.build());
    }

    @Override
    public void visitPropertyProblem(Action<? super PropertyProblemBuilder> problemSpec) {
        DefaultPropertyValidationProblemBuilder builder = new DefaultPropertyValidationProblemBuilder(this.documentationRegistry, this.pluginId);
        problemSpec.execute((Object)builder);
        builder.forType(this.rootType);
        this.recordProblem(builder.build());
    }

    protected abstract void recordProblem(TypeValidationProblem var1);
}

