/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.extensibility.ConventionAwareHelper;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.AbstractClassGenerator;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ManagedObjectFactory;
import org.gradle.internal.instantiation.generator.MixInExtensibleDynamicObject;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ModelObject;
import org.gradle.internal.state.OwnerAware;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.asm.ClassGeneratorSuffixRegistry;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import sun.reflect.ReflectionFactory;

public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    private static final ThreadLocal<ObjectCreationDetails> SERVICES_FOR_NEXT_OBJECT = new ThreadLocal();
    private static final AtomicReference<CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl>> GENERATED_CLASSES_CACHES = new AtomicReference();
    private final boolean decorate;
    private final String suffix;
    private final int factoryId;
    private static final String GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME = "getDisplayNameForNext";
    private static final String GET_SERVICES_FOR_NEXT_METHOD_NAME = "getServicesForNext";
    private static final String GET_FACTORY_FOR_NEXT_METHOD_NAME = "getFactoryForNext";

    @Nullable
    public static Describable getDisplayNameForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        if (details == null) {
            return null;
        }
        return details.displayName;
    }

    public static ServiceLookup getServicesForNext() {
        return AsmBackedClassGenerator.SERVICES_FOR_NEXT_OBJECT.get().services;
    }

    public static ManagedObjectFactory getFactoryForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        return new ManagedObjectFactory(details.services, details.instantiator, details.roleHandler);
    }

    private AsmBackedClassGenerator(boolean decorate, String suffix, Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledInjectAnnotations, PropertyRoleAnnotationHandler roleHandler, CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses, int factoryId) {
        super(allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses);
        this.decorate = decorate;
        this.suffix = suffix;
        this.factoryId = factoryId;
    }

    static ClassGenerator decorateAndInject(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses;
        String suffix;
        if (enabledInjectAnnotations.isEmpty()) {
            suffix = "_Decorated";
            if (GENERATED_CLASSES_CACHES.get() == null && GENERATED_CLASSES_CACHES.compareAndSet(null, cacheFactory.newClassMap())) {
                ClassGeneratorSuffixRegistry.register(suffix);
            }
            generatedClasses = GENERATED_CLASSES_CACHES.get();
        } else {
            suffix = ClassGeneratorSuffixRegistry.assign("$Decorated");
            generatedClasses = cacheFactory.newClassMap();
        }
        return new AsmBackedClassGenerator(true, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses, factoryId);
    }

    static ClassGenerator injectOnly(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        String suffix = ClassGeneratorSuffixRegistry.assign("$Inject");
        return new AsmBackedClassGenerator(false, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, cacheFactory.newClassMap(), factoryId);
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createUsingConstructor(Constructor<?> constructor) {
        return new InvokeConstructorStrategy(constructor, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createForSerialization(Class<?> generatedType, Class<?> baseClass) {
        Constructor<?> constructor;
        try {
            constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(generatedType, baseClass.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        Method method = (Method)CollectionUtils.findFirst((Object[])generatedType.getDeclaredMethods(), m -> m.getName().equals("$gradleInit"));
        method.setAccessible(true);
        return new InvokeSerializationConstructorAndInitializeFieldsStrategy(constructor, method, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.ClassInspectionVisitor start(Class<?> type) {
        if (type.isAnnotation() || type.isEnum()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append((CharSequence)" is not a class or interface.");
            throw new ClassGenerationException(formatter.toString());
        }
        return new ClassInspectionVisitorImpl(type, this.decorate, this.suffix, this.factoryId);
    }

    private static String propFieldName(AbstractClassGenerator.PropertyMetadata property) {
        return AsmBackedClassGenerator.propFieldName(property.getName());
    }

    public static String propFieldName(String name) {
        return "__" + name + "__";
    }

    private static Class<?> rawTypeParam(AbstractClassGenerator.PropertyMetadata property, int paramNum) {
        Type type = property.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Declaration of property " + property.getName() + " does not include any type arguments in its property type " + type);
        }
        Type argument = ((ParameterizedType)type).getActualTypeArguments()[paramNum];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        return (Class)((ParameterizedType)argument).getRawType();
    }

    private static class InvokeSerializationConstructorAndInitializeFieldsStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final PropertyRoleAnnotationHandler roleHandler;
        private final Constructor<?> constructor;
        private final Method initMethod;

        public InvokeSerializationConstructorAndInitializeFieldsStrategy(Constructor<?> constructor, Method initMethod, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.initMethod = initMethod;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object instance = this.constructor.newInstance(new Object[0]);
                this.initMethod.invoke(instance, new Object[0]);
                Object obj = instance;
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class InvokeConstructorStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final Constructor<?> constructor;
        private final PropertyRoleAnnotationHandler roleHandler;

        public InvokeConstructorStrategy(Constructor<?> constructor, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object obj = this.constructor.newInstance(params);
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class NoOpBuilder
    implements AbstractClassGenerator.ClassGenerationVisitor {
        private final Class<?> type;

        public NoOpBuilder(Class<?> type) {
            this.type = type;
        }

        @Override
        public void addConstructor(Constructor<?> constructor, boolean addNameParameter) {
        }

        @Override
        public void addDefaultConstructor() {
        }

        @Override
        public void addNameConstructor() {
        }

        @Override
        public void mixInDynamicAware() {
        }

        @Override
        public void mixInConventionAware() {
        }

        @Override
        public void mixInGroovyObject() {
        }

        @Override
        public void addDynamicMethods() {
        }

        @Override
        public void addExtensionsProperty() {
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter, boolean applyRole) {
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void addManagedMethods(Iterable<AbstractClassGenerator.PropertyMetadata> mutableProperties, Iterable<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter, boolean attachOwner, boolean applyRole) {
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method metaMethod) {
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata propertyMetaData, Method setter) {
        }

        @Override
        public void addActionMethod(Method method) {
        }

        @Override
        public void addPropertySetterOverloads(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void addNameProperty() {
        }

        @Override
        public Class<?> generate() {
            return this.type;
        }
    }

    private static class ObjectCreationDetails {
        final InstanceGenerator instantiator;
        final ServiceLookup services;
        @Nullable
        final Describable displayName;
        PropertyRoleAnnotationHandler roleHandler;

        ObjectCreationDetails(InstanceGenerator instantiator, ServiceLookup services, @Nullable Describable displayName, PropertyRoleAnnotationHandler roleHandler) {
            this.instantiator = instantiator;
            this.services = services;
            this.displayName = displayName;
            this.roleHandler = roleHandler;
        }
    }

    private static interface MethodCodeBody {
        public void add(MethodVisitor var1);
    }

    private static class ClassBuilderImpl
    implements AbstractClassGenerator.ClassGenerationVisitor {
        public static final int PV_FINAL_STATIC = 4122;
        private static final Set<? extends Class<?>> PRIMITIVE_TYPES = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, (Object[])new Class[]{Float.TYPE, Double.TYPE});
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "_gr_dyn_";
        private static final String MAPPING_FIELD = "_gr_map_";
        private static final String META_CLASS_FIELD = "_gr_mc_";
        private static final String SERVICES_FIELD = "_gr_svcs_";
        private static final String NAME_FIELD = "_gr_n_";
        private static final String DISPLAY_NAME_FIELD = "_gr_dn_";
        private static final String OWNER_FIELD = "_gr_owner_";
        private static final String FACTORY_ID_FIELD = "_gr_fid_";
        private static final String FACTORY_FIELD = "_gr_f_";
        private static final String SERVICES_METHOD = "$gradleServices";
        private static final String FACTORY_METHOD = "$gradleFactory";
        private static final String INIT_METHOD = "$gradleInit";
        private static final String CONVENTION_MAPPING_FIELD_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(ConventionMapping.class);
        private static final String META_CLASS_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(MetaClass.class);
        private static final org.objectweb.asm.Type META_CLASS_TYPE = org.objectweb.asm.Type.getType(MetaClass.class);
        private static final org.objectweb.asm.Type GENERATED_SUBCLASS_TYPE = org.objectweb.asm.Type.getType(GeneratedSubclass.class);
        private static final org.objectweb.asm.Type MODEL_OBJECT_TYPE = org.objectweb.asm.Type.getType(ModelObject.class);
        private static final org.objectweb.asm.Type OWNER_AWARE_TYPE = org.objectweb.asm.Type.getType(OwnerAware.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_TYPE = org.objectweb.asm.Type.getType(IConventionAware.class);
        private static final org.objectweb.asm.Type CONVENTION_AWARE_HELPER_TYPE = org.objectweb.asm.Type.getType(ConventionAwareHelper.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_AWARE_TYPE = org.objectweb.asm.Type.getType(DynamicObjectAware.class);
        private static final org.objectweb.asm.Type EXTENSION_AWARE_TYPE = org.objectweb.asm.Type.getType(ExtensionAware.class);
        private static final org.objectweb.asm.Type HAS_CONVENTION_TYPE = org.objectweb.asm.Type.getType(HasConvention.class);
        private static final org.objectweb.asm.Type DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(DynamicObject.class);
        private static final org.objectweb.asm.Type CONVENTION_MAPPING_TYPE = org.objectweb.asm.Type.getType(ConventionMapping.class);
        private static final org.objectweb.asm.Type GROOVY_OBJECT_TYPE = org.objectweb.asm.Type.getType(GroovyObject.class);
        private static final org.objectweb.asm.Type CONVENTION_TYPE = org.objectweb.asm.Type.getType(Convention.class);
        private static final org.objectweb.asm.Type ASM_BACKED_CLASS_GENERATOR_TYPE = org.objectweb.asm.Type.getType(AsmBackedClassGenerator.class);
        private static final org.objectweb.asm.Type ABSTRACT_DYNAMIC_OBJECT_TYPE = org.objectweb.asm.Type.getType(AbstractDynamicObject.class);
        private static final org.objectweb.asm.Type EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(MixInExtensibleDynamicObject.class);
        private static final org.objectweb.asm.Type NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = org.objectweb.asm.Type.getType(BeanDynamicObject.class);
        private static final String JAVA_REFLECT_TYPE_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Type.class);
        private static final org.objectweb.asm.Type CONFIGURE_UTIL_TYPE = org.objectweb.asm.Type.getType(ConfigureUtil.class);
        private static final org.objectweb.asm.Type CLOSURE_TYPE = org.objectweb.asm.Type.getType(Closure.class);
        private static final org.objectweb.asm.Type SERVICE_REGISTRY_TYPE = org.objectweb.asm.Type.getType(ServiceRegistry.class);
        private static final org.objectweb.asm.Type SERVICE_LOOKUP_TYPE = org.objectweb.asm.Type.getType(ServiceLookup.class);
        private static final org.objectweb.asm.Type MANAGED_OBJECT_FACTORY_TYPE = org.objectweb.asm.Type.getType(ManagedObjectFactory.class);
        private static final org.objectweb.asm.Type JAVA_LANG_REFLECT_TYPE = org.objectweb.asm.Type.getType(Type.class);
        private static final org.objectweb.asm.Type OBJECT_TYPE = org.objectweb.asm.Type.getType(Object.class);
        private static final org.objectweb.asm.Type CLASS_TYPE = org.objectweb.asm.Type.getType(Class.class);
        private static final org.objectweb.asm.Type METHOD_TYPE = org.objectweb.asm.Type.getType(Method.class);
        private static final org.objectweb.asm.Type STRING_TYPE = org.objectweb.asm.Type.getType(String.class);
        private static final org.objectweb.asm.Type CLASS_ARRAY_TYPE = org.objectweb.asm.Type.getType(Class[].class);
        private static final org.objectweb.asm.Type GROOVY_SYSTEM_TYPE = org.objectweb.asm.Type.getType(GroovySystem.class);
        private static final org.objectweb.asm.Type META_CLASS_REGISTRY_TYPE = org.objectweb.asm.Type.getType(MetaClassRegistry.class);
        private static final org.objectweb.asm.Type BOOLEAN_TYPE = org.objectweb.asm.Type.getType(Boolean.TYPE);
        private static final org.objectweb.asm.Type OBJECT_ARRAY_TYPE = org.objectweb.asm.Type.getType(Object[].class);
        private static final org.objectweb.asm.Type ACTION_TYPE = org.objectweb.asm.Type.getType(Action.class);
        private static final org.objectweb.asm.Type PROPERTY_INTERNAL_TYPE = org.objectweb.asm.Type.getType(PropertyInternal.class);
        private static final org.objectweb.asm.Type MANAGED_TYPE = org.objectweb.asm.Type.getType(Managed.class);
        private static final org.objectweb.asm.Type EXTENSION_CONTAINER_TYPE = org.objectweb.asm.Type.getType(ExtensionContainer.class);
        private static final org.objectweb.asm.Type DESCRIBABLE_TYPE = org.objectweb.asm.Type.getType(Describable.class);
        private static final org.objectweb.asm.Type DISPLAY_NAME_TYPE = org.objectweb.asm.Type.getType(DisplayName.class);
        private static final org.objectweb.asm.Type INJECT_TYPE = org.objectweb.asm.Type.getType(Inject.class);
        private static final String RETURN_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)STRING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_DESCRIBABLE = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DESCRIBABLE_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, CLASS_TYPE, DYNAMIC_OBJECT_TYPE, SERVICE_LOOKUP_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, STRING_TYPE, org.objectweb.asm.Type.BOOLEAN_TYPE});
        private static final String RETURN_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_BOOLEAN = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CONVENTION_AWARE_TYPE, CONVENTION_TYPE});
        private static final String RETURN_CONVENTION = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_CONVENTION_MAPPING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_EXTENSION_CONTAINER = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)EXTENSION_CONTAINER_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_OBJECT_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_STRING_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_DYNAMIC_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)DYNAMIC_OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS_FROM_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLASS_TYPE});
        private static final String RETURN_BOOLEAN_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)BOOLEAN_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String RETURN_META_CLASS_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_REGISTRY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_REGISTRY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_SERVICE_LOOKUP = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)SERVICE_LOOKUP_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_MANAGED_OBJECT_FACTORY = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)MANAGED_OBJECT_FACTORY_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)META_CLASS_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
        private static final String RETURN_VOID_FROM_META_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{META_CLASS_TYPE});
        private static final String GET_DECLARED_METHOD_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)METHOD_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, CLASS_ARRAY_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_MODEL_OBJECT = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, DISPLAY_NAME_TYPE});
        private static final String RETURN_OBJECT_FROM_TYPE = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE});
        private static final String RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE, STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_VOID_FROM_STRING = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE});
        private static final String[] EMPTY_STRINGS = new String[0];
        private static final org.objectweb.asm.Type[] EMPTY_TYPES = new org.objectweb.asm.Type[0];
        private final ClassWriter visitor;
        private final Class<?> type;
        private final boolean managed;
        private final org.objectweb.asm.Type generatedType;
        private final org.objectweb.asm.Type superclassType;
        private final Map<Type, ReturnTypeEntry> genericReturnTypeConstantsIndex = Maps.newHashMap();
        private final AsmClassGenerator classGenerator;
        private final int factoryId;
        private boolean hasMappingField;
        private final boolean conventionAware;
        private final boolean mixInDsl;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;
        private final boolean requiresToString;
        private final List<Pair<AbstractClassGenerator.PropertyMetadata, Boolean>> propertiesToAttach;
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties;
        private final boolean requiresServicesMethod;
        private final boolean requiresFactory;

        private ClassBuilderImpl(Class<?> type, boolean decorated, String suffix, int factoryId, boolean extensible, boolean conventionAware, boolean managed, boolean providesOwnDynamicObject, boolean requiresToString, boolean requiresServicesMethod, boolean requiresFactory, List<Pair<AbstractClassGenerator.PropertyMetadata, Boolean>> propertiesToAttach, List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties) {
            this.type = type;
            this.factoryId = factoryId;
            this.managed = managed;
            this.requiresToString = requiresToString;
            this.propertiesToAttach = propertiesToAttach;
            this.classGenerator = new AsmClassGenerator(type, suffix);
            this.visitor = this.classGenerator.getVisitor();
            this.generatedType = this.classGenerator.getGeneratedType();
            this.superclassType = org.objectweb.asm.Type.getType(type);
            this.mixInDsl = decorated;
            this.extensible = extensible;
            this.conventionAware = conventionAware;
            this.providesOwnDynamicObject = providesOwnDynamicObject;
            this.requiresServicesMethod = requiresServicesMethod;
            this.requiresFactory = requiresFactory;
            this.ineligibleProperties = ineligibleProperties;
        }

        public void startClass() {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            org.objectweb.asm.Type superclass = this.superclassType;
            if (this.type.isInterface()) {
                interfaceTypes.add(this.superclassType.getInternalName());
                superclass = OBJECT_TYPE;
            }
            interfaceTypes.add(GENERATED_SUBCLASS_TYPE.getInternalName());
            interfaceTypes.add(MODEL_OBJECT_TYPE.getInternalName());
            interfaceTypes.add(OWNER_AWARE_TYPE.getInternalName());
            if (this.conventionAware) {
                interfaceTypes.add(CONVENTION_AWARE_TYPE.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(EXTENSION_AWARE_TYPE.getInternalName());
                interfaceTypes.add(HAS_CONVENTION_TYPE.getInternalName());
            }
            if (this.mixInDsl) {
                interfaceTypes.add(DYNAMIC_OBJECT_AWARE_TYPE.getInternalName());
                interfaceTypes.add(GROOVY_OBJECT_TYPE.getInternalName());
            }
            if (this.managed) {
                interfaceTypes.add(MANAGED_TYPE.getInternalName());
            }
            this.includeNotInheritedAnnotations();
            this.visitor.visit(52, 4097, this.generatedType.getInternalName(), null, superclass.getInternalName(), interfaceTypes.toArray(EMPTY_STRINGS));
            this.generateInitMethod();
            this.generateGeneratedSubtypeMethods();
            this.generateModelObjectMethods();
            if (this.requiresToString) {
                this.generateToStringSupport();
            }
            if (this.requiresServicesMethod) {
                this.generateServiceRegistrySupport();
            }
            if (this.requiresFactory) {
                this.generateManagedPropertyCreationSupport();
            }
        }

        @Override
        public void addDefaultConstructor() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", RETURN_VOID, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", RETURN_VOID, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), INIT_METHOD, RETURN_VOID, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addNameConstructor() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", RETURN_VOID_FROM_STRING, null, EMPTY_STRINGS);
            methodVisitor.visitAnnotation(INJECT_TYPE.getDescriptor(), true).visitEnd();
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", RETURN_VOID, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), NAME_FIELD, STRING_TYPE.getDescriptor());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), INIT_METHOD, RETURN_VOID, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addConstructor(Constructor<?> constructor, boolean addNameParameter) {
            void var7_12;
            int stackVar;
            String methodDescriptor;
            ArrayList<org.objectweb.asm.Type> paramTypes = new ArrayList<org.objectweb.asm.Type>();
            for (Class<?> clazz : constructor.getParameterTypes()) {
                paramTypes.add(org.objectweb.asm.Type.getType(clazz));
            }
            String superMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(EMPTY_TYPES));
            if (addNameParameter) {
                paramTypes.add(0, STRING_TYPE);
                methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])paramTypes.toArray(EMPTY_TYPES));
            } else {
                methodDescriptor = superMethodDescriptor;
            }
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "<init>", methodDescriptor, AsmClassGeneratorUtils.signature(constructor, addNameParameter), EMPTY_STRINGS);
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(org.objectweb.asm.Type.getType(annotation.annotationType()).getDescriptor(), retention != null && retention.value() == RetentionPolicy.RUNTIME);
                annotationVisitor.visitEnd();
            }
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            boolean bl = addNameParameter;
            int n = stackVar = addNameParameter ? 2 : 1;
            while (var7_12 < paramTypes.size()) {
                org.objectweb.asm.Type argType = (org.objectweb.asm.Type)paramTypes.get((int)var7_12);
                methodVisitor.visitVarInsn(argType.getOpcode(21), stackVar);
                stackVar += argType.getSize();
                ++var7_12;
            }
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", superMethodDescriptor, false);
            if (addNameParameter) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), NAME_FIELD, STRING_TYPE.getDescriptor());
            }
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), INIT_METHOD, RETURN_VOID, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateInitMethod() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(4098, INIT_METHOD, RETURN_VOID, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            this.initializeFields(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void initializeFields(MethodVisitor methodVisitor) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE, false);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor());
            if (this.requiresServicesMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP, false);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor());
            }
            if (this.requiresFactory) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY, false);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE.getDescriptor());
            }
            for (Pair<AbstractClassGenerator.PropertyMetadata, Boolean> entry : this.propertiesToAttach) {
                AbstractClassGenerator.PropertyMetadata property = (AbstractClassGenerator.PropertyMetadata)entry.left;
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), property.getMainGetter().getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(property.getMainGetter().getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
                if (((Boolean)entry.right).booleanValue()) {
                    methodVisitor.visitInsn(89);
                }
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn((Object)property.getName());
                methodVisitor.visitMethodInsn(184, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING, false);
                if (!((Boolean)entry.right).booleanValue()) continue;
                this.applyRoleTo(methodVisitor);
            }
            if (this.conventionAware && IConventionAware.class.isAssignableFrom(this.type)) {
                for (AbstractClassGenerator.PropertyMetadata property : this.ineligibleProperties) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getConventionMapping", RETURN_CONVENTION_MAPPING, false);
                    methodVisitor.visitLdcInsn((Object)property.getName());
                    methodVisitor.visitMethodInsn(185, CONVENTION_MAPPING_TYPE.getInternalName(), "ineligible", RETURN_VOID_FROM_STRING, true);
                }
            }
        }

        @Override
        public void addExtensionsProperty() {
            this.addGetter("getExtensions", EXTENSION_CONTAINER_TYPE, RETURN_EXTENSION_CONTAINER, null, visitor -> {
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
            });
        }

        @Override
        public void mixInDynamicAware() {
            if (!this.mixInDsl) {
                return;
            }
            this.visitor.visitField(130, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE.getDescriptor(), null, null);
            if (this.extensible) {
                this.addGetter("getConvention", CONVENTION_TYPE, RETURN_CONVENTION, null, visitor -> {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                    visitor.visitTypeInsn(192, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                    visitor.visitMethodInsn(182, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                });
            }
            this.addLazyGetter("getAsDynamicObject", DYNAMIC_OBJECT_TYPE, RETURN_DYNAMIC_OBJECT, null, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE, this::generateCreateDynamicObject);
        }

        private void generateCreateDynamicObject(MethodVisitor visitor) {
            if (this.extensible) {
                visitor.visitTypeInsn(187, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getClass", RETURN_CLASS, false);
                visitor.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getSuperclass", RETURN_CLASS, false);
                if (this.providesOwnDynamicObject) {
                    visitor.visitVarInsn(25, 0);
                    visitor.visitMethodInsn(183, org.objectweb.asm.Type.getType(this.type).getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                } else {
                    visitor.visitInsn(1);
                }
                this.putServiceRegistryOnStack(visitor);
                visitor.visitMethodInsn(183, EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP, false);
            } else {
                visitor.visitTypeInsn(187, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(183, NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_OBJECT, false);
            }
        }

        @Override
        public void mixInConventionAware() {
            this.visitor.visitField(130, MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR, null, null);
            this.hasMappingField = true;
            MethodCodeBody initConventionAwareHelper = visitor -> {
                visitor.visitTypeInsn(187, CONVENTION_AWARE_HELPER_TYPE.getInternalName());
                visitor.visitInsn(89);
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false);
                visitor.visitMethodInsn(183, CONVENTION_AWARE_HELPER_TYPE.getInternalName(), "<init>", RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION, false);
                for (AbstractClassGenerator.PropertyMetadata property : this.ineligibleProperties) {
                    visitor.visitInsn(89);
                    visitor.visitLdcInsn((Object)property.getName());
                    visitor.visitMethodInsn(185, CONVENTION_MAPPING_TYPE.getInternalName(), "ineligible", RETURN_VOID_FROM_STRING, true);
                }
            };
            this.addLazyGetter("getConventionMapping", CONVENTION_MAPPING_TYPE, RETURN_CONVENTION_MAPPING, null, MAPPING_FIELD, CONVENTION_MAPPING_TYPE, initConventionAwareHelper);
        }

        @Override
        public void mixInGroovyObject() {
            if (!this.mixInDsl) {
                return;
            }
            this.visitor.visitField(130, META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR, null, null);
            MethodCodeBody initMetaClass = visitor -> {
                visitor.visitMethodInsn(184, GROOVY_SYSTEM_TYPE.getInternalName(), "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY, false);
                visitor.visitVarInsn(25, 0);
                visitor.visitMethodInsn(182, OBJECT_TYPE.getInternalName(), "getClass", RETURN_CLASS, false);
                visitor.visitMethodInsn(185, META_CLASS_REGISTRY_TYPE.getInternalName(), "getMetaClass", RETURN_META_CLASS_FROM_CLASS, true);
            };
            this.addLazyGetter("getMetaClass", META_CLASS_TYPE, RETURN_META_CLASS, null, META_CLASS_FIELD, META_CLASS_TYPE, initMetaClass);
            this.addSetter("setMetaClass", RETURN_VOID_FROM_META_CLASS, visitor -> {
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 1);
                visitor.visitFieldInsn(181, this.generatedType.getInternalName(), META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
            });
        }

        private void addSetter(String methodName, String methodDescriptor, MethodCodeBody body) {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addPropertySetterOverloads(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
            if (!this.mixInDsl) {
                return;
            }
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, MetaProperty.getSetterName((String)property.getName()), RETURN_VOID_FROM_OBJECT, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
            methodVisitor.visitTypeInsn(192, PROPERTY_INTERNAL_TYPE.getInternalName());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, PROPERTY_INTERNAL_TYPE.getInternalName(), "setFromAnyValue", RETURN_VOID_FROM_OBJECT, true);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void addLazyGetter(String methodName, org.objectweb.asm.Type returnType, String methodDescriptor, @Nullable String signature, String fieldName, org.objectweb.asm.Type fieldType, MethodCodeBody initializer) {
            this.addGetter(methodName, returnType, methodDescriptor, signature, visitor -> {
                visitor.visitVarInsn(25, 0);
                visitor.visitFieldInsn(180, this.generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                visitor.visitVarInsn(58, 1);
                visitor.visitVarInsn(25, 1);
                Label returnValue = new Label();
                visitor.visitJumpInsn(199, returnValue);
                initializer.add(visitor);
                visitor.visitVarInsn(58, 1);
                visitor.visitVarInsn(25, 0);
                visitor.visitVarInsn(25, 1);
                visitor.visitFieldInsn(181, this.generatedType.getInternalName(), fieldName, fieldType.getDescriptor());
                visitor.visitLabel(returnValue);
                visitor.visitVarInsn(25, 1);
            });
        }

        private void addGetter(String methodName, org.objectweb.asm.Type returnType, String methodDescriptor, @Nullable String signature, MethodCodeBody body) {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, methodName, methodDescriptor, signature, EMPTY_STRINGS);
            methodVisitor.visitCode();
            body.add(methodVisitor);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addDynamicMethods() {
            if (!this.mixInDsl) {
                return;
            }
            this.addGetter("getProperty", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING, null, methodVisitor -> {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "getProperty", RETURN_OBJECT_FROM_STRING, true);
            });
            MethodVisitor methodVisitor2 = this.visitor.visitMethod(1, "hasProperty", RETURN_BOOLEAN_FROM_STRING, null, EMPTY_STRINGS);
            methodVisitor2.visitCode();
            methodVisitor2.visitVarInsn(25, 0);
            methodVisitor2.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
            methodVisitor2.visitVarInsn(25, 1);
            methodVisitor2.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "hasProperty", RETURN_BOOLEAN_FROM_STRING, true);
            methodVisitor2.visitInsn(172);
            methodVisitor2.visitMaxs(0, 0);
            methodVisitor2.visitEnd();
            this.addSetter("setProperty", RETURN_VOID_FROM_STRING_OBJECT, setter -> {
                setter.visitVarInsn(25, 0);
                setter.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                setter.visitVarInsn(25, 1);
                setter.visitVarInsn(25, 2);
                setter.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "setProperty", RETURN_VOID_FROM_STRING_OBJECT, true);
            });
            this.addGetter("invokeMethod", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING_OBJECT, null, getter -> {
                String invokeMethodDesc = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{STRING_TYPE, OBJECT_ARRAY_TYPE});
                getter.visitVarInsn(25, 0);
                getter.visitMethodInsn(182, this.generatedType.getInternalName(), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT, false);
                getter.visitVarInsn(25, 1);
                getter.visitVarInsn(25, 2);
                getter.visitTypeInsn(193, OBJECT_ARRAY_TYPE.getDescriptor());
                Label end = new Label();
                Label notArray = new Label();
                getter.visitJumpInsn(153, notArray);
                getter.visitVarInsn(25, 2);
                getter.visitTypeInsn(192, OBJECT_ARRAY_TYPE.getDescriptor());
                getter.visitJumpInsn(167, end);
                getter.visitLabel(notArray);
                getter.visitInsn(4);
                getter.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
                getter.visitInsn(89);
                getter.visitInsn(3);
                getter.visitVarInsn(25, 2);
                getter.visitInsn(83);
                getter.visitLabel(end);
                getter.visitMethodInsn(185, DYNAMIC_OBJECT_TYPE.getInternalName(), "invokeMethod", invokeMethodDesc, true);
            });
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property) {
            String fieldName = AsmBackedClassGenerator.propFieldName(property);
            this.visitor.visitField(130, fieldName, org.objectweb.asm.Type.getDescriptor(property.getType()), null, null);
        }

        private void generateServicesField() {
            this.visitor.visitField(4226, SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor(), null, null);
        }

        private void generateGetServices() {
            MethodVisitor mv = this.visitor.visitMethod(4098, SERVICES_METHOD, RETURN_SERVICE_LOOKUP, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedType.getInternalName(), SERVICES_FIELD, SERVICE_LOOKUP_TYPE.getDescriptor());
            mv.visitInsn(89);
            Label label = new Label();
            mv.visitJumpInsn(198, label);
            mv.visitInsn(176);
            mv.visitLabel(label);
            mv.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP, false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter) {
            this.applyServiceInjectionToGetter(property, null, getter);
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property, @Nullable Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
            String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            org.objectweb.asm.Type serviceType = org.objectweb.asm.Type.getType(property.getType());
            Type genericServiceType = property.getGenericType();
            String propFieldName = AsmBackedClassGenerator.propFieldName(property);
            String signature = AsmClassGeneratorUtils.getterSignature(getter.getGenericReturnType());
            this.addLazyGetter(getterName, returnType, methodDescriptor, signature, propFieldName, serviceType, methodVisitor -> {
                this.putServiceRegistryOnStack(methodVisitor);
                if (genericServiceType instanceof Class) {
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)((Class)genericServiceType)));
                } else {
                    String constantFieldName = this.getConstantNameForGenericReturnType(genericServiceType, getterName);
                    methodVisitor.visitFieldInsn(178, this.generatedType.getInternalName(), constantFieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                }
                if (annotation == null) {
                    methodVisitor.visitMethodInsn(185, SERVICE_LOOKUP_TYPE.getInternalName(), "get", RETURN_OBJECT_FROM_TYPE, true);
                } else {
                    methodVisitor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)annotation));
                    methodVisitor.visitMethodInsn(185, SERVICE_LOOKUP_TYPE.getInternalName(), "get", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)OBJECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{JAVA_LANG_REFLECT_TYPE, CLASS_TYPE}), true);
                }
                methodVisitor.visitTypeInsn(192, serviceType.getInternalName());
            });
        }

        private void putServiceRegistryOnStack(MethodVisitor methodVisitor) {
            if (this.requiresServicesMethod) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), SERVICES_METHOD, RETURN_SERVICE_LOOKUP, false);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), "getServices", RETURN_SERVICE_REGISTRY, false);
            }
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Class<? extends Annotation> annotation, Method setter) {
            this.applyServiceInjectionToSetter(property, setter);
        }

        private String getConstantNameForGenericReturnType(Type genericReturnType, String getterName) {
            ReturnTypeEntry entry = this.genericReturnTypeConstantsIndex.get(genericReturnType);
            if (entry == null) {
                String fieldName = "_GENERIC_RETURN_TYPE_" + this.genericReturnTypeConstantsIndex.size();
                entry = new ReturnTypeEntry(fieldName, getterName);
                this.genericReturnTypeConstantsIndex.put(genericReturnType, entry);
            }
            return entry.fieldName;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property) {
            String fieldName = AsmBackedClassGenerator.propFieldName(property);
            this.visitor.visitField(2, fieldName, org.objectweb.asm.Type.getDescriptor(property.getType()), null, null);
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter, boolean applyRole) {
            org.objectweb.asm.Type propType = org.objectweb.asm.Type.getType(property.getType());
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            this.addLazyGetter(getter.getName(), returnType, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, AsmBackedClassGenerator.propFieldName(property), propType, methodVisitor -> {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY, false);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn((Object)property.getName());
                int typeParamCount = property.getType().getTypeParameters().length;
                if (typeParamCount == 1) {
                    org.objectweb.asm.Type elementType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 0));
                    methodVisitor.visitLdcInsn((Object)propType);
                    methodVisitor.visitLdcInsn((Object)elementType);
                    methodVisitor.visitMethodInsn(182, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS, false);
                } else if (typeParamCount == 2) {
                    org.objectweb.asm.Type keyType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 0));
                    org.objectweb.asm.Type elementType = org.objectweb.asm.Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property, 1));
                    methodVisitor.visitLdcInsn((Object)propType);
                    methodVisitor.visitLdcInsn((Object)keyType);
                    methodVisitor.visitLdcInsn((Object)elementType);
                    methodVisitor.visitMethodInsn(182, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS, false);
                } else {
                    methodVisitor.visitLdcInsn((Object)propType);
                    methodVisitor.visitMethodInsn(182, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS, false);
                }
                if (applyRole) {
                    methodVisitor.visitInsn(89);
                    this.applyRoleTo(methodVisitor);
                }
                methodVisitor.visitTypeInsn(192, propType.getInternalName());
            });
        }

        private void applyRoleTo(MethodVisitor methodVisitor) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY, false);
            methodVisitor.visitInsn(95);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "applyRole", RETURN_VOID_FROM_OBJECT_MODEL_OBJECT, false);
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property, Method getter) {
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            String fieldName = AsmBackedClassGenerator.propFieldName(property);
            this.addGetter(getter.getName(), returnType, methodDescriptor, null, methodVisitor -> {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), fieldName, returnType.getDescriptor());
            });
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            this.addSetterForProperty(property, setter);
        }

        private void addSetterForProperty(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)setter);
            org.objectweb.asm.Type fieldType = org.objectweb.asm.Type.getType(property.getType());
            String propFieldName = AsmBackedClassGenerator.propFieldName(property);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), methodDescriptor, AsmClassGeneratorUtils.signature(setter), EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(fieldType.getOpcode(21), 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, fieldType.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateGeneratedSubtypeMethods() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "publicType", RETURN_CLASS, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)this.superclassType);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(9, "generatedFrom", RETURN_CLASS, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)this.superclassType);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateModelObjectMethods() {
            this.visitor.visitField(4098, DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor(), null, null);
            this.visitor.visitField(4098, OWNER_FIELD, MODEL_OBJECT_TYPE.getDescriptor(), null, null);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "hasUsefulDisplayName", RETURN_BOOLEAN, null, EMPTY_STRINGS);
            if (this.requiresToString) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor());
                Label label = new Label();
                methodVisitor.visitJumpInsn(198, label);
                methodVisitor.visitLdcInsn((Object)true);
                methodVisitor.visitInsn(BOOLEAN_TYPE.getOpcode(172));
                methodVisitor.visitLabel(label);
                methodVisitor.visitLdcInsn((Object)false);
                methodVisitor.visitInsn(BOOLEAN_TYPE.getOpcode(172));
            } else {
                methodVisitor.visitLdcInsn((Object)true);
                methodVisitor.visitInsn(BOOLEAN_TYPE.getOpcode(172));
            }
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "getModelIdentityDisplayName", RETURN_DESCRIBABLE, null, EMPTY_STRINGS);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor());
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "getTaskThatOwnsThisObject", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Task.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, EMPTY_STRINGS);
            if (Task.class.isAssignableFrom(this.type)) {
                methodVisitor.visitVarInsn(25, 0);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), OWNER_FIELD, MODEL_OBJECT_TYPE.getDescriptor());
                methodVisitor.visitInsn(89);
                Label useNull = new Label();
                methodVisitor.visitJumpInsn(198, useNull);
                methodVisitor.visitMethodInsn(185, MODEL_OBJECT_TYPE.getInternalName(), "getTaskThatOwnsThisObject", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Task.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), true);
                methodVisitor.visitLabel(useNull);
            }
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "attachOwner", RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME, null, EMPTY_STRINGS);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), OWNER_FIELD, MODEL_OBJECT_TYPE.getDescriptor());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor());
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addManagedMethods(Iterable<AbstractClassGenerator.PropertyMetadata> mutableProperties, Iterable<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
            this.visitor.visitField(10, FACTORY_ID_FIELD, org.objectweb.asm.Type.INT_TYPE.getDescriptor(), null, null);
            MethodVisitor methodVisitor = this.visitor.visitMethod(4097, "<init>", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{OBJECT_ARRAY_TYPE}), null, EMPTY_STRINGS);
            methodVisitor.visitVarInsn(25, 0);
            if (this.type.isInterface()) {
                methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", RETURN_VOID, false);
            } else {
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), "<init>", RETURN_VOID, false);
            }
            int propertyIndex = 0;
            for (AbstractClassGenerator.PropertyMetadata propertyMetadata : mutableProperties) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn((Object)propertyIndex);
                methodVisitor.visitInsn(50);
                AsmClassGeneratorUtils.unboxOrCast(methodVisitor, org.objectweb.asm.Type.getType(propertyMetadata.getType()));
                String propFieldName = AsmBackedClassGenerator.propFieldName(propertyMetadata);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, org.objectweb.asm.Type.getType(propertyMetadata.getType()).getDescriptor());
                ++propertyIndex;
            }
            int mutablePropertySize = propertyIndex;
            propertyIndex = 0;
            for (AbstractClassGenerator.PropertyMetadata propertyMetaData : readOnlyProperties) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn((Object)(propertyIndex + mutablePropertySize));
                methodVisitor.visitInsn(50);
                AsmClassGeneratorUtils.unboxOrCast(methodVisitor, org.objectweb.asm.Type.getType(propertyMetaData.getType()));
                String propFieldName = AsmBackedClassGenerator.propFieldName(propertyMetaData);
                methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), propFieldName, org.objectweb.asm.Type.getType(propertyMetaData.getType()).getDescriptor());
                ++propertyIndex;
            }
            int n = propertyIndex;
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "isImmutable", RETURN_BOOLEAN, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)(mutablePropertySize == 0 && n == 0 ? 1 : 0));
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "unpackState", RETURN_OBJECT, null, EMPTY_STRINGS);
            methodVisitor.visitLdcInsn((Object)(mutablePropertySize + n));
            methodVisitor.visitTypeInsn(189, OBJECT_TYPE.getInternalName());
            propertyIndex = 0;
            for (AbstractClassGenerator.PropertyMetadata property : mutableProperties) {
                String propFieldName = AsmBackedClassGenerator.propFieldName(property);
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)propertyIndex);
                methodVisitor.visitVarInsn(25, 0);
                org.objectweb.asm.Type propertyType = org.objectweb.asm.Type.getType(property.getType());
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), propFieldName, propertyType.getDescriptor());
                this.maybeBox(methodVisitor, property.getType(), propertyType);
                methodVisitor.visitInsn(83);
                ++propertyIndex;
            }
            propertyIndex = 0;
            for (AbstractClassGenerator.PropertyMetadata property : readOnlyProperties) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)(propertyIndex + mutablePropertySize));
                methodVisitor.visitVarInsn(25, 0);
                AbstractClassGenerator.MethodMetadata getter = property.getMainGetter();
                methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), getter.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(getter.getReturnType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
                this.maybeBox(methodVisitor, property.getType(), org.objectweb.asm.Type.getType(property.getType()));
                methodVisitor.visitInsn(83);
                ++propertyIndex;
            }
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = this.visitor.visitMethod(1, "getFactoryId", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.INT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, EMPTY_STRINGS);
            methodVisitor.visitFieldInsn(178, this.generatedType.getInternalName(), FACTORY_ID_FIELD, org.objectweb.asm.Type.INT_TYPE.getDescriptor());
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property) {
            if (!this.conventionAware) {
                return;
            }
            String flagName = AsmBackedClassGenerator.propFieldName(property);
            this.visitor.visitField(130, flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property, AbstractClassGenerator.MethodMetadata getter, boolean attachOwner, boolean applyRole) {
            if (!this.conventionAware && !attachOwner) {
                return;
            }
            String getterName = getter.getName();
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(getter.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, getterName, methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            if (this.conventionAware) {
                Label finish = new Label();
                if (this.hasMappingField) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
                    Label useConvention = new Label();
                    methodVisitor.visitJumpInsn(199, useConvention);
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, this.type.isInterface());
                    methodVisitor.visitJumpInsn(167, finish);
                    methodVisitor.visitLabel(useConvention);
                }
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(185, CONVENTION_AWARE_TYPE.getInternalName(), "getConventionMapping", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)CONVENTION_MAPPING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), true);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, this.type.isInterface());
                this.maybeBox(methodVisitor, getter.getReturnType(), returnType);
                methodVisitor.visitLdcInsn((Object)property.getName());
                String flagName = AsmBackedClassGenerator.propFieldName(property);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), flagName, org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
                methodVisitor.visitMethodInsn(185, CONVENTION_MAPPING_TYPE.getInternalName(), "getConventionValue", RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN, true);
                AsmClassGeneratorUtils.unboxOrCast(methodVisitor, returnType);
                methodVisitor.visitLabel(finish);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), getterName, methodDescriptor, this.type.isInterface());
            }
            if (attachOwner) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn((Object)property.getName());
                methodVisitor.visitMethodInsn(184, MANAGED_OBJECT_FACTORY_TYPE.getInternalName(), "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING, false);
                methodVisitor.visitInsn(87);
                if (applyRole) {
                    methodVisitor.visitInsn(89);
                    this.applyRoleTo(methodVisitor);
                }
            }
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void maybeBox(MethodVisitor methodVisitor, Class<?> valueClass, org.objectweb.asm.Type valueType) {
            if (valueClass.isPrimitive()) {
                org.objectweb.asm.Type boxedType = org.objectweb.asm.Type.getType((Class)JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueClass));
                String valueOfMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)boxedType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{valueType});
                methodVisitor.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", valueOfMethodDescriptor, false);
            }
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.conventionAware) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, setter.getName(), setterDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), AsmBackedClassGenerator.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata property, Method setter) {
            if (!this.mixInDsl) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(setter.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(setter.getReturnType());
            String setterDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            String setMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.VOID_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, property.getName(), setMethodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), setter.getName(), setterDescriptor, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property, Method method) {
            if (!this.mixInDsl || !this.conventionAware) {
                return;
            }
            org.objectweb.asm.Type paramType = org.objectweb.asm.Type.getType(method.getParameterTypes()[0]);
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{paramType});
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(paramType.getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.superclassType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn((Object)true);
            methodVisitor.visitFieldInsn(181, this.generatedType.getInternalName(), AsmBackedClassGenerator.propFieldName(property), org.objectweb.asm.Type.BOOLEAN_TYPE.getDescriptor());
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        @Override
        public void addActionMethod(Method method) {
            if (!this.mixInDsl) {
                return;
            }
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(method.getReturnType());
            org.objectweb.asm.Type[] originalParameterTypes = (org.objectweb.asm.Type[])CollectionUtils.collectArray((Object[])method.getParameterTypes(), org.objectweb.asm.Type.class, org.objectweb.asm.Type::getType);
            int numParams = originalParameterTypes.length;
            org.objectweb.asm.Type[] closurisedParameterTypes = new org.objectweb.asm.Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = CLOSURE_TYPE;
            String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnType, (org.objectweb.asm.Type[])closurisedParameterTypes);
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, method.getName(), methodDescriptor, null, EMPTY_STRINGS);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            int stackVar = 1;
            for (int typeVar = 0; typeVar < numParams - 1; ++typeVar) {
                org.objectweb.asm.Type argType = closurisedParameterTypes[typeVar];
                methodVisitor.visitVarInsn(argType.getOpcode(21), stackVar);
                stackVar += argType.getSize();
            }
            methodVisitor.visitVarInsn(25, stackVar);
            methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)ACTION_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{CLOSURE_TYPE});
            methodVisitor.visitMethodInsn(184, CONFIGURE_UTIL_TYPE.getInternalName(), "configureUsing", methodDescriptor, false);
            methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(method.getReturnType()), (org.objectweb.asm.Type[])originalParameterTypes);
            methodVisitor.visitMethodInsn(182, this.generatedType.getInternalName(), method.getName(), methodDescriptor, false);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateToStringSupport() {
            MethodVisitor methodVisitor = this.visitor.visitMethod(1, "toString", RETURN_STRING, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE.getDescriptor());
            methodVisitor.visitInsn(89);
            Label label1 = new Label();
            methodVisitor.visitJumpInsn(198, label1);
            methodVisitor.visitMethodInsn(185, DESCRIBABLE_TYPE.getInternalName(), "getDisplayName", RETURN_STRING, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(label1);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE, false);
            methodVisitor.visitInsn(89);
            Label label2 = new Label();
            methodVisitor.visitJumpInsn(198, label2);
            methodVisitor.visitMethodInsn(185, DESCRIBABLE_TYPE.getInternalName(), "getDisplayName", RETURN_STRING, true);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(label2);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "toString", RETURN_STRING, false);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }

        private void generateServiceRegistrySupport() {
            this.generateServicesField();
            this.generateGetServices();
        }

        private void generateManagedPropertyCreationSupport() {
            this.generateManagedObjectFactoryField();
            this.generateGetManagedObjectFactory();
        }

        private void generateManagedObjectFactoryField() {
            this.visitor.visitField(4226, FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE.getDescriptor(), null, null);
        }

        private void generateGetManagedObjectFactory() {
            MethodVisitor mv = this.visitor.visitMethod(4098, FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedType.getInternalName(), FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE.getDescriptor());
            mv.visitInsn(89);
            Label label = new Label();
            mv.visitJumpInsn(198, label);
            mv.visitInsn(176);
            mv.visitLabel(label);
            mv.visitMethodInsn(184, ASM_BACKED_CLASS_GENERATOR_TYPE.getInternalName(), AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY, false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void includeNotInheritedAnnotations() {
            for (Annotation annotation : this.type.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                boolean visible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
                AnnotationVisitor annotationVisitor = this.visitor.visitAnnotation(org.objectweb.asm.Type.getType(annotation.annotationType()).getDescriptor(), visible);
                this.visitAnnotationValues(annotation, annotationVisitor);
                annotationVisitor.visitEnd();
            }
        }

        private void visitAnnotationValues(Annotation annotation, AnnotationVisitor annotationVisitor) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (returnType.isEnum()) {
                    annotationVisitor.visitEnum(name, org.objectweb.asm.Type.getType(returnType).getDescriptor(), this.getAnnotationParameterValue(annotation, method).toString());
                    continue;
                }
                if (returnType.isArray() && !PRIMITIVE_TYPES.contains(returnType.getComponentType())) {
                    AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                    Object[] elements = (Object[])this.getAnnotationParameterValue(annotation, method);
                    this.visitArrayElements(arrayVisitor, returnType.getComponentType(), elements);
                    arrayVisitor.visitEnd();
                    continue;
                }
                if (returnType.equals(Class.class)) {
                    Class clazz = (Class)this.getAnnotationParameterValue(annotation, method);
                    annotationVisitor.visit(name, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                    continue;
                }
                if (returnType.isAnnotation()) {
                    Annotation nestedAnnotation = (Annotation)this.getAnnotationParameterValue(annotation, method);
                    AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(name, org.objectweb.asm.Type.getType(returnType).getDescriptor());
                    this.visitAnnotationValues(nestedAnnotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                    continue;
                }
                annotationVisitor.visit(name, this.getAnnotationParameterValue(annotation, method));
            }
        }

        private void visitArrayElements(AnnotationVisitor arrayVisitor, Class arrayElementType, Object[] arrayElements) {
            if (arrayElementType.isEnum()) {
                String enumDescriptor = org.objectweb.asm.Type.getType((Class)arrayElementType).getDescriptor();
                for (Object value : arrayElements) {
                    arrayVisitor.visitEnum(null, enumDescriptor, value.toString());
                }
            } else if (arrayElementType.equals(Class.class)) {
                for (Object value : arrayElements) {
                    Class clazz = (Class)value;
                    arrayVisitor.visit(null, (Object)org.objectweb.asm.Type.getType((Class)clazz));
                }
            } else if (arrayElementType.isAnnotation()) {
                for (Object annotation : arrayElements) {
                    AnnotationVisitor nestedAnnotationVisitor = arrayVisitor.visitAnnotation(null, org.objectweb.asm.Type.getType((Class)arrayElementType).getDescriptor());
                    this.visitAnnotationValues((Annotation)annotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                }
            } else {
                for (Object value : arrayElements) {
                    arrayVisitor.visit(null, value);
                }
            }
        }

        private Object getAnnotationParameterValue(Annotation annotation, Method method) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private void attachFactoryIdToImplType(Class<?> implClass, int id) {
            try {
                Field factoryField = implClass.getDeclaredField(FACTORY_ID_FIELD);
                factoryField.setAccessible(true);
                factoryField.set(null, id);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        @Override
        public void addNameProperty() {
            this.visitor.visitField(4114, NAME_FIELD, STRING_TYPE.getDescriptor(), null, null);
            this.addGetter("getName", STRING_TYPE, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)STRING_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, methodVisitor -> {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.generatedType.getInternalName(), NAME_FIELD, STRING_TYPE.getDescriptor());
            });
        }

        @Override
        public Class<?> generate() {
            this.writeGenericReturnTypeFields();
            this.visitor.visitEnd();
            Class generatedClass = this.classGenerator.define();
            if (this.managed) {
                this.attachFactoryIdToImplType(generatedClass, this.factoryId);
            }
            return generatedClass;
        }

        private void writeGenericReturnTypeFields() {
            if (!this.genericReturnTypeConstantsIndex.isEmpty()) {
                MethodVisitor mv = this.visitor.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                for (Map.Entry<Type, ReturnTypeEntry> entry : this.genericReturnTypeConstantsIndex.entrySet()) {
                    ReturnTypeEntry returnType = entry.getValue();
                    this.visitor.visitField(4122, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR, null, null);
                    this.writeGenericReturnTypeFieldInitializer(mv, returnType);
                }
                mv.visitInsn(177);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
        }

        private void writeGenericReturnTypeFieldInitializer(MethodVisitor mv, ReturnTypeEntry returnType) {
            mv.visitLdcInsn((Object)this.generatedType);
            mv.visitLdcInsn((Object)returnType.getterName);
            mv.visitInsn(3);
            mv.visitTypeInsn(189, CLASS_TYPE.getInternalName());
            mv.visitMethodInsn(182, CLASS_TYPE.getInternalName(), "getDeclaredMethod", GET_DECLARED_METHOD_DESCRIPTOR, false);
            mv.visitMethodInsn(182, METHOD_TYPE.getInternalName(), "getGenericReturnType", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)JAVA_LANG_REFLECT_TYPE, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
            mv.visitFieldInsn(179, this.generatedType.getInternalName(), returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
        }

        private static final class ReturnTypeEntry {
            private final String fieldName;
            private final String getterName;

            private ReturnTypeEntry(String fieldName, String getterName) {
                this.fieldName = fieldName;
                this.getterName = getterName;
            }
        }
    }

    private static class ClassInspectionVisitorImpl
    implements AbstractClassGenerator.ClassInspectionVisitor {
        private final Class<?> type;
        private final boolean decorate;
        private final String suffix;
        private final int factoryId;
        private boolean extensible;
        private boolean serviceInjection;
        private boolean conventionAware;
        private boolean managed;
        private boolean providesOwnDynamicObjectImplementation;
        private boolean providesOwnServicesImplementation;
        private boolean providesOwnToStringImplementation;
        private boolean requiresFactory;
        private final List<Pair<AbstractClassGenerator.PropertyMetadata, Boolean>> propertiesToAttach = new ArrayList<Pair<AbstractClassGenerator.PropertyMetadata, Boolean>>();
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties = new ArrayList<AbstractClassGenerator.PropertyMetadata>();

        public ClassInspectionVisitorImpl(Class<?> type, boolean decorate, String suffix, int factoryId) {
            this.type = type;
            this.decorate = decorate;
            this.suffix = suffix;
            this.factoryId = factoryId;
        }

        @Override
        public void mixInServiceInjection() {
            this.serviceInjection = true;
        }

        @Override
        public void mixInExtensible() {
            if (this.decorate) {
                this.extensible = true;
            }
        }

        @Override
        public void mixInConventionAware() {
            if (this.decorate) {
                this.conventionAware = true;
            }
        }

        @Override
        public void mixInFullyManagedState() {
            this.managed = true;
        }

        @Override
        public void providesOwnServicesImplementation() {
            this.providesOwnServicesImplementation = true;
        }

        @Override
        public void providesOwnDynamicObjectImplementation() {
            this.providesOwnDynamicObjectImplementation = true;
        }

        @Override
        public void providesOwnToString() {
            this.providesOwnToStringImplementation = true;
        }

        @Override
        public void instantiatesNestedObjects() {
            this.requiresFactory = true;
        }

        @Override
        public void attachDuringConstruction(AbstractClassGenerator.PropertyMetadata property, boolean applyRole) {
            this.propertiesToAttach.add((Pair<AbstractClassGenerator.PropertyMetadata, Boolean>)Pair.of((Object)property, (Object)applyRole));
            if (applyRole) {
                this.requiresFactory = true;
            }
        }

        @Override
        public void markPropertyAsIneligibleForConventionMapping(AbstractClassGenerator.PropertyMetadata property) {
            this.ineligibleProperties.add(property);
        }

        @Override
        public AbstractClassGenerator.ClassGenerationVisitor builder() {
            if (!(this.decorate || this.serviceInjection || Modifier.isAbstract(this.type.getModifiers()))) {
                return new NoOpBuilder(this.type);
            }
            int modifiers = this.type.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is private.");
                throw new ClassGenerationException(formatter.toString());
            }
            if (Modifier.isFinal(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append((CharSequence)" is final.");
                throw new ClassGenerationException(formatter.toString());
            }
            boolean requiresServicesMethod = (this.extensible || this.serviceInjection) && !this.providesOwnServicesImplementation;
            boolean requiresToString = !this.providesOwnToStringImplementation;
            ClassBuilderImpl builder = new ClassBuilderImpl(this.type, this.decorate, this.suffix, this.factoryId, this.extensible, this.conventionAware, this.managed, this.providesOwnDynamicObjectImplementation, requiresToString, requiresServicesMethod, this.requiresFactory, this.propertiesToAttach, this.ineligibleProperties);
            builder.startClass();
            return builder;
        }
    }
}

