/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.List;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.nativeplatform.internal.modulemap.GenerateModuleMapFile;
import org.gradle.nativeplatform.internal.modulemap.ModuleMap;

public class NativeDependencyCache
implements Stoppable {
    private final PersistentCache cache;

    public NativeDependencyCache(CacheRepository cacheRepository) {
        this.cache = cacheRepository.cache("native-dep").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
    }

    public File getModuleMapFile(final ModuleMap moduleMap) {
        final String hash = moduleMap.getHashCode().toCompactString();
        return (File)this.cache.useCache((Factory)new Factory<File>(){

            public File create() {
                File dir = new File(NativeDependencyCache.this.cache.getBaseDir(), "maps/" + hash + "/" + moduleMap.getModuleName());
                File moduleMapFile = new File(dir, "module.modulemap");
                if (!moduleMapFile.isFile()) {
                    GenerateModuleMapFile.generateFile((File)moduleMapFile, (String)moduleMap.getModuleName(), (List)moduleMap.getPublicHeaderPaths());
                }
                return moduleMapFile;
            }
        });
    }

    public void stop() {
        this.cache.close();
    }
}

